/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.business.material.api.IMaterialInstoreApi;
import com.ejianc.business.plan.bean.BudgetInfoEntity;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.consts.NumberConsts;
import com.ejianc.business.plan.mapper.BudgetPlanMapper;
import com.ejianc.business.plan.service.IBudgetInfoService;
import com.ejianc.business.plan.service.IBudgetPlanItemChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetPlanService")
public class BudgetPlanServiceImpl
extends BaseServiceImpl<BudgetPlanMapper, BudgetPlanEntity>
implements IBudgetPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;
    @Autowired
    private IBudgetInfoService budgetInfoService;
    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;
    @Autowired
    private BudgetPlanMapper budgetPlanMapper;
    @Autowired
    IMaterialInstoreApi materialInstoreApi;

    @Override
    public CommonResponse<BudgetTemVO> getBudgetVOByProjectId(Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.budgetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u751f\u6548\u7684\u9879\u76ee\u9884\u7b97\uff01");
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)list.get(0));
        BudgetTemVO vo = (BudgetTemVO)BeanMapper.map((Object)((Object)budgetEntity), BudgetTemVO.class);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetVOByProjectIdAndKeys(Long projectId, List<Long> selectedKeys) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.budgetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u751f\u6548\u7684\u9879\u76ee\u9884\u7b97\uff01");
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)list.get(0));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"budget_id", (Object)budgetEntity.getId());
        wrapper.in((Object)"level_no", Arrays.asList(1, 2, 3));
        if (null != selectedKeys) {
            String tempSql = "(";
            for (Long buildingNo : selectedKeys) {
                tempSql = tempSql + " inner_code like '" + buildingNo + "%' or";
            }
            tempSql = tempSql.substring(0, tempSql.length() - 2);
            tempSql = tempSql + ")";
            wrapper.apply(tempSql, new Object[0]);
        }
        wrapper.ne((Object)"change_type", (Object)ChangeTypeEnum.\u4e2d\u6b62.getCode());
        wrapper.orderByAsc((Object)"tree_index");
        List detailList = this.budgetDetailService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO vo = (BudgetTemVO)BeanMapper.map((Object)((Object)budgetEntity), BudgetTemVO.class);
        List resultMapList = BeanMapper.mapList((Iterable)detailList, BudgetDetailTemVO.class);
        vo.setDetailList(resultMapList);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public CommonResponse<BudgetEntity> getBudgetByProjectId(Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.budgetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u751f\u6548\u7684\u9879\u76ee\u9884\u7b97\uff01");
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)list.get(0));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"budget_id", (Object)budgetEntity.getId());
        wrapper.ne((Object)"change_type", (Object)ChangeTypeEnum.\u4e2d\u6b62.getCode());
        wrapper.orderByAsc((Object)"tree_index");
        List detailList = this.budgetDetailService.list((Wrapper)wrapper);
        budgetEntity.setDetailList(detailList);
        return CommonResponse.success((Object)((Object)budgetEntity));
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetById(Long budgetId) {
        BudgetEntity budgetEntity = (BudgetEntity)((Object)this.budgetService.getById(budgetId));
        BudgetTemVO vo = (BudgetTemVO)BeanMapper.map((Object)((Object)budgetEntity), BudgetTemVO.class);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public CommonResponse<BudgetTemVO> getBudgetByIdAndBuildingNos(Long budgetId, List<Long> buildingNos) {
        BudgetEntity budgetEntity = (BudgetEntity)((Object)this.budgetService.getById(budgetId));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"budget_id", (Object)budgetEntity.getId());
        wrapper.in((Object)"level_no", Arrays.asList(1, 2, 3));
        wrapper.ne((Object)"change_type", (Object)ChangeTypeEnum.\u4e2d\u6b62.getCode());
        if (null != buildingNos && buildingNos.size() > 0) {
            String tempSql = "(";
            for (Long l : buildingNos) {
                tempSql = tempSql + " inner_code like '" + l + "%' or";
            }
            tempSql = tempSql.substring(0, tempSql.length() - 2);
            tempSql = tempSql + ")";
            wrapper.apply(tempSql, new Object[0]);
        }
        wrapper.orderByAsc((Object)"tree_index");
        List detailList = this.budgetDetailService.list((Wrapper)wrapper);
        List budgetDetailVOS = BeanMapper.mapList((Iterable)detailList, BudgetDetailVO.class);
        budgetDetailVOS.forEach(item -> {
            String[] split;
            Integer treeNumber = 0;
            Integer baseSystem = 100;
            Integer useNumber = 1000000;
            String treeIndex = item.getTreeIndex();
            for (String s : split = treeIndex.split("\\.")) {
                treeNumber = treeNumber + Integer.parseInt(s) * useNumber;
                useNumber = useNumber / baseSystem;
            }
            item.setTreeNumber(treeNumber);
        });
        Collections.sort(budgetDetailVOS, new Comparator<BudgetDetailVO>(){

            @Override
            public int compare(BudgetDetailVO o1, BudgetDetailVO o2) {
                return o1.getTreeNumber().compareTo(o2.getTreeNumber());
            }
        });
        detailList = BeanMapper.mapList((Iterable)budgetDetailVOS, BudgetDetailEntity.class);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (BudgetDetailEntity cdEntity : detailList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        BudgetTemVO budgetTemVO = (BudgetTemVO)BeanMapper.map((Object)((Object)budgetEntity), BudgetTemVO.class);
        List resultMapList = BeanMapper.mapList((Iterable)detailList, BudgetDetailTemVO.class);
        budgetTemVO.setDetailList(resultMapList);
        return CommonResponse.success((Object)budgetTemVO);
    }

    private CommonResponse<RecalculateVO> setBudgetInfo(RecalculateVO cal, int updateFlag) {
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = (BudgetEntity)((Object)this.budgetService.selectById(cal.getBudgetId()));
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = (BudgetEntity)((Object)budgetByProjectId.getData());
        }
        if (budgetEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97!");
        }
        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u7684\u660e\u7ec6!");
        }
        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));
        String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
        ArrayList<Long> level3Ids = new ArrayList<Long>(level3Map.keySet());
        QueryParam param = new QueryParam();
        List budgetInfoEntities = new ArrayList();
        if (level3Ids.size() > 0) {
            param.getParams().put("detail_id", new Parameter("in", level3Ids));
            param.getParams().put("yyear_month", new Parameter("eq", (Object)curMonth));
            budgetInfoEntities = this.budgetInfoService.queryList(param);
        }
        Map<Long, BudgetInfoEntity> infoMap = budgetInfoEntities.stream().collect(Collectors.toMap(k -> k.getDetailId(), k -> k));
        ArrayList<BudgetInfoEntity> newInfos = new ArrayList<BudgetInfoEntity>();
        for (Long id : level3Ids) {
            if (null != infoMap.get(id)) continue;
            BudgetInfoEntity entity = new BudgetInfoEntity();
            entity.setDetailId(id);
            entity.setProjectId(budgetEntity.getProjectId());
            entity.setYyearMonth(curMonth);
            newInfos.add(entity);
        }
        budgetInfoEntities.addAll(newInfos);
        BudgetPlanEntity budgetPlan = this.getBudgetPlan(cal);
        if (null != budgetPlan) {
            String endMonth = budgetPlan.getEndMonth();
            param = new QueryParam();
            param.getParams().put("plan_id", new Parameter("eq", (Object)budgetPlan.getId()));
            param.getParams().put("detail_id", new Parameter("in", level3Ids));
            if (curMonth.compareTo(endMonth) > 0) {
                param.getParams().put("yyear_month", new Parameter("eq", (Object)endMonth));
            } else {
                param.getParams().put("yyear_month", new Parameter("eq", (Object)curMonth));
            }
            List nowPlanItemEntities = this.budgetPlanItemService.queryList(param);
            Map<Long, BudgetPlanItemEntity> planMap = nowPlanItemEntities.stream().collect(Collectors.toMap(k -> k.getDetailId(), k -> k));
            if (curMonth.compareTo(endMonth) > 0) {
                param = new QueryParam();
                budgetInfoEntities.clear();
                if (level3Ids.size() > 0) {
                    param.getParams().put("detail_id", new Parameter("in", level3Ids));
                    param.getParams().put("yyear_month", new Parameter("eq", (Object)endMonth));
                    budgetInfoEntities = this.budgetInfoService.queryList(param);
                }
                infoMap = budgetInfoEntities.stream().collect(Collectors.toMap(k -> k.getDetailId(), k -> k));
                newInfos = new ArrayList();
                for (Long id : level3Ids) {
                    if (null != infoMap.get(id)) continue;
                    BudgetInfoEntity entity = new BudgetInfoEntity();
                    entity.setDetailId(id);
                    entity.setProjectId(budgetEntity.getProjectId());
                    entity.setYyearMonth(endMonth);
                    newInfos.add(entity);
                }
                budgetInfoEntities.addAll(newInfos);
            }
            for (BudgetInfoEntity entity : budgetInfoEntities) {
                BudgetPlanItemEntity planEntity = planMap.get(entity.getDetailId());
                if (null == planEntity) continue;
                entity.setPlanId(planEntity.getPlanId());
                entity.setPlanNum(planEntity.getPlanNum());
                entity.setPlanRatio(planEntity.getPlanRatio());
                entity.setFinishRatio(planEntity.getFinishRatio());
                entity.setFinishNum(planEntity.getFinishNum());
            }
            this.budgetInfoService.saveOrUpdateBatch(budgetInfoEntities);
            return CommonResponse.success();
        }
        if (updateFlag > 2) {
            HashMap<Long, BigDecimal> level4BudgetNumMap = new HashMap<Long, BigDecimal>();
            level4Map.forEach((k, v) -> level4BudgetNumMap.put((Long)k, v.stream().filter(s -> s.getMaterialPlanNum() != null).map(BudgetDetailEntity::getMaterialPlanNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            List instoreMaterialVOS = null;
            if (updateFlag == 3) {
                HashMap<String, Object> queryParam = new HashMap<String, Object>();
                queryParam.put("projectId", cal.getProjectId());
                queryParam.put("materialIds", new ArrayList<Long>(level4Map.keySet()));
                String currentDay = DateUtil.getCurrentDay(null);
                String endDay = "31";
                String _endMonthDate = curMonth + "-" + endDay;
                if (_endMonthDate.compareTo(currentDay) >= 0) {
                    queryParam.put("endMonth", _endMonthDate);
                } else {
                    queryParam.put("endMonth", DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM") + endDay);
                }
                CommonResponse listCommonResponse = this.materialInstoreApi.instoreNumCount(queryParam);
                if (!listCommonResponse.isSuccess()) {
                    this.logger.error(listCommonResponse.getMsg());
                    return CommonResponse.error((String)listCommonResponse.getMsg());
                }
                instoreMaterialVOS = (List)listCommonResponse.getData();
            } else {
                instoreMaterialVOS = cal.getInstoreMaterialVOS();
            }
            if (CollectionUtils.isEmpty((Collection)instoreMaterialVOS)) {
                this.budgetInfoService.saveOrUpdateBatch(budgetInfoEntities);
                return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u7269\u8d44\u5165\u5e93\u6570\u91cf\u4fe1\u606f!");
            }
            Map<Long, BigDecimal> level4InstoreMap = instoreMaterialVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getInstoreNumber()));
            HashMap instoreBudgetMap = new HashMap();
            level4BudgetNumMap.forEach((k, v) -> instoreBudgetMap.put(k, level4InstoreMap.get(k) != null && ComputeUtil.isGreaterOrEqual((BigDecimal)((BigDecimal)level4InstoreMap.get(k)), (BigDecimal)v) ? BigDecimal.ONE : ComputeUtil.safeDiv((BigDecimal)((BigDecimal)level4InstoreMap.get(k)), (BigDecimal)v)));
            Map<Long, List<BudgetDetailEntity>> level3ChildMap = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getParentId));
            List useApplyFinishVOS = cal.getUseApplyFinishVOS();
            Map<Long, Integer> materialFinishMap = null;
            if (CollectionUtils.isNotEmpty((Collection)useApplyFinishVOS)) {
                materialFinishMap = useApplyFinishVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getIsFinish()));
            }
            for (BudgetInfoEntity t : budgetInfoEntities) {
                Long detailId = t.getDetailId();
                List<BudgetDetailEntity> budgetDetailEntities = level3ChildMap.get(detailId);
                if (!CollectionUtils.isNotEmpty(budgetDetailEntities)) continue;
                BigDecimal _subFinishRatio = BigDecimal.ZERO;
                for (BudgetDetailEntity k2 : budgetDetailEntities) {
                    Long materialId = k2.getMaterialId();
                    Integer finishCount = MapUtils.isNotEmpty(materialFinishMap) ? materialFinishMap.get(materialId) : Integer.valueOf(0);
                    BigDecimal useScale = finishCount != null && finishCount > 0 ? NumberConsts.ONE_BAI : k2.getMaterialUsedScale();
                    BigDecimal instoreNumBudgetNum = (BigDecimal)instoreBudgetMap.get(materialId);
                    if (null != finishCount && finishCount == 1) {
                        instoreNumBudgetNum = BigDecimal.ONE;
                    }
                    BigDecimal b1 = ComputeUtil.safeMultiply((BigDecimal)instoreNumBudgetNum, (BigDecimal[])new BigDecimal[]{useScale, k2.getMaterialWeightScale()});
                    _subFinishRatio = ComputeUtil.safeAdd((BigDecimal)_subFinishRatio, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)b1, (BigDecimal)NumberConsts.ONE_WAN));
                }
                t.setFinishRatio(ComputeUtil.safeMultiply((BigDecimal)_subFinishRatio, (BigDecimal)NumberConsts.ONE_BAI));
                t.setFinishNum(ComputeUtil.safeMultiply((BigDecimal)_subFinishRatio, (BigDecimal)level3Map.get(detailId)));
            }
            this.budgetInfoService.saveOrUpdateBatch(budgetInfoEntities);
            return CommonResponse.success();
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<RecalculateVO> recalculate(RecalculateVO cal, int updateFlag) {
        CommonResponse<RecalculateVO> recalculateVOCommonResponse = this.beforeRecalculate(cal, updateFlag);
        this.logger.info("\u5f00\u59cb\u6267\u884c\u53cd\u63a8info\u8868");
        CommonResponse<RecalculateVO> setInfoCommonResponse = this.setBudgetInfo(cal, updateFlag);
        this.logger.info("\u6267\u884c\u53cd\u63a8info\u8868\u5b8c\u6210");
        if (!setInfoCommonResponse.isSuccess()) {
            return setInfoCommonResponse;
        }
        return recalculateVOCommonResponse;
    }

    public CommonResponse<RecalculateVO> beforeRecalculate(RecalculateVO cal, int updateFlag) {
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = (BudgetEntity)((Object)this.budgetService.selectById(cal.getBudgetId()));
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = (BudgetEntity)((Object)budgetByProjectId.getData());
        }
        if (budgetEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97!");
        }
        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u7684\u660e\u7ec6!");
        }
        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));
        if (level4Map == null || level4Map.isEmpty()) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u6750\u6599\u660e\u7ec6(\u56db\u7ea7)!");
        }
        BudgetPlanEntity budgetPlanEntity = this.getBudgetPlan(cal);
        if (budgetPlanEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212!");
        }
        if (updateFlag == 1) {
            ArrayList<Long> level3Ids = new ArrayList<Long>(level3Map.keySet());
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter("eq", (Object)budgetPlanEntity.getId()));
            param.getParams().put("detail_id", new Parameter("in", level3Ids));
            String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
            List planItemEntities = this.budgetPlanItemService.queryList(param);
            param.getParams().put("yyear_month", new Parameter("eq", (Object)curMonth));
            List nowPlanItemEntities = this.budgetPlanItemService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)nowPlanItemEntities)) {
                nowPlanItemEntities.forEach(t -> {
                    BigDecimal budgetNum = (BigDecimal)level3Map.get(t.getDetailId());
                    BigDecimal ratio = BigDecimal.ZERO;
                    if (null != t.getPlanRatio()) {
                        ratio = t.getPlanRatio();
                        t.setPlanNum(budgetNum.multiply(ratio).divide(ComputeUtil.toBigDecimal((Integer)100)));
                    }
                });
                this.budgetPlanItemService.saveOrUpdateBatch(nowPlanItemEntities);
            }
            if (CollectionUtils.isNotEmpty((Collection)planItemEntities)) {
                planItemEntities.forEach(t -> {
                    BigDecimal budgetNum = (BigDecimal)level3Map.get(t.getDetailId());
                    BigDecimal ratio = BigDecimal.ZERO;
                    if (null != t.getPlanRatio()) {
                        ratio = t.getPlanRatio();
                        t.setPlanNum(budgetNum.multiply(ratio).divide(ComputeUtil.toBigDecimal((Integer)100)));
                    }
                    if (null != t.getFinishNum()) {
                        t.setFinishRatio(ComputeUtil.bigDecimalPercent((BigDecimal)t.getFinishNum(), (BigDecimal)((BigDecimal)level3Map.get(t.getDetailId())), (int)8));
                    }
                });
                this.budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
            }
            if (CollectionUtils.isNotEmpty(level3Ids)) {
                QueryWrapper delQueryWrapper = new QueryWrapper();
                delQueryWrapper.eq((Object)"plan_id", (Object)budgetPlanEntity.getId());
                delQueryWrapper.notIn((Object)"detail_id", level3Ids);
                this.budgetPlanItemService.remove((Wrapper)delQueryWrapper);
            }
        }
        if (updateFlag >= 2) {
            String endMonth;
            HashMap<Long, BigDecimal> level4BudgetNumMap = new HashMap<Long, BigDecimal>();
            level4Map.forEach((k, v) -> level4BudgetNumMap.put((Long)k, v.stream().filter(s -> s.getMaterialPlanNum() != null).map(BudgetDetailEntity::getMaterialPlanNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            List instoreMaterialVOS = null;
            if (updateFlag == 3) {
                HashMap<String, Object> queryParam = new HashMap<String, Object>();
                queryParam.put("projectId", cal.getProjectId());
                queryParam.put("materialIds", new ArrayList<Long>(level4Map.keySet()));
                String currentDay = DateUtil.getCurrentDay(null);
                String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
                String endDay = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
                String _endMonthDate = curMonth + "-" + endDay;
                if (_endMonthDate.compareTo(currentDay) >= 0) {
                    queryParam.put("endMonth", _endMonthDate);
                } else {
                    queryParam.put("endMonth", DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM") + endDay);
                }
                CommonResponse listCommonResponse = this.materialInstoreApi.instoreNumCount(queryParam);
                if (!listCommonResponse.isSuccess()) {
                    this.logger.error(listCommonResponse.getMsg());
                    return CommonResponse.error((String)listCommonResponse.getMsg());
                }
                instoreMaterialVOS = (List)listCommonResponse.getData();
            } else {
                instoreMaterialVOS = cal.getInstoreMaterialVOS();
            }
            if (CollectionUtils.isEmpty((Collection)instoreMaterialVOS)) {
                return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u7269\u8d44\u5165\u5e93\u6570\u91cf\u4fe1\u606f!");
            }
            Map<Long, BigDecimal> level4InstoreMap = instoreMaterialVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getInstoreNumber()));
            HashMap instoreBudgetMap = new HashMap();
            level4BudgetNumMap.forEach((k, v) -> instoreBudgetMap.put(k, level4InstoreMap.get(k) != null && ComputeUtil.isGreaterOrEqual((BigDecimal)((BigDecimal)level4InstoreMap.get(k)), (BigDecimal)v) ? BigDecimal.ONE : ComputeUtil.safeDiv((BigDecimal)((BigDecimal)level4InstoreMap.get(k)), (BigDecimal)v)));
            Map<Long, List<BudgetDetailEntity>> level3ChildMap = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getParentId));
            QueryParam p = new QueryParam();
            p.getParams().put("plan_id", new Parameter("eq", (Object)budgetPlanEntity.getId()));
            String currentDay1 = DateUtil.getCurrentDay(null);
            String curMonth1 = DateUtil.getCurrentDay((String)"yyyy-MM");
            String endDay1 = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
            String _endMonthDate1 = curMonth1 + "-" + endDay1;
            QueryWrapper pw = BudgetPlanServiceImpl.changeToQueryWrapper((QueryParam)p);
            if (_endMonthDate1.compareTo(currentDay1) >= 0) {
                String start = DateUtil.format((Date)DateUtil.minusMonths((long)1L), (String)"yyyy-MM") + "-" + endDay1;
                pw.apply("(yyear_month >= '" + start + "' and yyear_month < '" + _endMonthDate1 + "')", new Object[0]);
            } else {
                String end = DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM") + "-" + endDay1;
                pw.apply("(yyear_month >= '" + _endMonthDate1 + "' and yyear_month < '" + end + "')", new Object[0]);
            }
            List planItemEntities = this.budgetPlanItemService.list((Wrapper)pw);
            if (planItemEntities.size() == 0 && curMonth1.compareTo(endMonth = budgetPlanEntity.getEndMonth()) > 0) {
                QueryWrapper objectQueryWrapper = BudgetPlanServiceImpl.changeToQueryWrapper((QueryParam)p);
                objectQueryWrapper.apply("(yyear_month = '" + endMonth + "')", new Object[0]);
                planItemEntities = this.budgetPlanItemService.list((Wrapper)objectQueryWrapper);
                this.logger.info("====================");
                this.logger.info(String.valueOf(planItemEntities.size()));
            }
            List useApplyFinishVOS = cal.getUseApplyFinishVOS();
            Map<Long, Integer> materialFinishMap = null;
            if (CollectionUtils.isNotEmpty((Collection)useApplyFinishVOS)) {
                materialFinishMap = useApplyFinishVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getIsFinish()));
            }
            for (BudgetPlanItemEntity t2 : planItemEntities) {
                Long detailId = t2.getDetailId();
                List<BudgetDetailEntity> budgetDetailEntities = level3ChildMap.get(detailId);
                if (!CollectionUtils.isNotEmpty(budgetDetailEntities)) continue;
                BigDecimal _subFinishRatio = BigDecimal.ZERO;
                for (BudgetDetailEntity k2 : budgetDetailEntities) {
                    Long materialId = k2.getMaterialId();
                    Integer finishCount = MapUtils.isNotEmpty(materialFinishMap) ? materialFinishMap.get(materialId) : Integer.valueOf(0);
                    BigDecimal useScale = finishCount != null && finishCount > 0 ? NumberConsts.ONE_BAI : k2.getMaterialUsedScale();
                    BigDecimal instoreNumBudgetNum = (BigDecimal)instoreBudgetMap.get(materialId);
                    if (null != finishCount && finishCount == 1) {
                        instoreNumBudgetNum = BigDecimal.ONE;
                    }
                    BigDecimal b1 = ComputeUtil.safeMultiply((BigDecimal)instoreNumBudgetNum, (BigDecimal[])new BigDecimal[]{useScale, k2.getMaterialWeightScale()});
                    _subFinishRatio = ComputeUtil.safeAdd((BigDecimal)_subFinishRatio, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)b1, (BigDecimal)NumberConsts.ONE_WAN));
                }
                t2.setFinishRatio(ComputeUtil.safeMultiply((BigDecimal)_subFinishRatio, (BigDecimal)NumberConsts.ONE_BAI));
                t2.setFinishNum(ComputeUtil.safeMultiply((BigDecimal)_subFinishRatio, (BigDecimal)level3Map.get(detailId)));
            }
            if (planItemEntities.size() == 0) {
                this.logger.info("\u672a\u67e5\u8be2\u5230BudgetPlanItemEntity\u6570\u636e\uff0cplan_id\uff1a" + budgetPlanEntity.getId());
            } else {
                this.budgetPlanItemService.saveOrUpdateBatch(planItemEntities);
            }
        }
        return CommonResponse.success((String)"\u91cd\u65b0\u8ba1\u7b97\u9879\u76ee\u65bd\u5de5\u8ba1\u5212\u4fe1\u606f\u6210\u529f!");
    }

    @Override
    public void createNewPlanItem(Long budgetId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"budget_id", (Object)budgetId);
        List list1 = this.list((Wrapper)queryWrapper);
        if (list1.size() == 0) {
            return;
        }
        BudgetPlanEntity budgetPlanEntity = (BudgetPlanEntity)((Object)list1.get(0));
        QueryWrapper itemWrapper = new QueryWrapper();
        itemWrapper.eq((Object)"plan_id", (Object)budgetPlanEntity.getId());
        itemWrapper.eq((Object)"leaf_level", (Object)3);
        List budgetPlanItemEntities = this.budgetPlanItemService.list((Wrapper)itemWrapper);
        HashSet dateSet = new HashSet();
        HashMap map = new HashMap();
        budgetPlanItemEntities.forEach(item -> {
            dateSet.add(item.getYyearMonth());
            map.put(item.getDetailId(), item);
        });
        QueryWrapper detailWrapper = new QueryWrapper();
        detailWrapper.eq((Object)"budget_id", (Object)budgetPlanEntity.getBudgetId());
        detailWrapper.eq((Object)"level_no", (Object)3);
        List list = this.budgetDetailService.list((Wrapper)detailWrapper);
        ArrayList entityList = new ArrayList();
        list.forEach(item -> {
            if (map.get(item.getId()) == null) {
                dateSet.forEach(info -> {
                    BudgetPlanItemEntity entity = new BudgetPlanItemEntity();
                    entity.setPlanId(budgetPlanEntity.getId());
                    entity.setDetailId(item.getId());
                    entity.setLeafLevel(3);
                    entity.setLeafFlag(1);
                    entity.setYyearMonth((String)info);
                    String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
                    int curMonthNum = Integer.parseInt(curMonth.substring(0, 4) + curMonth.substring(5));
                    int infoNum = Integer.parseInt(info.substring(0, 4) + info.substring(5));
                    if (infoNum >= curMonthNum) {
                        entity.setPlanNum(item.getCostNum());
                        entity.setPlanRatio(BigDecimal.valueOf(100L));
                    }
                    entityList.add(entity);
                });
            }
        });
        if (entityList.size() > 0) {
            this.budgetPlanItemService.saveOrUpdateBatch(entityList);
        }
    }

    private BudgetPlanEntity getBudgetPlan(RecalculateVO cal) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        if (cal.getBudgetId() != null) {
            queryWrapper.eq((Object)"budget_id", (Object)cal.getBudgetId());
        } else {
            queryWrapper.eq((Object)"project_id", (Object)cal.getProjectId());
        }
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (BudgetPlanEntity)((Object)list.get(0));
    }

    @Override
    public CommonResponse<RecalculateVO> getInfo(RecalculateVO cal) {
        BudgetPlanEntity budgetPlanEntity = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        if (cal.getBudgetId() != null) {
            queryWrapper.eq((Object)"budget_id", (Object)cal.getBudgetId());
        } else {
            queryWrapper.eq((Object)"project_id", (Object)cal.getProjectId());
        }
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212!");
        }
        budgetPlanEntity = (BudgetPlanEntity)((Object)list.get(0));
        if (budgetPlanEntity.getBudgetId() == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5230\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212,\u8ba1\u5212\u4e2d\u7684\u9884\u7b97id\u4e3a\u7a7a!");
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)this.budgetService.selectById(budgetPlanEntity.getBudgetId()));
        if (budgetEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7684\u9884\u7b97!");
        }
        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u7684\u660e\u7ec6!");
        }
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("projectId", cal.getProjectId());
        queryParam.put("materialIds", new ArrayList<Long>(level4Map.keySet()));
        String currentDay = DateUtil.getCurrentDay(null);
        String curMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
        String endDay = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
        String _endMonthDate = curMonth + "-" + endDay;
        if (_endMonthDate.compareTo(currentDay) >= 0) {
            queryParam.put("endMonth", _endMonthDate);
        } else {
            queryParam.put("endMonth", DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM") + endDay);
        }
        cal.setQueryParam(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u548c\u65bd\u5de5\u8ba1\u5212\u6210\u529f!", (Object)cal);
    }

    @Override
    public CommonResponse<RecalculateVO> getPlanNum(RecalculateVO cal) {
        BudgetEntity budgetEntity = null;
        if (cal.getBudgetId() != null) {
            budgetEntity = (BudgetEntity)((Object)this.budgetService.selectById(cal.getBudgetId()));
        } else {
            CommonResponse<BudgetEntity> budgetByProjectId = this.getBudgetByProjectId(cal.getProjectId());
            budgetEntity = (BudgetEntity)((Object)budgetByProjectId.getData());
        }
        if (budgetEntity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97!");
        }
        List<BudgetDetailEntity> detailList = budgetEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u7684\u660e\u7ec6!");
        }
        Map<Long, BigDecimal> level3Map = detailList.stream().filter(s -> s.getLevelNo() == 3).collect(Collectors.toMap(k -> k.getId(), k -> k.getCostNum()));
        Map<Long, List<BudgetDetailEntity>> level4Map = detailList.stream().filter(s -> s.getLevelNo() == 4).collect(Collectors.groupingBy(BudgetDetailEntity::getMaterialId));
        if (level4Map == null || level4Map.isEmpty()) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u9884\u7b97\u4e0b\u6750\u6599\u660e\u7ec6(\u56db\u7ea7)!");
        }
        HashMap<Long, BigDecimal> level3PlanNum = new HashMap<Long, BigDecimal>();
        BudgetPlanEntity budgetPlanEntity = this.getBudgetPlan(cal);
        if (budgetPlanEntity == null) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212!");
        } else if (budgetPlanEntity.getBillState() != 1 && budgetPlanEntity.getBillState() != 3) {
            this.logger.info("\u9879\u76ee\u7684\u65bd\u5de5\u8ba1\u5212\u672a\u751f\u6548!");
        } else {
            QueryParam p = new QueryParam();
            p.getParams().put("plan_id", new Parameter("eq", (Object)budgetPlanEntity.getId()));
            String currentDay1 = cal.getMonthEndDate();
            String curMonth1 = DateUtil.getCurrentDay((String)"yyyy-MM");
            String endDay1 = budgetPlanEntity.getMonthEndDate() != null ? budgetPlanEntity.getMonthEndDate() : "31";
            String _endMonthDate1 = curMonth1 + "-" + endDay1;
            if (_endMonthDate1.compareTo(currentDay1) >= 0) {
                String start = DateUtil.format((Date)DateUtil.minusMonths((long)1L), (String)"yyyy-MM") + "-" + endDay1;
                cal.setStartMonth(start);
                cal.setEndMonth(_endMonthDate1);
                p.getParams().put("yyear_month", new Parameter("eq", (Object)curMonth1));
            } else {
                String nextMonth = DateUtil.format((Date)DateUtil.minusMonths((long)-1L), (String)"yyyy-MM");
                String end = nextMonth + "-" + endDay1;
                p.getParams().put("yyear_month", new Parameter("eq", (Object)nextMonth));
                cal.setStartMonth(_endMonthDate1);
                cal.setEndMonth(end);
            }
            QueryWrapper pw = BudgetPlanServiceImpl.changeToQueryWrapper((QueryParam)p);
            List planItemEntities = this.budgetPlanItemService.list((Wrapper)pw);
            for (BudgetPlanItemEntity budgetPlanItemEntity : planItemEntities) {
                level3PlanNum.put(budgetPlanItemEntity.getDetailId(), ComputeUtil.nullToZero((BigDecimal)budgetPlanItemEntity.getPlanNum()));
            }
        }
        HashMap level4NumMap = new HashMap();
        HashMap level4BudgetNumMap = new HashMap();
        level4Map.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty((Collection)v)) {
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal budgetNum = BigDecimal.ZERO;
                for (BudgetDetailEntity b : v) {
                    Long level3id = b.getParentId();
                    BigDecimal planNum = (BigDecimal)level3PlanNum.get(level3id);
                    BigDecimal materialUsedNum = b.getMaterialUsedNum();
                    num = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planNum, (BigDecimal)materialUsedNum));
                    budgetNum = ComputeUtil.safeAdd((BigDecimal)budgetNum, (BigDecimal)b.getMaterialPlanNum());
                }
                level4NumMap.put(k, num);
                level4BudgetNumMap.put(k, budgetNum);
            }
            cal.setPlanNumMap(level4NumMap);
            cal.setBudgetNumMap(level4BudgetNumMap);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u548c\u65bd\u5de5\u8ba1\u5212\u6210\u529f!", (Object)cal);
    }

    public CommonResponse<String> updateDataByDay() {
        QueryWrapper wrapper = new QueryWrapper();
        List list = this.budgetService.list((Wrapper)wrapper);
        for (BudgetEntity item : list) {
            RecalculateVO vo = new RecalculateVO(item.getProjectId(), null);
            CommonResponse<RecalculateVO> recalculate = this.recalculate(vo, 3);
            if (recalculate.isSuccess()) continue;
            this.logger.info("\u6570\u636e\u4e0d\u9700\u8981\u66f4\u65b0\uff0cProjectId:" + item.getProjectId());
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }
}

