/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetChangeDetailEntity;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.mapper.BudgetChangeMapper;
import com.ejianc.business.budget.service.IBudgetChangeDetailService;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.utils.ExcelReader;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetChangeDetailVO;
import com.ejianc.business.budget.vo.BudgetChangeRecordVO;
import com.ejianc.business.budget.vo.BudgetChangeVO;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.business.plan.vo.BudgetCheckVO;
import com.ejianc.business.utils.BudgetCheckUtil;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetChangeService")
public class BudgetChangeServiceImpl
extends BaseServiceImpl<BudgetChangeMapper, BudgetChangeEntity>
implements IBudgetChangeService {
    private static final String BILL_CODE = "PROBUDGET_CHANGE";
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IBudgetChangeDetailService budgetChangeDetailService;
    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Override
    public BudgetChangeVO insertOrUpdate(BudgetChangeVO changeVO) {
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        Object entity = null;
        List entitiesc = null;
        List entities = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(BudgetChangeEntity::getBudgetId, (Object)changeVO.getBudgetId());
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.ne(BudgetChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(BudgetChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u9884\u7b97\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)changeVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                changeVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BudgetChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BudgetChangeEntity::getBudgetId, (Object)changeVO.getBudgetId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)changeVO.getBudgetId()));
            entitiesc = this.budgetService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BudgetChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.ne(BudgetChangeEntity::getBudgetId, (Object)changeVO.getBudgetId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)changeVO.getBudgetId()));
            entitiesc = this.budgetService.queryList(queryParam, false);
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        BudgetChangeEntity BudgetChangeEntity2 = (BudgetChangeEntity)((Object)BeanMapper.map((Object)changeVO, BudgetChangeEntity.class));
        List<BudgetChangeDetailEntity> beforeDetails = BudgetChangeEntity2.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == BudgetChangeEntity2.getId()) {
            for (BudgetChangeDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate((Object)BudgetChangeEntity2, false);
        List<BudgetChangeDetailEntity> changeDetailEntities = BudgetChangeEntity2.getDetailList();
        List budgetDetailVOS = this.budgetService.queryDetail(changeVO.getBudgetId(), false).getDetailList();
        Map budgetDetailVOMap = budgetDetailVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key2));
        if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetChangeDetailEntity cdEntity : changeDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                BudgetDetailVO budgetDetailVO = (BudgetDetailVO)budgetDetailVOMap.get(cdEntity.getSrcBid());
                if (budgetDetailVO == null) continue;
                cdEntity.setBeforeBudgetMoney(budgetDetailVO.getBudgetMoney());
                cdEntity.setBeforeBudgetNum(budgetDetailVO.getBudgetNum());
                cdEntity.setBeforeBudgetPrice(budgetDetailVO.getBudgetPrice());
                cdEntity.setBeforeBudgetUnit(budgetDetailVO.getBudgetUnit());
                cdEntity.setBeforeCostMoney(budgetDetailVO.getCostMoney());
                cdEntity.setBeforeCostNum(budgetDetailVO.getCostNum());
                cdEntity.setBeforeCostPrice(budgetDetailVO.getCostPrice());
                cdEntity.setBeforeMaterialMoney(budgetDetailVO.getMaterialMoney());
                cdEntity.setBeforeMaterialPlanNum(budgetDetailVO.getMaterialPlanNum());
                cdEntity.setBeforeMaterialPrice(budgetDetailVO.getMaterialPrice());
                cdEntity.setBeforeMaterialUnit(budgetDetailVO.getMaterialUnit());
                cdEntity.setBeforeMaterialUsedNum(budgetDetailVO.getMaterialUsedNum());
                cdEntity.setBeforeMaterialUsedScale(budgetDetailVO.getMaterialUsedScale());
                cdEntity.setBeforeMaterialWeightScale(budgetDetailVO.getMaterialWeightScale());
            }
            for (BudgetChangeDetailEntity cdEntity : changeDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            List resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            BudgetCheckUtil.checkWeightScale(treeData);
            List<Map<String, Object>> ListCodeDate = this.creatInnerCode(treeData, null);
            ArrayList<BudgetChangeDetailEntity> saveEntities = new ArrayList<BudgetChangeDetailEntity>();
            this.treeToList(ListCodeDate, saveEntities);
            this.budgetChangeDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
        }
        this.saveWriteContract(BudgetChangeEntity2);
        return this.queryDetail(BudgetChangeEntity2.getId());
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetChangeDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((BudgetChangeDetailEntity)((Object)BeanMapper.map(ypd, BudgetChangeDetailEntity.class)));
        }
    }

    private void saveWriteContract(BudgetChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BudgetEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(BudgetEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(BudgetEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(BudgetEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(BudgetEntity::getChangingCostbudgetMny, (Object)changeEntity.getCostbudgetMny());
        updateWrapper.set(BudgetEntity::getChangingIncomebudgetAdjustMny, (Object)changeEntity.getIncomebudgetAdjustMny());
        updateWrapper.set(BudgetEntity::getChangingIncomebudgetMny, (Object)changeEntity.getIncomebudgetMny());
        updateWrapper.set(BudgetEntity::getChangingLaborMny, (Object)changeEntity.getLaborMny());
        updateWrapper.set(BudgetEntity::getChangingManageMny, (Object)changeEntity.getManageMny());
        updateWrapper.set(BudgetEntity::getChangingManageRate, (Object)changeEntity.getManageMny());
        updateWrapper.set(BudgetEntity::getChangingMaterialMny, (Object)changeEntity.getMaterialMny());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getBudgetId());
        this.budgetService.update(this.budgetService.selectById(changeEntity.getBudgetId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public BudgetChangeVO addConvertByConId(Long budgetId) {
        BudgetVO budgetVO = this.budgetService.queryDetail(budgetId, false);
        BudgetChangeVO changeVO = (BudgetChangeVO)BeanMapper.map((Object)budgetVO, BudgetChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBillCode(null);
        changeVO.setBeforeCostbudgetMny(budgetVO.getCostbudgetMny());
        changeVO.setBeforeIncomebudgetAdjustMny(budgetVO.getIncomebudgetAdjustMny());
        changeVO.setBeforeIncomebudgetMny(budgetVO.getIncomebudgetMny());
        changeVO.setBeforeLaborMny(budgetVO.getLaborMny());
        changeVO.setBeforeManageMny(budgetVO.getManageMny());
        changeVO.setBeforeManageRate(budgetVO.getManageRate());
        changeVO.setBeforeMaterialMny(budgetVO.getMaterialMny());
        changeVO.setBudgetId(changeVO.getId());
        changeVO.setChangeVersion(Integer.valueOf(budgetVO.getChangeVersion() == null ? 1 : budgetVO.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setTaxRatio(budgetVO.getTaxRatio());
        changeVO.setTaxFee(budgetVO.getTaxFee());
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setBudgetId(changeDetailVO.getBudgetId());
                changeDetailVO.setSrcBid(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
        return changeVO;
    }

    @Override
    public BudgetChangeVO queryDetail(Long id) {
        BudgetChangeEntity changeEntity = (BudgetChangeEntity)((Object)super.selectById((Serializable)id));
        BudgetChangeVO changeVO = (BudgetChangeVO)BeanMapper.map((Object)((Object)changeEntity), BudgetChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("changeId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.budgetChangeDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (BudgetChangeDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, BudgetChangeDetailVO.class);
            changeVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<BudgetChangeVO> vos) {
        BudgetChangeVO changeVo = vos.get(0);
        BudgetChangeEntity entity = (BudgetChangeEntity)((Object)super.selectById((Serializable)changeVo.getId()));
        BudgetEntity pcentity = (BudgetEntity)((Object)this.budgetService.selectById(entity.getBudgetId()));
        pcentity.setId(entity.getBudgetId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        pcentity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        pcentity.setChangingCostbudgetMny(BigDecimal.ZERO);
        pcentity.setChangingIncomebudgetAdjustMny(BigDecimal.ZERO);
        pcentity.setChangingIncomebudgetMny(BigDecimal.ZERO);
        pcentity.setChangingLaborMny(BigDecimal.ZERO);
        pcentity.setChangingManageMny(BigDecimal.ZERO);
        pcentity.setChangingManageRate(BigDecimal.ZERO);
        pcentity.setChangingMaterialMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        this.budgetService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<IPage<BudgetChangeVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        IPage page = this.queryPage(param, false);
        List changeVOList = BeanMapper.mapList((Iterable)page.getRecords(), BudgetChangeVO.class);
        Page changeVOIPage = new Page();
        changeVOIPage.setCurrent(page.getCurrent());
        changeVOIPage.setRecords(changeVOList);
        changeVOIPage.setSize(page.getSize());
        changeVOIPage.setTotal(page.getTotal());
        changeVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)changeVOIPage);
    }

    @Override
    public List<BudgetChangeRecordVO> queryDetailRecord(Long budgetId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BudgetChangeEntity::getBudgetId, (Object)budgetId);
        lambda.in(BudgetChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List recordVOList = BeanMapper.mapList((Iterable)entities, BudgetChangeRecordVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getBillCode() + "-0" + recordVO.getChangeVersion());
            } else {
                recordVO.setHistoryCode(recordVO.getBillCode() + "-" + recordVO.getChangeVersion());
            }
        });
        return recordVOList;
    }

    private BudgetCheckVO getCheckVO(List<BudgetChangeDetailVO> list, String level4) {
        BudgetCheckVO budgetCheckVO = new BudgetCheckVO();
        budgetCheckVO.setLevel4(level4);
        list.forEach(item -> {
            if (item.getLevelNo() == 1) {
                budgetCheckVO.setLevel1(item.getBuildingNo());
            } else if (item.getLevelNo() == 2) {
                budgetCheckVO.setLevel2(item.getBuildContent());
            } else if (item.getLevelNo() == 3) {
                budgetCheckVO.setLevel3(item.getCraft());
            }
        });
        return budgetCheckVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, String budgetChangeId, String budgetId, List<BudgetChangeDetailEntity> entities) {
        HashSet<String> materialNameSet = new HashSet<String>();
        ArrayList<BudgetCheckVO> checkVOS = new ArrayList<BudgetCheckVO>();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            Object datas;
            long count = entities.stream().filter(item -> item.getInnerCode() == null).count();
            if (count > 0L) {
                return CommonResponse.error((String)"\u8bf7\u5bfc\u5165\u540e\u518d\u624b\u52a8\u65b0\u589e\u6570\u636e\uff0c\u5426\u5219\u4f1a\u4e22\u5931\uff01");
            }
            Map<String, BudgetChangeDetailVO> oldDataMap = this.getOldDataMap(budgetChangeId, budgetId, materialNameSet, entities);
            boolean levelFlag = false;
            boolean levelBlankFlag = false;
            int oneNo = 0;
            int twoNo = 0;
            int threeNo = 0;
            int fourNo = 0;
            Integer lastLevelNo = -1;
            String nextLevel = "1";
            StringBuffer innerCode = new StringBuffer();
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BudgetChangeDetailVO> detailVoList = new ArrayList<BudgetChangeDetailVO>();
            HashMap<String, BudgetChangeDetailVO> tidMap = new HashMap<String, BudgetChangeDetailVO>();
            for (int i = 0; i < result.size(); ++i) {
                String[] split;
                datas = (List)result.get(i);
                BudgetChangeDetailVO vo = new BudgetChangeDetailVO();
                boolean flag = false;
                String warnType = "";
                StringBuffer detailIndex = new StringBuffer();
                String buildingNo = (String)datas.get(0);
                String buildContent = (String)datas.get(1);
                String craft = (String)datas.get(2);
                String materialName = (String)datas.get(9);
                Integer levelNo = -1;
                if (StringUtils.isNotBlank((CharSequence)buildingNo)) {
                    ++oneNo;
                    levelNo = 1;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    if (lastLevelNo == 4) {
                        twoNo = 0;
                        threeNo = 0;
                        fourNo = 0;
                    }
                    nextLevel = "2";
                    detailIndex.append(oneNo);
                    levelBlankFlag = true;
                    innerCode = new StringBuffer();
                    innerCode.append(buildingNo).append("&&");
                    vo.setInnerCode(innerCode.toString());
                    vo.setBuildingNo(buildingNo);
                } else if (StringUtils.isNotBlank((CharSequence)buildContent)) {
                    ++twoNo;
                    levelNo = 2;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    if (lastLevelNo == 4) {
                        threeNo = 0;
                        fourNo = 0;
                        split = innerCode.toString().split("&&");
                        innerCode = new StringBuffer();
                        innerCode.append(split[0]).append("&&");
                    }
                    nextLevel = "3";
                    detailIndex.append(oneNo).append(".").append(twoNo);
                    levelBlankFlag = true;
                    innerCode.append(buildContent).append("&&");
                    vo.setInnerCode(innerCode.toString());
                    vo.setBuildContent(buildContent);
                } else if (StringUtils.isNotBlank((CharSequence)craft)) {
                    ++threeNo;
                    levelNo = 3;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    if (lastLevelNo == 4) {
                        fourNo = 0;
                        split = innerCode.toString().split("&&");
                        innerCode = new StringBuffer();
                        innerCode.append(split[0]).append("&&").append(split[1]).append("&&");
                    }
                    nextLevel = "4";
                    detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo);
                    levelBlankFlag = true;
                    innerCode.append(craft).append("&&");
                    vo.setInnerCode(innerCode.toString());
                    vo.setCraft(craft);
                } else if (StringUtils.isNotBlank((CharSequence)materialName)) {
                    ++fourNo;
                    levelNo = 4;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    nextLevel = "1,2,3,4";
                    detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo).append(".").append(fourNo);
                    levelBlankFlag = true;
                    materialNameSet.add(materialName.trim());
                    vo.setInnerCode(innerCode.toString() + materialName);
                    vo.setMaterialName(materialName);
                }
                lastLevelNo = levelNo;
                vo.setTreeIndex(detailIndex.toString());
                String id = oldDataMap.containsKey(vo.getInnerCode()) ? oldDataMap.get(vo.getInnerCode()).getTid() : UUID.randomUUID().toString().replaceAll("-", "");
                String[] split2 = detailIndex.toString().split("[-/.]");
                vo.setTid(id);
                tidMap.put(detailIndex.toString(), vo);
                if (split2.length > 1) {
                    vo.setTpid(detailIndex.substring(0, detailIndex.length() - split2[split2.length - 1].length() - 1));
                }
                indexMap.put(detailIndex.toString(), i);
                if (!levelBlankFlag) {
                    warnType = warnType + "\u697c\u53f7\u3001\u65bd\u5de5\u5185\u5bb9\u3001\u5de5\u827a\u3001\u6750\u6599\u540d\u79f0\u4e0d\u80fd\u90fd\u4e3a\u7a7a,";
                    flag = true;
                }
                vo.setLevelNo(levelNo);
                if (levelNo == 3) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                        vo.setBudgetNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setBudgetNum(new BigDecimal((String)datas.get(4)));
                        }
                        catch (Exception e) {
                            vo.setBudgetNum(null);
                            warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    vo.setBudgetUnit((String)datas.get(5));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                        vo.setBudgetPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setBudgetPrice(new BigDecimal((String)datas.get(6)));
                        }
                        catch (Exception e) {
                            vo.setBudgetPrice(null);
                            warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    vo.setBudgetMoney(ComputeUtil.safeMultiply((BigDecimal)vo.getBudgetNum(), (BigDecimal)vo.getBudgetPrice()));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                        vo.setCostNum(null);
                        warnType = warnType + "\u6210\u672c\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setCostNum(new BigDecimal((String)datas.get(7)));
                        }
                        catch (Exception e) {
                            vo.setCostNum(null);
                            warnType = warnType + "\u6210\u672c\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        vo.setCostPrice(null);
                        warnType = warnType + "\u4eba\u5de5\u5355\u4ef7\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setCostPrice(new BigDecimal((String)datas.get(8)));
                        }
                        catch (Exception e) {
                            vo.setCostPrice(null);
                            warnType = warnType + "\u4eba\u5de5\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    vo.setCostMoney(ComputeUtil.safeMultiply((BigDecimal)vo.getCostNum(), (BigDecimal)vo.getCostPrice()));
                }
                if (levelNo == 4) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9)))) {
                        vo.setMaterialName(null);
                        warnType = warnType + "\u6750\u6599\u540d\u79f0/\u4f53\u7cfb\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        vo.setMaterialName((String)datas.get(9));
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10)))) {
                        vo.setMaterialWeightScale(null);
                    } else {
                        try {
                            vo.setMaterialWeightScale(ComputeUtil.safeMultiply((BigDecimal)new BigDecimal(100), (BigDecimal)new BigDecimal((String)datas.get(10))));
                        }
                        catch (Exception e) {
                            vo.setMaterialWeightScale(null);
                            warnType = warnType + "\u4ea7\u503c\u6743\u91cd\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(11)))) {
                        vo.setMaterialUsedScale(null);
                    } else {
                        try {
                            vo.setMaterialUsedScale(ComputeUtil.safeMultiply((BigDecimal)new BigDecimal(100), (BigDecimal)new BigDecimal((String)datas.get(11))));
                        }
                        catch (Exception e) {
                            vo.setMaterialUsedScale(null);
                            warnType = warnType + "\u6750\u6599\u4f7f\u7528\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12)))) {
                        vo.setMaterialPrice(null);
                        warnType = warnType + "\u6750\u6599\u5355\u4ef7\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setMaterialPrice(new BigDecimal((String)datas.get(12)));
                        }
                        catch (Exception e) {
                            vo.setMaterialPrice(null);
                            warnType = warnType + "\u6750\u6599\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13)))) {
                        vo.setMaterialUsedNum(null);
                        warnType = warnType + "\u8017\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setMaterialUsedNum(new BigDecimal((String)datas.get(13)));
                        }
                        catch (Exception e) {
                            vo.setMaterialUsedNum(null);
                            warnType = warnType + "\u8017\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    BigDecimal parCostNum = tidMap.get(vo.getTpid()) != null ? ((BudgetChangeDetailVO)tidMap.get(vo.getTpid())).getCostNum() : null;
                    vo.setMaterialPlanNum(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialUsedNum(), (BigDecimal)parCostNum));
                    vo.setMaterialMoney(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialPlanNum(), (BigDecimal)vo.getMaterialPrice()));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(14)))) {
                        vo.setMaterialUnit(null);
                        warnType = warnType + "\u6750\u6599\u5355\u4f4d\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        vo.setMaterialUnit((String)datas.get(14));
                    }
                    vo.setLeafFlag(Boolean.valueOf(true));
                    BudgetCheckVO checkVO = this.getCheckVO(detailVoList, (String)datas.get(9));
                    Boolean likeFlag = false;
                    for (BudgetCheckVO item2 : checkVOS) {
                        if (!checkVO.getLevel1().equals(item2.getLevel1()) || !checkVO.getLevel2().equals(item2.getLevel2()) || !checkVO.getLevel3().equals(item2.getLevel3()) || !checkVO.getLevel4().equals(item2.getLevel4())) continue;
                        warnType = warnType + "\u6570\u636e\u91cd\u590d,";
                        flag = true;
                        likeFlag = true;
                        break;
                    }
                    if (!likeFlag.booleanValue()) {
                        checkVOS.add(checkVO);
                    }
                } else {
                    vo.setLeafFlag(Boolean.valueOf(false));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                detailVoList.add(vo);
            }
            ArrayList<BudgetChangeDetailVO> newList = new ArrayList<BudgetChangeDetailVO>();
            datas = detailVoList.iterator();
            while (datas.hasNext()) {
                BudgetChangeDetailVO tVo;
                tVo.setTpid(tidMap.get((tVo = (BudgetChangeDetailVO)datas.next()).getTpid()) != null ? ((BudgetChangeDetailVO)tidMap.get(tVo.getTpid())).getTid() : null);
                if (oldDataMap.containsKey(tVo.getInnerCode())) {
                    BudgetChangeDetailVO oldDeailVO = oldDataMap.get(tVo.getInnerCode());
                    tVo.setId(oldDeailVO.getId());
                    tVo.setVersion(oldDeailVO.getVersion());
                    tVo.setBudgetId(oldDeailVO.getBudgetId());
                    tVo.setSrcBid(oldDeailVO.getSrcBid());
                    tVo.setChangeType(oldDeailVO.getChangeType());
                    tVo.setRowState(oldDeailVO.getRowState());
                    if (oldDeailVO.getChangeType() == 5) {
                        tVo.setRowState("edit");
                        tVo.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
                    }
                    oldDataMap.put(tVo.getInnerCode(), tVo);
                    continue;
                }
                tVo.setRowState("add");
                tVo.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
                newList.add(tVo);
            }
            Collection<BudgetChangeDetailVO> changeDetailVOCollection = oldDataMap.values();
            ArrayList<BudgetChangeDetailVO> changeDetailVOS = new ArrayList<BudgetChangeDetailVO>(changeDetailVOCollection);
            changeDetailVOS.addAll(newList);
            CommonResponse materialListresp = this.materialApi.queryMaterialListByNames(new ArrayList<String>(materialNameSet));
            Map<String, MaterialVO> materialMap = null;
            if (materialListresp.isSuccess()) {
                materialMap = ((List)materialListresp.getData()).stream().collect(Collectors.toMap(MaterialVO::getName, Function.identity(), (key1, key2) -> key2));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(changeDetailVOS, Map.class));
            List mapList = ExcelImportUtil.dealWeightScale((List)deailTreeData);
            levelFlag = this.getLevelFlag(mapList, materialMap);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            if (levelFlag) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
            } else {
                resp.put("successList", this.convertJsonToVoList((List)allList.get(0)));
                resp.put("successNum", (Object)(result.size() - errorList.size()));
            }
            if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                errorList.forEach(t -> {
                    Object innerCodeObj = t.get("innerCode");
                    if ((Integer)t.get("levelNo") == 3 && innerCodeObj != null) {
                        String s = innerCodeObj.toString();
                        String[] split = s.split("&&");
                        t.put("buildingNo", split[0]);
                        t.put("buildContent", split[1]);
                    }
                });
            }
            resp.put("errorList", (Object)errorList);
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    private boolean getLevelFlag(List<Map<String, Object>> mapList, Map<String, MaterialVO> materialMap) {
        for (Map<String, Object> map : mapList) {
            List child = (List)map.get("children");
            if (child != null) {
                if (!this.getLevelFlag(child, materialMap)) continue;
                return true;
            }
            if (null != map.get("materialName")) {
                if (materialMap.containsKey(map.get("materialName"))) {
                    MaterialVO materialVO = materialMap.get(map.get("materialName"));
                    map.put("materialId", materialVO.getId());
                } else if (!((Boolean)map.get("importFlag")).booleanValue()) {
                    map.put("warnType", map.get("warnType") + ", \u6839\u636e\u540d\u79f0\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u8d44");
                } else {
                    map.put("importFlag", false);
                    map.put("warnType", "\u6839\u636e\u540d\u79f0\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u8d44");
                }
            }
            if (null == map.get("warnType") || !((String)map.get("warnType")).contains("\u6743\u91cd\u548c\u4e0d\u4e3a1")) continue;
            return true;
        }
        return false;
    }

    private List<BudgetChangeDetailVO> convertJsonToVoList(List<Map<String, Object>> successList) {
        List<Map<String, Object>> success = this.treeToListNoWarn(successList);
        List detailVOList = BeanMapper.mapList(success, BudgetChangeDetailVO.class);
        return BudgetChangeServiceImpl.buildTreeByTid(detailVOList);
    }

    public List<Map<String, Object>> treeToListNoWarn(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> reList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> stringObjectMap : list) {
            List child;
            if (stringObjectMap.containsKey("createUserName")) {
                stringObjectMap.remove("createUserName");
            }
            if (stringObjectMap.containsKey("updateUserName")) {
                stringObjectMap.remove("updateUserName");
            }
            if (stringObjectMap.containsKey("parentID")) {
                stringObjectMap.remove("parentID");
            }
            if (stringObjectMap.containsKey("nodeId")) {
                stringObjectMap.remove("nodeId");
            }
            if (null == stringObjectMap.get("changeType") || !stringObjectMap.get("changeType").toString().equals("5")) {
                stringObjectMap.put("changeType", "0");
            }
            if (null != (child = (List)stringObjectMap.get("children"))) {
                List<Map<String, Object>> childrenList = this.treeToListNoWarn(child);
                stringObjectMap.put("children", null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
                continue;
            }
            reList.add(stringObjectMap);
        }
        return reList;
    }

    private Map<String, BudgetChangeDetailVO> getOldDataMap(String budgetChangeId, String budgetId, Set<String> materialNameSet, List<BudgetChangeDetailEntity> entitys) {
        HashMap<String, BudgetChangeDetailVO> map = new HashMap<String, BudgetChangeDetailVO>();
        if (CollectionUtils.isNotEmpty(entitys)) {
            Map detailEntityMap = entitys.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
            if (CollectionUtils.isNotEmpty(entitys)) {
                for (BudgetChangeDetailEntity detailEntity : entitys) {
                    String[] pkArray = detailEntity.getInnerCode().split("&&");
                    StringBuffer stringKey = new StringBuffer();
                    for (String pk : pkArray) {
                        BudgetChangeDetailEntity detailEntity1 = (BudgetChangeDetailEntity)((Object)detailEntityMap.get(Long.valueOf(pk)));
                        if (1 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildingNo()).append("&&");
                            continue;
                        }
                        if (2 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildContent()).append("&&");
                            continue;
                        }
                        if (3 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getCraft()).append("&&");
                            continue;
                        }
                        if (4 != detailEntity1.getLevelNo()) continue;
                        stringKey.append(detailEntity1.getMaterialName());
                        materialNameSet.add(detailEntity1.getMaterialName().trim());
                    }
                    BudgetChangeDetailVO changeDetailVO = (BudgetChangeDetailVO)BeanMapper.map((Object)((Object)detailEntity), BudgetChangeDetailVO.class);
                    map.put(stringKey.toString(), changeDetailVO);
                }
            }
        }
        return map;
    }

    public static List<BudgetChangeDetailVO> buildTreeByTid(List<BudgetChangeDetailVO> values) {
        BudgetChangeDetailVO parentNode;
        HashMap<String, BudgetChangeDetailVO> nodeMap = new HashMap<String, BudgetChangeDetailVO>();
        ArrayList<BudgetChangeDetailVO> result = new ArrayList<BudgetChangeDetailVO>();
        ArrayList<BudgetChangeDetailVO> emptyValueList = new ArrayList<BudgetChangeDetailVO>();
        for (BudgetChangeDetailVO value : values) {
            if (StringUtils.isBlank((CharSequence)value.getTpid())) {
                result.add(value);
            } else {
                parentNode = (BudgetChangeDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getTid(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (BudgetChangeDetailVO value : emptyValueList) {
                parentNode = (BudgetChangeDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }
}

