/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.vo.PlanCostVO;
import com.ejianc.business.budget.vo.PlanProfitVO;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.history.ProjectProgressVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialInstoreApi;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.mapper.BudgetPlanMapper;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlanReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    BudgetPlanMapper planMapper;
    @Autowired
    IProjectApi projectApi;
    @Autowired
    ISubReportApi subReportApi;
    @Autowired
    IMaterialInstoreApi materialInstoreApi;
    @Autowired
    ISettlementApi equipSettlementApi;
    @Autowired
    IPayContractApi payContractApi;
    @Autowired
    IIncomeContractApi iIncomeContractApi;
    private static BigDecimal YI_BAI = new BigDecimal("100");

    public List<PlanCostVO> loadCostList2ES(HashMap<String, Object> map) {
        String currentMonth = DateUtil.getCurrentDay((String)"yyyy-MM");
        map.put("yyearMonth", currentMonth);
        List<PlanCostVO> planCostVOS = this.planMapper.getCost(map);
        if (CollectionUtils.isNotEmpty(planCostVOS)) {
            List<Long> projectIds = planCostVOS.stream().map(PlanCostVO::getProjectId).collect(Collectors.toList());
            CommonResponse projectRes = this.projectApi.queryProjectByIds(projectIds);
            List<SubProjectSettleNumVO> subSettleNumRes = this.planMapper.getSubSettleNum(projectIds);
            CommonResponse materialRes = this.materialInstoreApi.amountSum(projectIds);
            CommonResponse equipMapRes = this.equipSettlementApi.getSettleMny(projectIds);
            CommonResponse financeRes = this.payContractApi.getProjectReimburse(projectIds);
            Map<Object, Object> materialMap = new HashMap();
            if (materialRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)materialRes.getData()))) {
                materialMap = ((List)materialRes.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            Map<Object, Object> subMap = new HashMap();
            if (CollectionUtils.isNotEmpty(subSettleNumRes)) {
                subMap = subSettleNumRes.stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            Map<Object, Object> equipmentMap = new HashMap();
            if (equipMapRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)equipMapRes.getData()))) {
                equipmentMap = ((List)equipMapRes.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            Map<Object, Object> financeMap = new HashMap();
            if (financeRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)financeRes.getData()))) {
                financeMap = ((List)financeRes.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            this.logger.info(">>>>>loadCostList2ES>>>>projectRes:{}", (Object)JSONObject.toJSONString((Object)projectRes));
            if (projectRes.isSuccess()) {
                List projects = (List)projectRes.getData();
                if (CollectionUtils.isNotEmpty((Collection)projects)) {
                    Map<Long, ProjectRegisterVO> proMaps = projects.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
                    for (PlanCostVO c : planCostVOS) {
                        ProjectReimburseVO projectReimburseVO;
                        SettlementVO equipVO;
                        SubProjectSettleNumVO sub;
                        ProjectRegisterVO project;
                        String endMonth;
                        Long projectId = c.getProjectId();
                        c.setYyearMonth(currentMonth.substring(0, 4) + "\u5e74" + currentMonth.substring(5) + "\u6708");
                        QueryWrapper queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"project_id", (Object)projectId);
                        queryWrapper.eq((Object)"dr", (Object)0);
                        List budgetPlanEntities = this.planMapper.selectList((Wrapper)queryWrapper);
                        if (budgetPlanEntities.size() > 0 && ((BudgetPlanEntity)((Object)budgetPlanEntities.get(0))).getEndMonth().length() == 7 && (endMonth = ((BudgetPlanEntity)((Object)budgetPlanEntities.get(0))).getEndMonth()).compareTo(currentMonth) <= 0) {
                            c.setYyearMonth(endMonth.substring(0, 4) + "\u5e74" + endMonth.substring(5, 7) + "\u6708");
                        }
                        if ((project = proMaps.get(projectId)) != null) {
                            c.setParentOrgId(project.getOrgId());
                            c.setParentOrgName(project.getOrgName());
                        }
                        if ((sub = (SubProjectSettleNumVO)subMap.get(projectId)) != null) {
                            c.setCurNum(sub.getRealNum());
                            c.setSubCost(sub.getRealMny());
                        }
                        c.setRealNum(ComputeUtil.isGreaterThan((BigDecimal)c.getCurNum(), (BigDecimal)c.getComputeNum()) ? c.getCurNum() : c.getComputeNum());
                        InstoreAccountSumVO instoreVO = (InstoreAccountSumVO)materialMap.get(projectId);
                        if (instoreVO != null) {
                            c.setMaterialCost(instoreVO.getTotalAmount());
                        }
                        if (null != (equipVO = (SettlementVO)equipmentMap.get(projectId))) {
                            c.setEquipRentCost(equipVO.getRentSettleMny());
                            c.setEquipPurchaseCost(equipVO.getPurchaseSettleMny());
                        }
                        if (null != (projectReimburseVO = (ProjectReimburseVO)financeMap.get(projectId))) {
                            c.setLoadReimburseCost(projectReimburseVO.getLoadReimburseMny());
                            c.setPayReimburseCost(projectReimburseVO.getPayReimburseMny());
                        }
                        c.setCurCost(ComputeUtil.safeAdd((BigDecimal)c.getSubCost(), (BigDecimal[])new BigDecimal[]{c.getMaterialCost(), c.getEquipPurchaseCost(), c.getEquipRentCost(), c.getLoadReimburseCost(), c.getPayReimburseCost()}));
                        c.setComputeCost(ComputeUtil.safeAdd((BigDecimal)c.getComputeCost(), (BigDecimal[])new BigDecimal[]{c.getMaterialCost(), c.getEquipPurchaseCost(), c.getEquipRentCost(), c.getLoadReimburseCost(), c.getPayReimburseCost()}));
                        c.setRealCost(ComputeUtil.isGreaterThan((BigDecimal)c.getCurCost(), (BigDecimal)c.getComputeCost()) ? c.getCurCost() : c.getComputeCost());
                        c.setBudgetPrice(ComputeUtil.safeDiv((BigDecimal)c.getPlanBudgetCost(), (BigDecimal)c.getBudgetNum()));
                        c.setRealPrice(ComputeUtil.safeDiv((BigDecimal)c.getRealCost(), (BigDecimal)c.getRealNum()));
                        c.setFinishBudget(ComputeUtil.safeMultiply((BigDecimal)c.getBudgetPrice(), (BigDecimal)c.getRealNum()));
                        c.setPlanDiff(ComputeUtil.safeSub((BigDecimal)c.getFinishBudget(), (BigDecimal)c.getPlanBudgetCost()));
                        c.setCostDiff(ComputeUtil.safeSub((BigDecimal)c.getFinishBudget(), (BigDecimal)c.getRealCost()));
                        c.setWorkAchi(ComputeUtil.bigDecimalPercent((BigDecimal)c.getFinishBudget(), (BigDecimal)c.getPlanBudgetCost(), (int)8));
                        c.setCostAchi(ComputeUtil.bigDecimalPercent((BigDecimal)c.getRealCost(), (BigDecimal)c.getFinishBudget(), (int)8));
                        c.setProjectName(proMaps.get(c.getProjectId()).getName());
                    }
                }
            } else {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        return planCostVOS;
    }

    public List<PlanProfitVO> loadProfitList2ES(HashMap<String, Object> map) {
        map.put("yyearMonth", DateUtil.getCurrentDay((String)"yyyy-MM"));
        List<PlanProfitVO> planProfitVOS = this.planMapper.getProfit(map);
        if (CollectionUtils.isNotEmpty(planProfitVOS)) {
            List<Long> projectIds = planProfitVOS.stream().map(PlanProfitVO::getProjectId).collect(Collectors.toList());
            CommonResponse projectRes = this.projectApi.queryProjectByIds(projectIds);
            List<SubProjectSettleNumVO> subSettleNumRes = this.planMapper.getSubSettleNum(projectIds);
            CommonResponse materialRes = this.materialInstoreApi.amountSum(projectIds);
            CommonResponse equipMapRes = this.equipSettlementApi.getSettleMny(projectIds);
            CommonResponse financeRes = this.payContractApi.getProjectReimburse(projectIds);
            CommonResponse listCommonResponse = this.iIncomeContractApi.projectProgressList(projectIds);
            this.logger.info(">>>>>loadProfitList2ES>>>>projectIds:{}\uff0cfinanceRes:{}", (Object)JSONObject.toJSONString(projectIds), (Object)JSONObject.toJSONString((Object)financeRes));
            Map<Object, Object> progressMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                progressMap = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            Map<Object, Object> materialMap = new HashMap();
            if (materialRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)materialRes.getData()))) {
                materialMap = ((List)materialRes.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            Map<Object, Object> subMap = new HashMap();
            if (CollectionUtils.isNotEmpty(subSettleNumRes)) {
                subMap = subSettleNumRes.stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            Map<Object, Object> equipmentMap = new HashMap();
            if (equipMapRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)equipMapRes.getData()))) {
                equipmentMap = ((List)equipMapRes.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            Map<Object, Object> financeMap = new HashMap();
            if (financeRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)financeRes.getData()))) {
                financeMap = ((List)financeRes.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            if (projectRes.isSuccess()) {
                List projects = (List)projectRes.getData();
                if (CollectionUtils.isNotEmpty((Collection)projects)) {
                    Map<Long, ProjectRegisterVO> proMaps = projects.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
                    for (PlanProfitVO c : planProfitVOS) {
                        ProjectReimburseVO projectReimburseVO;
                        SettlementVO equipVO;
                        SubProjectSettleNumVO sub;
                        Long projectId = c.getProjectId();
                        ProjectRegisterVO project = proMaps.get(projectId);
                        if (project != null) {
                            c.setParentOrgId(project.getOrgId());
                            c.setParentOrgName(project.getOrgName());
                        }
                        if ((sub = (SubProjectSettleNumVO)subMap.get(projectId)) != null) {
                            c.setSubCost(sub.getRealMny());
                        }
                        c.setCurCost(c.getSubCost());
                        c.setRealCost(ComputeUtil.isGreaterThan((BigDecimal)c.getCurCost(), (BigDecimal)c.getComputeCost()) ? c.getCurCost() : c.getComputeCost());
                        InstoreAccountSumVO instoreVO = (InstoreAccountSumVO)materialMap.get(projectId);
                        if (instoreVO != null) {
                            c.setMaterialCost(instoreVO.getTotalAmount());
                        }
                        if (null != (equipVO = (SettlementVO)equipmentMap.get(projectId))) {
                            c.setEquipRentCost(equipVO.getRentSettleMny());
                            c.setEquipPurchaseCost(equipVO.getPurchaseSettleMny());
                        }
                        if (null != (projectReimburseVO = (ProjectReimburseVO)financeMap.get(projectId))) {
                            c.setLoadReimburseCost(projectReimburseVO.getLoadReimburseMny());
                            c.setPayReimburseCost(projectReimburseVO.getPayReimburseMny());
                        }
                        c.setRealManageMny(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)c.getEquipPurchaseCost(), (BigDecimal[])new BigDecimal[]{c.getEquipRentCost(), c.getLoadReimburseCost(), c.getPayReimburseCost()})));
                        c.setPlanProfit(ComputeUtil.bigDecimalPercent((BigDecimal)ComputeUtil.safeSub((BigDecimal)c.getIncomebudgetMny(), (BigDecimal[])new BigDecimal[]{c.getCostbudgetMny(), c.getTaxFee()}), (BigDecimal)c.getIncomebudgetMny(), (int)8));
                        if (null != project.getStatus() && "3".equals(project.getStatus())) {
                            ProjectProgressVo projectProgressVo = (ProjectProgressVo)progressMap.get(projectId);
                            c.setProductionMny(projectProgressVo.getOutputMoney());
                        }
                        c.setProjectName(proMaps.get(c.getProjectId()).getName());
                        c.setRealTaxFee(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)c.getProductionMny(), (BigDecimal)c.getTaxRatio()), (BigDecimal)YI_BAI));
                        c.setRealProfit(ComputeUtil.bigDecimalPercent((BigDecimal)ComputeUtil.safeSub((BigDecimal)c.getProductionMny(), (BigDecimal[])new BigDecimal[]{c.getRealCost(), c.getRealManageMny(), c.getMaterialCost(), c.getRealTaxFee()}), (BigDecimal)c.getProductionMny(), (int)8));
                        c.setBasePlanProfit(ComputeUtil.bigDecimalPercent((BigDecimal)ComputeUtil.safeSub((BigDecimal)c.getBaseIncomebudgetMny(), (BigDecimal)c.getBaseCostbudgetMny()), (BigDecimal)c.getBaseIncomebudgetMny(), (int)8));
                        c.setBasePlanProfitTxt(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)c.getBaseIncomebudgetMny(), (BigDecimal)c.getBaseCostbudgetMny())).toString() + "/" + ComputeUtil.scaleTwo((BigDecimal)c.getBaseIncomebudgetMny()));
                    }
                }
            } else {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        return planProfitVOS;
    }

    public static void main(String[] args) {
        System.out.println(0.24769793000355497);
    }
}

