package com.ejianc.business.plan.mapper;

import com.ejianc.business.budget.vo.PlanCostVO;
import com.ejianc.business.budget.vo.PlanProfitVO;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工计划
 * 
 * @author generator
 * 
 */
@Mapper
public interface BudgetPlanMapper extends BaseCrudMapper<BudgetPlanEntity> {

    List<PlanCostVO> getCost(Map<String, Object> queryMap);

    List<PlanProfitVO> getProfit(HashMap<String, Object> map);

    @Select("select * from ejc_probudget_plan where dr = 0 and month_end_date = #{monthEndDate}")
    List<BudgetPlanEntity> getBudgetPlan(@Param("monthEndDate") String monthEndDate);

    List<SubProjectSettleNumVO> getSubSettleNum(@Param(value = "projectIds") List<Long> projectIds);
}
