package com.ejianc.business.budget.service.impl;

import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class BudgetThread implements Runnable{

    private Logger logger;

    private IBudgetPlanService budgetPlanService;



    private Long billId;

	public void setLogger(Logger logger) {
		this.logger = logger;
	}

	public void setBudgetPlanService(IBudgetPlanService budgetPlanService) {
		this.budgetPlanService = budgetPlanService;
	}


	public void setBillId(Long billId) {
        this.billId = billId;
    }

    @Override
    public void run() {
        doSomething();
    }

    public void doSomething(){
		Date startTime = new Date();
		RecalculateVO vo = new RecalculateVO(null, billId);
		CommonResponse<RecalculateVO> recalculate = budgetPlanService.recalculate(vo, 3);
		logger.debug("预算生效重算info执行情况:{}", recalculate.getMsg());
		Date endTime = new Date();
		long timeElapsed = endTime.getTime() - startTime.getTime();
		long milliseconds = TimeUnit.MILLISECONDS.toMillis(timeElapsed);
		logger.debug("预算生效重算info执行时间: {} 毫秒", milliseconds);
    }

}
