package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.mapper.BudgetDetailMapper;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 预算管理明细
 * 
 * @author generator
 * 
 */
@Service("budgetDetailService")
public class BudgetDetailServiceImpl extends BaseServiceImpl<BudgetDetailMapper, BudgetDetailEntity> implements IBudgetDetailService{

    @Override
    public IPage<BudgetDetailEntity> queryPageList(Page<BudgetDetailEntity> page, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("*,SUM(material_plan_num) as sumNum,SUM(material_money) as sumMoney");
        wrapper.groupBy("material_id");
        IPage<BudgetDetailEntity> budgetDetailEntityIPage = baseMapper.selectPage(page, wrapper);
        return budgetDetailEntityIPage;
    }

    @Override
    public IPage<BudgetDetailEntity> queryBuildingPageList(Page<BudgetDetailEntity> page,QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("*");
        IPage<BudgetDetailEntity> budgetDetailEntityIPage = baseMapper.selectPage(page, wrapper);
        return budgetDetailEntityIPage;
    }
}
