package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.BudgetPlanItemMapper;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemService;

import java.util.List;
import java.util.Set;

/**
 * 施工计划动态列项
 * 
 * @author generator
 * 
 */
@Service("budgetPlanItemService")
public class BudgetPlanItemServiceImpl extends BaseServiceImpl<BudgetPlanItemMapper, BudgetPlanItemEntity> implements IBudgetPlanItemService{


    @Autowired
    private BudgetPlanItemMapper budgetPlanItemMapper;
    @Override
    public List<BudgetPlanItemEntity> queryByNotIds(List<Long> ids, Long planId) {
        if(null == ids || ids.size() == 0){
            return null;
        }
        QueryWrapper<BudgetPlanItemEntity> query = new QueryWrapper<>();
        query.eq("plan_id",planId);
        query.notIn("detail_id",ids);
        List<BudgetPlanItemEntity> budgetPlanItemEntities = budgetPlanItemMapper.selectList(query);
        return budgetPlanItemEntities;
    }
}
