package com.ejianc.business.subPay.service.impl;

import com.ejianc.business.budget.vo.SubPayVo;
import com.ejianc.business.subPay.service.ISubPayService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 劳务付款汇总
 *
 * @author generator
 */
@Service("laborPaymentService")
public class SubPayServiceImpl implements ISubPayService {

    /**
     * 操作需要合并的行
     *
     * @param list
     */
    @Override
    public void setNewKeyRowSpan(List<SubPayVo> list) {
        Map<Long, Integer> map = new HashMap<>();
        for (SubPayVo vo : list) {
            Long supplierId = vo.getSupplierId();
            Integer num = map.get(supplierId);
            if (num != null) {
                num++;
                map.put(supplierId, num);
            } else {
                map.put(supplierId, 1);
            }
        }
        for (SubPayVo vo : list) {
            Long supplierId = vo.getSupplierId();
            Integer num = map.get(supplierId);
            vo.setNewKeyRowSpan(num);
            map.put(supplierId, 0);
        }
    }

}
