/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.subPay.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.SubPayVo;
import com.ejianc.business.subPay.service.ISubPayService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subPay"})
public class SubPayController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String INDEX_NAME_SUBPAY = "sub_pay";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISubPayService subPayService;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"/querySubPayList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubPayVo>> querySubPayList(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Page page = new Page();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_SUBPAY});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Map params = param.getParams();
        if (params != null && params.size() > 0) {
            String endDate = this.getParamValue(params, "createTime");
            if (StringUtils.isNotBlank((CharSequence)endDate)) {
                endDate = endDate + " 23:59:59";
                RangeQueryBuilder createTime = QueryBuilders.rangeQuery((String)"createTime");
                params.remove("createTime");
                createTime.lte((Object)endDate);
                boolQuery.must((QueryBuilder)createTime);
            }
            for (Map.Entry p : params.entrySet()) {
                String key = (String)p.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort((SortBuilder)new FieldSortBuilder((FieldSortBuilder)new FieldSortBuilder("supplierId").order(SortOrder.ASC)));
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<SubPayVo> list = new ArrayList<SubPayVo>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add((SubPayVo)JSON.parseObject((String)sourceAsString, SubPayVo.class));
            }
            this.subPayService.setNewKeyRowSpan(list);
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u52b3\u52a1\u4ed8\u6b3e\u6c47\u603b\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"excelExportSubPayList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSubPayList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(10000);
        param.setPageIndex(1);
        CommonResponse<IPage<SubPayVo>> voPage = this.querySubPayList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        if (ListUtil.isNotEmpty((List)list)) {
            int i;
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
            XSSFRow row = sheet.createRow(0);
            XSSFCellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern((short)1);
            style.setAlignment((short)2);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("\u52b3\u52a1\u4ed8\u6b3e\u6c47\u603b\u8868");
            cell.setCellStyle((CellStyle)style);
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue("\u73ed\u7ec4\u540d\u79f0");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(1);
            cell.setCellValue("\u9879\u76ee");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(2);
            cell.setCellValue("\u672c\u6b21\u7533\u8bf7");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(3);
            cell.setCellValue("\u672c\u6b21\u7533\u8bf7\u5408\u8ba1");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(4);
            cell.setCellValue("\u5df2\u4ed8\u6b3e\u6bd4\u4f8b\uff08\u542b\u672c\u6b21\uff09%");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(5);
            cell.setCellValue("\u672c\u6b21\u5ba1\u6279\u91d1\u989d");
            cell.setCellStyle((CellStyle)style);
            for (i = 0; i < 6; ++i) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 10);
            }
            for (i = 0; i < list.size(); ++i) {
                SubPayVo vo = (SubPayVo)list.get(i);
                row = sheet.createRow(i + 2);
                if (vo.getNewKeyRowSpan() > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.getSupplierName() == null ? "" : vo.getSupplierName().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + vo.getNewKeyRowSpan() - 1, 0, 0));
                    cell = row.createCell(3);
                    cell.setCellValue(vo.getApplyTotal() == null ? "" : vo.getApplyTotal().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + vo.getNewKeyRowSpan() - 1, 3, 3));
                    cell = row.createCell(4);
                    cell.setCellValue(vo.getYifukuanbili() == null ? "" : vo.getYifukuanbili().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + vo.getNewKeyRowSpan() - 1, 4, 4));
                }
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectName() == null ? "" : vo.getProjectName().toString());
                cell = row.createCell(2);
                cell.setCellValue(vo.getApply() == null ? "" : vo.getApply().toString());
                cell = row.createCell(5);
                cell.setCellValue(vo.getApprovedAmount() == null ? "" : vo.getApprovedAmount().toString());
            }
            workbook.write((OutputStream)outputStream);
        }
    }

    @RequestMapping(value={"getPayQueryParam"}, method={RequestMethod.GET})
    public CommonResponse<QueryParam> getPayQueryParam() {
        try {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            return CommonResponse.success((Object)queryParam);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

