package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanRecordService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.*;
import com.ejianc.business.utils.CheckUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工计划
 *
 * @author generator
 */
@Controller
@RequestMapping("budgetPlan")
public class BudgetPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROBUDGET_PLAN";//此处需要根据实际修改

    @Autowired
    private IBudgetPlanService service;

    @Autowired
    private IBudgetPlanRecordService recordService;

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Autowired
    ICommonBusinessService budgetPlanChange;

    @RequestMapping(value = "/rec1", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecalculateVO> rec1(@RequestBody RecalculateVO vo) {
        budgetPlanChange.afterApprovalProcessor(vo.getBudgetId(), null, null);
        return null;
    }


    @RequestMapping(value = "/rec", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecalculateVO> rec(@RequestBody RecalculateVO vo) {
        return service.recalculate(vo, 2);
    }


    /***
     * @description: 新增 引入预算数据
     * @param planVO
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.plan.vo.BudgetPlanVO>
     * @author songlx
     * @date: 2021/9/7
     */
    @RequestMapping(value = "/loadBudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetTemVO> loadBudget(@RequestBody BudgetPlanVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = service.getBudgetVOByProjectId(planVO.getProjectId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(planVO.getStartMonth(), planVO.getEndMonth());
        vo.setMonthColumn(months);
        if (CollectionUtils.isNotEmpty(vo.getDetailList())) {
            for (BudgetDetailTemVO cdEntity : vo.getDetailList()) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        vo.setDetailList(TreeNodeBUtil.buildTree(vo.getDetailList()));
        return CommonResponse.success("查询项目预算成功！", vo);
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetPlanVO> saveOrUpdate(@RequestBody BudgetPlanVO saveorUpdateVO) {
        BudgetPlanEntity entity = BeanMapper.map(saveorUpdateVO, BudgetPlanEntity.class);
        // 校验是否存在生效的预算单
        QueryWrapper<BudgetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",entity.getProjectId());
        wrapper.in("bill_state",1,3);
        List<BudgetEntity> checkList = budgetService.list(wrapper);
        if(checkList.size() == 0){
            return CommonResponse.error("该项目下不存在生效的预算单！");
        }
        List<BudgetDetailTemVO> detailList = saveorUpdateVO.getDetailList();
        List<BudgetPlanItemEntity> itemList = new ArrayList<>();
        // 用于保存本次变更的计划明细id
        List<Long> selectedIds = new ArrayList<>();
        List<Long> buildingNos = new ArrayList<>();
        for (BudgetDetailTemVO v : detailList) {
            if(v.getLevelNo()==1){
                buildingNos.add(v.getId());
            }
            List<BudgetPlanItemTemVO> vItemList = v.getItemList();
            if (CollectionUtils.isNotEmpty(vItemList)) {
                selectedIds.add(v.getId());
                List<BudgetPlanItemEntity> budgetPlanItemEntities = BeanMapper.mapList(vItemList, BudgetPlanItemEntity.class);
                itemList.addAll(budgetPlanItemEntities);
            }
        }
        // 获取本次没有变更的计划,一并处理,防止删除
        List<BudgetPlanItemEntity> budgetPlanItemEntities = budgetPlanItemService.queryByNotIds(selectedIds, saveorUpdateVO.getId());
        if(null != budgetPlanItemEntities && 0 < budgetPlanItemEntities.size()){
            itemList.addAll(budgetPlanItemEntities);
        }

        if (entity.getId() == null || entity.getId() == 0) {
            QueryWrapper<BudgetPlanEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("project_id", saveorUpdateVO.getProjectId());
            List<BudgetPlanEntity> list = service.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(list)) {
                return CommonResponse.error("该项目已存在施工计划！");
            }

            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else{
            if(entity.getIsTemp() == 0){
                BigDecimal yibai = new BigDecimal(100L);
                // 查询出预算中一级列表
                QueryWrapper<BudgetDetailEntity> detailWrapper = new QueryWrapper<>();
                detailWrapper.eq("budget_id",entity.getBudgetId());
                detailWrapper.eq("level_no",1);
                detailWrapper.eq("change_type",0);
                List<BudgetDetailEntity> list1 = budgetDetailService.list(detailWrapper);
                // 初始化校验标识
                Boolean checkFlag = false;
                QueryWrapper<BudgetPlanItemEntity> queryWrapper = new QueryWrapper<>();
                List<Long> checkDetails = new ArrayList<>();
                List<BudgetPlanItemEntity> list2 = new ArrayList<>();
                for (BudgetDetailEntity b:list1
                     ) {
                    // 根据一级id 查询子集
                    detailWrapper = new QueryWrapper<>();
                    detailWrapper.eq("budget_id",entity.getBudgetId());
                    detailWrapper.eq("change_type",0);
                    detailWrapper.likeRight("inner_code",b.getId());
                    List<BudgetDetailEntity> list = budgetDetailService.list(detailWrapper);
                    checkDetails.clear();
                    list.forEach(item->{
                        checkDetails.add(item.getId());
                    });
                    list2.clear();
                    if(checkDetails.size() > 0){
                        queryWrapper = new QueryWrapper<>();
                        queryWrapper.eq("plan_id", entity.getId());
                        queryWrapper.in("detail_id",checkDetails);
                        list2 = budgetPlanItemService.list(queryWrapper);
                    }
                    // 如果子集中包含 已经填写的数据，则需要进行校验
                    for (BudgetPlanItemEntity budgetPlanItemEntity : list2) {
                        if(budgetPlanItemEntity.getPlanNum() != null || budgetPlanItemEntity.getPlanRatio() != null){
                            checkFlag = true;
                            break;
                        }
                    }
                    if(checkFlag){
                        Set<Long> detailIds = new HashSet<>();
                        list2.forEach(item->{
                            detailIds.add(item.getDetailId());
                        });
                        for (BudgetPlanItemEntity budgetPlanItemEntity : list2) {
                            if(null != budgetPlanItemEntity.getPlanRatio() && budgetPlanItemEntity.getPlanRatio().compareTo(yibai) == 0){
                                detailIds.remove(budgetPlanItemEntity.getDetailId());
                            }
                        }
                        QueryWrapper<BudgetDetailEntity> budgetQueryWrapper = new QueryWrapper<>();
                        detailIds.add(1L);
                        budgetQueryWrapper.in("id", detailIds);
                        List<BudgetDetailEntity> budgets = budgetDetailService.list(budgetQueryWrapper);
                        if(budgets.size() > 0){
                            String msg = "编辑未完成，序号 ";
                            for (BudgetDetailEntity dt:budgets
                            ) {
                                msg = msg + dt.getTreeIndex()+"、";
                            }
                            msg = msg.substring(0,msg.length()-1);
                            msg = msg + "下 必须包含一个计划比例是100% !";
                            return CommonResponse.error(msg);
                        }else{
                            // 校验通过，还原标识
                            checkFlag = false;
                        }
                    }
                }
            }
        }

        service.saveOrUpdate(entity, false);
        if (CollectionUtils.isNotEmpty(itemList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, entity.getId()));
            List<BudgetPlanItemEntity> oldItems = budgetPlanItemService.queryList(param);
            if (CollectionUtils.isNotEmpty(oldItems)) {
                Map<String, BudgetPlanItemEntity> oldMap = oldItems.stream().collect(Collectors.toMap(k -> k.getDetailId() + k.getYyearMonth(), (k) -> k));
                itemList.forEach(t -> {
                            Long detailId = t.getDetailId();
                            t.setPlanId(entity.getId());
                            BudgetPlanItemEntity oldVO = oldMap.get(detailId + t.getYyearMonth());
                            if (null != oldVO) {
                                t.setId(oldVO.getId());
                                t.setVersion(oldVO.getVersion());
                                t.setCreateTime(oldVO.getCreateTime());
                                t.setCreateUserCode(oldVO.getCreateUserCode());
                                if(t.getTenantId() == null){
                                    t.setTenantId(InvocationInfoProxy.getTenantid());
                                }
                                oldMap.remove(detailId + t.getYyearMonth());
                            }

                        }
                );
                if (MapUtils.isNotEmpty(oldMap)) {
                    List<Long> ids = oldMap.values().stream().map(BudgetPlanItemEntity::getId).collect(Collectors.toList());
                    budgetPlanItemService.removeByIds(ids);
                }

            } else {
                itemList.forEach(t -> {
                    t.setPlanId(entity.getId());
                    if(t.getTenantId() == null){
                        t.setTenantId(InvocationInfoProxy.getTenantid());
                    }
                });
            }
            budgetPlanItemService.saveOrUpdateBatch(itemList);
        }
        //if (saveorUpdateVO.getId() == null) {
        //初次保存计算当月
        RecalculateVO vo = new RecalculateVO(entity.getProjectId(), null);
        CommonResponse<RecalculateVO> recalculate = service.recalculate(vo, 3);
        if (!recalculate.isSuccess()) {
            logger.error(recalculate.getMsg());
        }
        //}
        if(buildingNos.size()==0){
            return this.queryDetail(entity.getId());
        }
        return this.queryDetailByBuildingNo(entity.getId(),buildingNos);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetPlanVO> queryDetail(Long id) {

        BudgetPlanEntity entity = service.selectById(id);
        BudgetPlanVO planVO = BeanMapper.map(entity, BudgetPlanVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = service.getBudgetById(entity.getBudgetId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(entity.getStartMonth(), entity.getEndMonth());
        planVO.setMonthColumn(months);
        List<BudgetDetailTemVO> detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            QueryParam param = new QueryParam();
            List<Long> detailIds = detailList.stream().map(BudgetDetailTemVO::getId).collect(Collectors.toList());
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, id));
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, detailIds));
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.queryList(param);

            List<BudgetPlanItemTemVO> itemTemVOS = BeanMapper.mapList(planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList(listMap.get(t.getId())));
            planVO.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        List<String> uninBuildingNos = CheckUtil.CheckAllBuilding(1, entity.getId(), entity.getBudgetId());
        planVO.setUninBuildingNos(uninBuildingNos);

        planVO.setRecordList(recordService.queryDetailRecord(planVO.getId()));

        return CommonResponse.success("查询详情数据成功！", planVO);
    }

    /**
     * @param id
     * @Description queryDetail 根据楼号查询详情
     */
    @RequestMapping(value = "/queryDetailByBuildingNo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetPlanVO> queryDetailByBuildingNo(@RequestParam("id")Long id,@RequestParam("buildingNos")List<Long> buildingNos) {
        BudgetPlanEntity entity = service.selectById(id);
        BudgetPlanVO planVO = BeanMapper.map(entity, BudgetPlanVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = service.getBudgetByIdAndBuildingNos(entity.getBudgetId(),buildingNos);
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(entity.getStartMonth(), entity.getEndMonth());
        planVO.setMonthColumn(months);
        List<BudgetDetailTemVO> detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            QueryParam param = new QueryParam();
            List<Long> detailIds = detailList.stream().map(BudgetDetailTemVO::getId).collect(Collectors.toList());
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, id));
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, detailIds));
            List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.queryList(param);
            List<BudgetPlanItemTemVO> itemTemVOS = BeanMapper.mapList(planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList(listMap.get(t.getId())));
            planVO.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        List<String> uninBuildingNos = CheckUtil.CheckAllBuilding(1, entity.getId(), entity.getBudgetId());
        planVO.setUninBuildingNos(uninBuildingNos);
        planVO.setRecordList(recordService.queryDetailRecord(planVO.getId()));
        return CommonResponse.success("查询详情数据成功！", planVO);
    }

    /**
     * @param planVO
     * @Description queryDetail 根据选中楼号重新查询详情
     */
    @RequestMapping(value = "/reloadBudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetTemVO> reloadBudget(@RequestBody BudgetPlanVO planVO) {
        CommonResponse<BudgetTemVO> budgetByProjectId = service.getBudgetVOByProjectIdAndKeys(planVO.getProjectId(),planVO.getSelectedKeys());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(planVO.getStartMonth(), planVO.getEndMonth());
        vo.setMonthColumn(months);
        if (CollectionUtils.isNotEmpty(vo.getDetailList())) {
            for (BudgetDetailTemVO cdEntity : vo.getDetailList()) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        vo.setDetailList(TreeNodeBUtil.buildTree(vo.getDetailList()));
        return CommonResponse.success("查询项目预算成功！", vo);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetPlanVO> vos) {
        service.removeByIds(vos.stream().map(BudgetPlanVO::getId).collect(Collectors.toList()), true);
        List<Long> planIds = vos.stream().map(BudgetPlanVO::getId).collect(Collectors.toList());
        QueryWrapper<BudgetPlanItemEntity> rapper = new QueryWrapper<>();
        rapper.in("plan_id", planIds);
        budgetPlanItemService.remove(rapper);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BudgetPlanEntity> page = service.queryPage(param, false);
        IPage<BudgetPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanVO>> refBudgetPlanData(@RequestParam Integer
                                                                         pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetPlanEntity> page = service.queryPage(param, false);
        IPage<BudgetPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
