package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.plan.bean.BudgetPlanItemRecordEntity;
import com.ejianc.business.plan.bean.BudgetPlanRecordEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemRecordService;
import com.ejianc.business.plan.service.IBudgetPlanRecordService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetPlanItemTemVO;
import com.ejianc.business.plan.vo.BudgetPlanRecordVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工计划记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetPlanRecord")
public class BudgetPlanRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBudgetPlanRecordService service;


    @Autowired
    private IBudgetPlanItemRecordService itemRecordService;


    @Autowired
    private IBudgetPlanService planService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetPlanRecordVO> saveOrUpdate(@RequestBody BudgetPlanRecordVO saveorUpdateVO) {
    	BudgetPlanRecordEntity entity = BeanMapper.map(saveorUpdateVO, BudgetPlanRecordEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	BudgetPlanRecordVO vo = BeanMapper.map(entity, BudgetPlanRecordVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetPlanRecordVO> queryDetail(Long id) {
    	BudgetPlanRecordEntity entity = service.selectById(id);
    	BudgetPlanRecordVO recordVO = BeanMapper.map(entity, BudgetPlanRecordVO.class);
        CommonResponse<BudgetTemVO> budgetByProjectId = planService.getBudgetByProjectId3(entity.getProjectId());
        if (!budgetByProjectId.isSuccess()) {
            return CommonResponse.error(budgetByProjectId.getMsg());
        }
        BudgetTemVO vo = budgetByProjectId.getData();
        List<String> months = DateUtil.getMonthBetween(entity.getStartMonth(), entity.getEndMonth());
        recordVO.setMonthColumn(months);

        List<BudgetDetailTemVO> detailList = vo.getDetailList();

        if (CollectionUtils.isNotEmpty(detailList)) {
            QueryParam param = new QueryParam();
            List<Long> detailIds = detailList.stream().map(BudgetDetailTemVO::getId).collect(Collectors.toList());
            param.getParams().put("plan_id", new Parameter(QueryParam.EQ, id));
            param.getParams().put("detail_id", new Parameter(QueryParam.IN, detailIds));
            List<BudgetPlanItemRecordEntity> planItemEntities = itemRecordService.queryList(param);

            List<BudgetPlanItemTemVO> itemTemVOS = BeanMapper.mapList(planItemEntities, BudgetPlanItemTemVO.class);
            Map<Long, List<BudgetPlanItemTemVO>> listMap = itemTemVOS.stream().collect(Collectors.groupingBy(BudgetPlanItemTemVO::getDetailId));
            detailList.forEach(t -> t.setItemList(listMap.get(t.getId())));
            recordVO.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return CommonResponse.success("查询详情数据成功！",recordVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetPlanRecordVO> vos) {
        service.removeByIds(vos.stream().map(BudgetPlanRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BudgetPlanRecordEntity> page = service.queryPage(param,false);
        IPage<BudgetPlanRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanRecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetPlanRecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetPlanRecord-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetPlanRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetPlanRecordVO>> refBudgetPlanRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetPlanRecordEntity> page = service.queryPage(param,false);
        IPage<BudgetPlanRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetPlanRecordVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
