package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.vo.BudgetChangeRecordVO;
import com.ejianc.business.plan.vo.BudgetPlanRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.BudgetPlanRecordMapper;
import com.ejianc.business.plan.bean.BudgetPlanRecordEntity;
import com.ejianc.business.plan.service.IBudgetPlanRecordService;

import java.util.List;

/**
 * 施工计划记录
 * 
 * @author generator
 * 
 */
@Service("budgetPlanRecordService")
public class BudgetPlanRecordServiceImpl extends BaseServiceImpl<BudgetPlanRecordMapper, BudgetPlanRecordEntity> implements IBudgetPlanRecordService{

    @Override
    public List<BudgetPlanRecordVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<BudgetPlanRecordEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(BudgetPlanRecordEntity::getSourcePlanId, id);
        List<BudgetPlanRecordEntity> entities = super.list(lambda);
        lambda.orderByAsc(BudgetPlanRecordEntity::getUsedTime);
        List<BudgetPlanRecordVO> recordVOList = BeanMapper.mapList(entities, BudgetPlanRecordVO.class);
        return recordVOList;
    }
}
