package com.ejianc.business.recoveries.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.PlanCostVO;
import com.ejianc.business.recoveries.BudgetRecoveriesVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Controller
@RequestMapping("budgetRecoveries")
public class BudgetRecoveriesController {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    private final static Integer QUERY_TIMEOUT = 60;
    private final static Integer BATCH_SIZE = 1000;
    private final static String INDEX_NAME_Receive = "receive_summary";
    @Autowired(required = false)
    private RestHighLevelClient client;

    @RequestMapping(value = "/queryRecoveriesList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetRecoveriesVO>> queryRecoveriesList(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        IPage<BudgetRecoveriesVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_Receive);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        Map<String, Parameter> params = param.getParams();
        if (params != null && params.size() > 0) {

            //截止时间
            String endDate = getParamValue(params, "createTime");
            if (StringUtils.isNotBlank(endDate)) {
                Date date = DateUtil.date();
                int year = DateUtil.year(date);
                endDate = year + "-" + endDate + "-31 23:59:59";
                RangeQueryBuilder createTime = QueryBuilders.rangeQuery("createTime");
                params.remove("createTime");
                createTime.lte(endDate);
                boolQuery.must(createTime);
            }

            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isEmpty(value)) continue;
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);
        sourceBuilder.sort(new FieldSortBuilder(new FieldSortBuilder("orgIdNum").order(SortOrder.ASC)));
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        List<BudgetRecoveriesVO> list = new ArrayList<>();
        SearchResponse response = null;
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject(sourceAsString, BudgetRecoveriesVO.class));
            }
            if (CollectionUtils.isNotEmpty(list)) {
                Map<Long, List<BudgetRecoveriesVO>> map = list.stream().collect(Collectors.groupingBy(BudgetRecoveriesVO::getOrgId));
                for (BudgetRecoveriesVO v : list) {
                    Long orgId = v.getOrgId();
                    List<BudgetRecoveriesVO> ll = map.get(orgId);
                    if (CollectionUtils.isNotEmpty(ll)) {
                        v.setOrgRowSpan(ll.size());
                        map.remove(orgId);
                    } else {
                        v.setOrgRowSpan(0);
                    }
                }
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询成本控制列表数据成功！", page);
    }

    @RequestMapping(value = "/reloadCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanCostVO> reloadCost(@RequestBody QueryParam param) {

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        try {
            this.deleteESData(INDEX_NAME_Receive);
//            this.loadCostList2ES(param);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return CommonResponse.success("重新加载成本控制数据成功！");
    }


    private long deleteESData(String indexName) throws IOException {
        Long resultSize = queryIndexSize(indexName);
        Long deleteTimes = resultSize % BATCH_SIZE;
        for (int i = 0; i < deleteTimes + 1; i++) {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(indexName);
            deleteByQueryRequest.setQuery(new TermQueryBuilder("tenantId", InvocationInfoProxy.getTenantid()));
            deleteByQueryRequest.setBatchSize(BATCH_SIZE);
            BulkByScrollResponse response = client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        return 0;
    }

    private Long queryIndexSize(String indexName) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(indexName);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        // 查询参数
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid());

        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must(termQueryBuilder);

        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); // 设置超时时间

        searchRequest.source(sourceBuilder);

        try {
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            resultSize = hits.getTotalHits().value;
        } catch (IOException e) {
            try { //  重试一次
                SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                resultSize = hits.getTotalHits().value;
            } catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e1.getMessage());
            }
        }
        return resultSize;
    }


    @RequestMapping(value = "excelExportInAndOutStoreList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(10000);
        param.setPageIndex(1);
        CommonResponse<IPage<BudgetRecoveriesVO>> voPage = queryRecoveriesList(param);
        List<BudgetRecoveriesVO> list = voPage.getData().getRecords();
        int num = 0;
        if (ListUtil.isNotEmpty(list)) {
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
            //首行标题
            XSSFRow row = sheet.createRow(0);
            CellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern(CellStyle.SOLID_FOREGROUND);
            style.setAlignment(CellStyle.ALIGN_CENTER);

            XSSFCell cell = row.createCell(0);
            cell.setCellValue("回款汇总");
            cell.setCellStyle(style);
            //第二行数据
            row = sheet.createRow(1);

            cell = row.createCell(0);
            cell.setCellValue("区域");

            cell.setCellStyle(style);
            cell = row.createCell(1);
            cell.setCellValue("项目经理");

            cell.setCellStyle(style);
            cell = row.createCell(2);
            cell.setCellStyle(style);
            cell.setCellValue("项目");

            cell = row.createCell(3);
            cell.setCellValue("投资主体");
            cell.setCellStyle(style);

            cell = row.createCell(4);
            cell.setCellValue("发包单位");
            cell.setCellStyle(style);

            cell = row.createCell(5);
            cell.setCellValue("回款金额");
            cell.setCellStyle(style);

            cell = row.createCell(6);
            cell.setCellValue("实际回款");
            cell.setCellStyle(style);

            cell = row.createCell(7);
            cell.setCellValue("余额");
            cell.setCellStyle(style);

            for (int i = 0; i < 7; i++) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 60 / 10);
            }
            for (int i = 0; i < list.size(); i++) {
                BudgetRecoveriesVO vo = list.get(i);
                row = sheet.createRow(i + 2);
                if (vo.getOrgRowSpan() > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.getOrgName() == null ? "" : vo.getOrgName().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (vo.getOrgRowSpan() - 1), 0, 0));
                }
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectManager() != null ? vo.getProjectManager().toString() : null);

                cell = row.createCell(2);
                cell.setCellValue(vo.getProjectName() != null ? vo.getProjectName().toString() : null);

                cell = row.createCell(3);
                cell.setCellValue(vo.getInvestorName() != null ? vo.getInvestorName().toString() : null);

                cell = row.createCell(4);
                cell.setCellValue(vo.getPubUnitName() != null ? vo.getPubUnitName().toString() : null);

                cell = row.createCell(5);
                cell.setCellValue(vo.getSumQuoteTaxMny() != null ? vo.getSumQuoteTaxMny().toString() : null);

                cell = row.createCell(6);
                cell.setCellValue(vo.getReceiveMny() != null ? vo.getReceiveMny().toString() : null);

                cell = row.createCell(7);
                cell.setCellValue(vo.getYue() != null ? vo.getYue().toString() : null);
            }
            List<Integer> list1 = new ArrayList<>();
            list.forEach(item -> {
                if (item.getOrgRowSpan() > 0) {
                    Integer orgRowSpan = item.getOrgRowSpan();
                    list1.add(orgRowSpan);
                    int sum1 = (int) list1.stream().collect(Collectors.summarizingInt(value -> value)).getSum();
                    sheet.shiftRows(sum1 + 2, sheet.getLastRowNum() + 1, 1, true, false);
                    XSSFRow newRow = sheet.createRow(sum1 + 2);
                    XSSFCell newCell = newRow.createCell(0);
                    newCell = newRow.createCell(0);
                    newCell.setCellValue(item.getOrgName() == null ? "" : item.getOrgName().toString());
                    newCell = newRow.createCell(1);
                    newCell.setCellValue("合计");
                    BigDecimal sumQuoteTaxMny = list.stream().filter(s -> s.getOrgId().equals(item.getOrgId())).map(BudgetRecoveriesVO::getSumQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(5);
                    newCell.setCellValue(sumQuoteTaxMny != null ? sumQuoteTaxMny.toString() : null);
                    BigDecimal receiveMny = list.stream().filter(s -> s.getOrgId().equals(item.getOrgId())).map(BudgetRecoveriesVO::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(6);
                    newCell.setCellValue(receiveMny != null ? receiveMny.toString() : null);
                    BigDecimal yun = list.stream().filter(s -> s.getOrgId().equals(item.getOrgId())).map(BudgetRecoveriesVO::getYue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(7);
                    newCell.setCellValue(yun != null ? yun.toString() : null);
                    list1.remove(orgRowSpan);
                    list1.add(orgRowSpan + 1);
                }
            });
            workbook.write(outputStream);
        }

    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}
