package com.ejianc.business.budget.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.budget.bean.BudgetChangeDetailEntity;
import com.ejianc.business.budget.vo.BudgetChangeDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.vo.BudgetChangeVO;

/**
 * 预算变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetChange")
public class BudgetChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBudgetChangeService budgetChangeService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetChangeVO> saveOrUpdate(@RequestBody BudgetChangeVO changeVO) {
    	BudgetChangeVO vo = budgetChangeService.insertOrUpdate(changeVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description  新增变更主键查询转换变更
     * @param budgetId
     * @Return com.ejianc.framework.core.response.CommonResponse<BudgetChangeVO>
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetChangeVO> addConvertByConId(Long budgetId) {
        BudgetChangeVO vo = budgetChangeService.addConvertByConId(budgetId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetChangeVO> queryDetail(Long id) {
    	BudgetChangeVO vo = budgetChangeService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetChangeVO> vos) {
        return budgetChangeService.deleteByIds(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetChangeVO>> queryList(@RequestBody QueryParam param) {
        return budgetChangeService.queryListVOs(param);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budget-detail-import.xlsx", "预算清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response,@RequestParam(value = "budgetChangeId") String budgetChangeId, @RequestParam(value = "budgetId")String budgetId,@RequestParam("json") String json) {
        List<BudgetChangeDetailEntity> entities = JSONObject.parseArray(json, BudgetChangeDetailEntity.class);
        return budgetChangeService.excelImport(request, response, budgetChangeId, budgetId,entities);
    }
}
