package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetRecordDetailEntity;
import com.ejianc.business.budget.bean.BudgetRecordEntity;
import com.ejianc.business.budget.mapper.BudgetRecordMapper;
import com.ejianc.business.budget.service.IBudgetRecordDetailService;
import com.ejianc.business.budget.service.IBudgetRecordService;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 预算记录
 *
 * @author generator
 *
 */
@Service("budgetRecordService")
public class BudgetRecordServiceImpl extends BaseServiceImpl<BudgetRecordMapper, BudgetRecordEntity> implements IBudgetRecordService{

    @Autowired
    IBudgetRecordDetailService budgetRecordDetailService;

    @Override
    public BudgetVO queryDetail(Long id, Boolean detailHasChildren) {
        LambdaQueryWrapper<BudgetRecordEntity> lambda = Wrappers.<BudgetRecordEntity>lambdaQuery();
        lambda.eq(BudgetRecordEntity::getChangeId, id);
        BudgetRecordEntity budgetRecordEntity = super.getOne(lambda);
        BudgetVO budgetVO =  BeanMapper.map(budgetRecordEntity, BudgetVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter(QueryParam.EQ, budgetRecordEntity.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<BudgetRecordDetailEntity> detailEntityListDb = budgetRecordDetailService.queryList(queryParam, false);
        List<BudgetRecordDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(BudgetRecordDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getBudgetDetailId().toString());
                cdEntity.setId(cdEntity.getBudgetDetailId());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<BudgetDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, BudgetDetailVO.class);
            if(detailHasChildren){
                budgetVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                budgetVO.setDetailList(resultMapList);
            }
        }

        return budgetVO;
    }
}
