/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller.api;

import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/budgetPlan/"})
public class BudgetPlanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IBudgetPlanService budgetPlanService;

    @RequestMapping(value={"recal"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecalculateVO> recal(@RequestBody RecalculateVO vo) {
        return this.budgetPlanService.recalculate(vo, 2);
    }

    @RequestMapping(value={"recal3"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecalculateVO> recal3(@RequestParam(value="projectId") Long projectId) {
        RecalculateVO vo = new RecalculateVO(projectId, null);
        return this.budgetPlanService.recalculate(vo, 3);
    }

    @RequestMapping(value={"getInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecalculateVO> getInfo(@RequestBody RecalculateVO vo) {
        return this.budgetPlanService.getInfo(vo);
    }

    @RequestMapping(value={"getPlanNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecalculateVO> getPlanNum(@RequestBody RecalculateVO vo) {
        return this.budgetPlanService.getPlanNum(vo);
    }

    @RequestMapping(value={"getBudget"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetTemVO> getBudget(@RequestParam(value="projectId") Long projectId) {
        return this.budgetPlanService.getBudgetVOByProjectId(projectId);
    }
}

