/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.mapper.BudgetMapper;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.utils.ExcelReader;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.business.plan.vo.BudgetCheckVO;
import com.ejianc.business.utils.BudgetCheckUtil;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetService")
public class BudgetServiceImpl
extends BaseServiceImpl<BudgetMapper, BudgetEntity>
implements IBudgetService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IBudgetChangeService budgetChangeService;
    @Autowired
    private IMaterialApi materialApi;
    private static final String BILL_CODE = "PROBUDGET_BUDGET";

    @Override
    public BudgetVO insertOrUpdate(BudgetVO budgetVO) {
        this.checkIsOne(budgetVO.getProjectId(), budgetVO.getId());
        if (StringUtils.isEmpty((CharSequence)budgetVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                budgetVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BudgetEntity budgetEntity = (BudgetEntity)((Object)BeanMapper.map((Object)budgetVO, BudgetEntity.class));
        budgetEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        budgetEntity.setBaseIncomebudgetMny(budgetEntity.getIncomebudgetMny());
        budgetEntity.setBeforeIncomebudgetMny(budgetEntity.getIncomebudgetMny());
        budgetEntity.setBaseCostbudgetMny(budgetEntity.getCostbudgetMny());
        budgetEntity.setBeforeCostbudgetMny(budgetEntity.getCostbudgetMny());
        budgetEntity.setBaseLaborMny(budgetEntity.getLaborMny());
        budgetEntity.setBeforeLaborMny(budgetEntity.getLaborMny());
        budgetEntity.setBaseMaterialMny(budgetEntity.getMaterialMny());
        budgetEntity.setBeforeMaterialMny(budgetEntity.getMaterialMny());
        budgetEntity.setBaseManageMny(budgetEntity.getManageMny());
        budgetEntity.setBeforeManageMny(budgetEntity.getManageMny());
        budgetEntity.setBaseIncomebudgetAdjustMny(budgetEntity.getIncomebudgetAdjustMny());
        budgetEntity.setBeforeIncomebudgetAdjustMny(budgetEntity.getIncomebudgetAdjustMny());
        super.saveOrUpdate((Object)budgetEntity, false);
        List<BudgetDetailEntity> detailEntityList = budgetEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetDetailEntity cdEntity : detailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                cdEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            BudgetCheckUtil.checkWeightScale(treeData);
            List<Map<String, Object>> ListCodeDate = this.creatInnerCode(treeData, null);
            ArrayList<BudgetDetailEntity> entities = new ArrayList<BudgetDetailEntity>();
            this.treeToList(ListCodeDate, entities);
            this.budgetDetailService.saveOrUpdateBatch(entities, entities.size(), false);
        }
        return this.queryDetail(budgetEntity.getId(), true);
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("tenantId") == null) {
                ypd.put("tenantId", InvocationInfoProxy.getTenantid());
            }
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((BudgetDetailEntity)((Object)BeanMapper.map(ypd, BudgetDetailEntity.class)));
        }
    }

    private void checkIsOne(Long projectId, Long budgetId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetEntity::getProjectId, (Object)projectId);
        queryWrapper.ne(null != budgetId, BaseEntity::getId, (Object)budgetId);
        if (CollectionUtils.isNotEmpty((Collection)this.list((Wrapper)queryWrapper))) {
            throw new BusinessException("\u4e00\u4e2a\u9879\u76ee\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4efd\u9884\u7b97\u5355");
        }
    }

    @Override
    public BudgetVO queryDetail(Long id, boolean detailHasChildren) {
        BudgetEntity budgetEntity = (BudgetEntity)((Object)super.selectById((Serializable)id));
        BudgetVO budgetVO = (BudgetVO)BeanMapper.map((Object)((Object)budgetEntity), BudgetVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("budgetId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.budgetDetailService.queryList(queryParam, false);
        List budgetDetailVOS = BeanMapper.mapList((Iterable)detailEntityListDb, BudgetDetailVO.class);
        budgetDetailVOS.forEach(item -> {
            String[] split;
            Integer treeNumber = 0;
            Integer baseSystem = 100;
            Integer useNumber = 1000000;
            String treeIndex = item.getTreeIndex();
            for (String s : split = treeIndex.split("\\.")) {
                treeNumber = treeNumber + Integer.parseInt(s) * useNumber;
                useNumber = useNumber / baseSystem;
            }
            item.setTreeNumber(treeNumber);
        });
        Collections.sort(budgetDetailVOS, new Comparator<BudgetDetailVO>(){

            @Override
            public int compare(BudgetDetailVO o1, BudgetDetailVO o2) {
                return o1.getTreeNumber().compareTo(o2.getTreeNumber());
            }
        });
        detailEntityListDb = BeanMapper.mapList((Iterable)budgetDetailVOS, BudgetDetailEntity.class);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || !ChangeTypeEnum.\u4e2d\u6b62.getCode().equals(entity.getChangeType())) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (BudgetDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, BudgetDetailVO.class);
            if (detailHasChildren) {
                budgetVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                budgetVO.setDetailList(resultMapList);
            }
        } else {
            budgetVO.setDetailList(BeanMapper.mapList(detailEntityList, BudgetDetailVO.class));
        }
        if (null != budgetEntity.getChangeVersion() && budgetEntity.getChangeVersion() > 0) {
            budgetVO.setRecordList(this.budgetChangeService.queryDetailRecord(budgetEntity.getId()));
        }
        return budgetVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        HashSet<String> materialNameSet = new HashSet<String>();
        ArrayList<BudgetCheckVO> checkVOS = new ArrayList<BudgetCheckVO>();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            boolean levelFlag = false;
            boolean levelBlankFlag = false;
            int oneNo = 0;
            int twoNo = 0;
            int threeNo = 0;
            int fourNo = 0;
            Integer lastLevelNo = -1;
            String nextLevel = "1";
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BudgetDetailVO> detailVoList = new ArrayList<BudgetDetailVO>();
            HashMap<String, BudgetDetailVO> tidMap = new HashMap<String, BudgetDetailVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BudgetDetailVO vo = new BudgetDetailVO();
                boolean flag = false;
                String warnType = "";
                StringBuffer detailIndex = new StringBuffer();
                String buildingNo = (String)datas.get(0);
                String buildContent = (String)datas.get(1);
                String craft = (String)datas.get(2);
                String materialName = (String)datas.get(9);
                Integer levelNo = -1;
                if (StringUtils.isNotBlank((CharSequence)buildingNo)) {
                    ++oneNo;
                    levelNo = 1;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    if (lastLevelNo == 4) {
                        twoNo = 0;
                        threeNo = 0;
                        fourNo = 0;
                    }
                    nextLevel = "2";
                    detailIndex.append(oneNo);
                    levelBlankFlag = true;
                    vo.setBuildingNo(buildingNo);
                } else if (StringUtils.isNotBlank((CharSequence)buildContent)) {
                    ++twoNo;
                    levelNo = 2;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    if (lastLevelNo == 4) {
                        threeNo = 0;
                        fourNo = 0;
                    }
                    nextLevel = "3";
                    detailIndex.append(oneNo).append(".").append(twoNo);
                    levelBlankFlag = true;
                    vo.setBuildContent(buildContent);
                } else if (StringUtils.isNotBlank((CharSequence)craft)) {
                    ++threeNo;
                    levelNo = 3;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    if (lastLevelNo == 4) {
                        fourNo = 0;
                    }
                    nextLevel = "4";
                    detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo);
                    levelBlankFlag = true;
                    vo.setCraft(craft);
                } else if (StringUtils.isNotBlank((CharSequence)materialName)) {
                    ++fourNo;
                    levelNo = 4;
                    if (!nextLevel.contains(levelNo.toString())) {
                        warnType = warnType + "\u5c42\u7ea7\u4e0d\u5bf9,";
                        flag = true;
                        levelFlag = true;
                    }
                    nextLevel = "1,2,3,4";
                    detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo).append(".").append(fourNo);
                    levelBlankFlag = true;
                    materialNameSet.add(materialName.trim());
                    vo.setMaterialName(materialName);
                }
                lastLevelNo = levelNo;
                vo.setTreeIndex(detailIndex.toString());
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                String[] split = detailIndex.toString().split("[-/.]");
                vo.setTid(id);
                tidMap.put(detailIndex.toString(), vo);
                if (split.length > 1) {
                    vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                }
                indexMap.put(detailIndex.toString(), i);
                if (!levelBlankFlag) {
                    warnType = warnType + "\u697c\u53f7\u3001\u65bd\u5de5\u5185\u5bb9\u3001\u5de5\u827a\u3001\u6750\u6599\u540d\u79f0\u4e0d\u80fd\u90fd\u4e3a\u7a7a,";
                    flag = true;
                }
                vo.setLevelNo(levelNo);
                if (levelNo == 3) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                        vo.setBudgetNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setBudgetNum(new BigDecimal((String)datas.get(4)));
                        }
                        catch (Exception e) {
                            vo.setBudgetNum(null);
                            warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    vo.setBudgetUnit((String)datas.get(5));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                        vo.setBudgetPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setBudgetPrice(new BigDecimal((String)datas.get(6)));
                        }
                        catch (Exception e) {
                            vo.setBudgetPrice(null);
                            warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    vo.setBudgetMoney(ComputeUtil.safeMultiply((BigDecimal)vo.getBudgetNum(), (BigDecimal)vo.getBudgetPrice()));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                        vo.setCostNum(null);
                        warnType = warnType + "\u6210\u672c\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setCostNum(new BigDecimal((String)datas.get(7)));
                        }
                        catch (Exception e) {
                            vo.setCostNum(null);
                            warnType = warnType + "\u6210\u672c\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        vo.setCostPrice(null);
                        warnType = warnType + "\u4eba\u5de5\u5355\u4ef7\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setCostPrice(new BigDecimal((String)datas.get(8)));
                        }
                        catch (Exception e) {
                            vo.setCostPrice(null);
                            warnType = warnType + "\u4eba\u5de5\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    vo.setCostMoney(ComputeUtil.safeMultiply((BigDecimal)vo.getCostNum(), (BigDecimal)vo.getCostPrice()));
                }
                if (levelNo == 4) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9)))) {
                        vo.setMaterialName(null);
                        warnType = warnType + "\u6750\u6599\u540d\u79f0/\u4f53\u7cfb\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        vo.setMaterialName((String)datas.get(9));
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10)))) {
                        vo.setMaterialWeightScale(null);
                    } else {
                        try {
                            vo.setMaterialWeightScale(ComputeUtil.safeMultiply((BigDecimal)new BigDecimal(100), (BigDecimal)new BigDecimal((String)datas.get(10))));
                        }
                        catch (Exception e) {
                            vo.setMaterialWeightScale(null);
                            warnType = warnType + "\u4ea7\u503c\u6743\u91cd\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(11)))) {
                        vo.setMaterialUsedScale(null);
                    } else {
                        try {
                            vo.setMaterialUsedScale(ComputeUtil.safeMultiply((BigDecimal)new BigDecimal(100), (BigDecimal)new BigDecimal((String)datas.get(11))));
                        }
                        catch (Exception e) {
                            vo.setMaterialUsedScale(null);
                            warnType = warnType + "\u6750\u6599\u4f7f\u7528\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12)))) {
                        vo.setMaterialPrice(null);
                        warnType = warnType + "\u6750\u6599\u5355\u4ef7\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setMaterialPrice(new BigDecimal((String)datas.get(12)));
                        }
                        catch (Exception e) {
                            vo.setMaterialPrice(null);
                            warnType = warnType + "\u6750\u6599\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13)))) {
                        vo.setMaterialUsedNum(null);
                        warnType = warnType + "\u8017\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setMaterialUsedNum(new BigDecimal((String)datas.get(13)));
                        }
                        catch (Exception e) {
                            vo.setMaterialUsedNum(null);
                            warnType = warnType + "\u8017\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    BigDecimal parCostNum = tidMap.get(vo.getTpid()) != null ? ((BudgetDetailVO)tidMap.get(vo.getTpid())).getCostNum() : null;
                    vo.setMaterialPlanNum(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialUsedNum(), (BigDecimal)parCostNum));
                    vo.setMaterialMoney(ComputeUtil.safeMultiply((BigDecimal)vo.getMaterialPlanNum(), (BigDecimal)vo.getMaterialPrice()));
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(14)))) {
                        vo.setMaterialUnit(null);
                        warnType = warnType + "\u6750\u6599\u5355\u4f4d\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        vo.setMaterialUnit((String)datas.get(14));
                    }
                    vo.setLeafFlag(Boolean.valueOf(true));
                    BudgetCheckVO checkVO = this.getCheckVO(detailVoList, (String)datas.get(9));
                    Boolean likeFlag = false;
                    for (BudgetCheckVO item : checkVOS) {
                        if (!checkVO.getLevel1().equals(item.getLevel1()) || !checkVO.getLevel2().equals(item.getLevel2()) || !checkVO.getLevel3().equals(item.getLevel3()) || !checkVO.getLevel4().equals(item.getLevel4())) continue;
                        warnType = warnType + "\u7b2c" + (i + 2) + "\u884c\u6570\u636e\u91cd\u590d,";
                        flag = true;
                        likeFlag = true;
                        break;
                    }
                    if (!likeFlag.booleanValue()) {
                        checkVOS.add(checkVO);
                    }
                } else {
                    vo.setLeafFlag(Boolean.valueOf(false));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            Iterator i = detailVoList.iterator();
            while (i.hasNext()) {
                BudgetDetailVO tVo;
                tVo.setTpid(tidMap.get((tVo = (BudgetDetailVO)i.next()).getTpid()) != null ? ((BudgetDetailVO)tidMap.get(tVo.getTpid())).getTid() : null);
            }
            CommonResponse materialListresp = this.materialApi.queryMaterialListByNames(new ArrayList(materialNameSet));
            Map materialMap = null;
            if (materialListresp.isSuccess()) {
                materialMap = ((List)materialListresp.getData()).stream().collect(Collectors.toMap(MaterialVO::getName, Function.identity(), (key1, key2) -> key2));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            levelFlag = this.getLevelFlag(deailTreeData, materialMap);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)deailTreeData, falseList);
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            if (levelFlag) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
            } else {
                resp.put("successList", this.convertJsonToVoList((List)allList.get(0)));
                resp.put("successNum", (Object)(result.size() - errorList.size()));
            }
            resp.put("errorList", (Object)errorList);
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    private List<BudgetDetailVO> convertJsonToVoList(List<Map<String, Object>> successList) {
        List success = ExcelImportUtil.treeToListNoWarn(successList);
        List detailVOList = BeanMapper.mapList((Iterable)success, BudgetDetailVO.class);
        return BudgetServiceImpl.buildTreeByTid(detailVOList);
    }

    private BudgetCheckVO getCheckVO(List<BudgetDetailVO> list, String level4) {
        BudgetCheckVO budgetCheckVO = new BudgetCheckVO();
        budgetCheckVO.setLevel4(level4);
        list.forEach(item -> {
            if (item.getLevelNo() == 1) {
                budgetCheckVO.setLevel1(item.getBuildingNo());
            } else if (item.getLevelNo() == 2) {
                budgetCheckVO.setLevel2(item.getBuildContent());
            } else if (item.getLevelNo() == 3) {
                budgetCheckVO.setLevel3(item.getCraft());
            }
        });
        return budgetCheckVO;
    }

    private boolean getLevelFlag(List<Map<String, Object>> mapList, Map<String, MaterialVO> materialMap) {
        for (Map<String, Object> map : mapList) {
            List child = (List)map.get("children");
            if (child != null) {
                if (!this.getLevelFlag(child, materialMap)) continue;
                return true;
            }
            if (null != map.get("materialName")) {
                if (materialMap.containsKey(map.get("materialName"))) {
                    MaterialVO materialVO = materialMap.get(map.get("materialName"));
                    map.put("materialId", materialVO.getId());
                } else if (!((Boolean)map.get("importFlag")).booleanValue()) {
                    map.put("warnType", map.get("warnType") + ", \u6839\u636e\u540d\u79f0\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u8d44");
                } else {
                    map.put("importFlag", false);
                    map.put("warnType", "\u6839\u636e\u540d\u79f0\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u8d44");
                }
            }
            if (null == map.get("warnType") || !((String)map.get("warnType")).contains("\u6743\u91cd\u548c\u4e0d\u4e3a1")) continue;
            return true;
        }
        return false;
    }

    public static List<BudgetDetailVO> buildTreeByTid(List<BudgetDetailVO> values) {
        BudgetDetailVO parentNode;
        HashMap<String, BudgetDetailVO> nodeMap = new HashMap<String, BudgetDetailVO>();
        ArrayList<BudgetDetailVO> result = new ArrayList<BudgetDetailVO>();
        ArrayList<BudgetDetailVO> emptyValueList = new ArrayList<BudgetDetailVO>();
        for (BudgetDetailVO value : values) {
            if (StringUtils.isBlank((CharSequence)value.getTpid())) {
                result.add(value);
            } else {
                parentNode = (BudgetDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getTid(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (BudgetDetailVO value : emptyValueList) {
                parentNode = (BudgetDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }
}

