/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CheckUtil {
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;
    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;
    @Autowired
    private IBudgetPlanService budgetPlanService;
    private static CheckUtil checkUtil;

    @PostConstruct
    public void init() {
        checkUtil = this;
        CheckUtil.checkUtil.budgetDetailService = this.budgetDetailService;
        CheckUtil.checkUtil.budgetPlanItemService = this.budgetPlanItemService;
        CheckUtil.checkUtil.budgetPlanItemChangeService = this.budgetPlanItemChangeService;
        CheckUtil.checkUtil.budgetPlanService = this.budgetPlanService;
    }

    public static List<String> getAllMonth(String startMonth, String endMonth) {
        ArrayList<String> monthSets = new ArrayList<String>();
        monthSets.add(startMonth);
        while (!startMonth.equals(endMonth)) {
            Integer begin = Integer.parseInt(startMonth.substring(0, 4));
            Integer end = Integer.parseInt(startMonth.substring(5, 7));
            if (end == 12) {
                begin = begin + 1;
                end = 1;
            } else {
                end = end + 1;
            }
            startMonth = "" + begin + "-" + (end < 10 ? "0" + end : end);
            monthSets.add(startMonth);
        }
        return monthSets;
    }

    public static CommonResponse createPlanItem(Long planId, Long budgetId, String startMonth, String endMonth) {
        List<String> allMonth = CheckUtil.getAllMonth(startMonth, endMonth);
        QueryWrapper budgetDetailQueryWrapper = new QueryWrapper();
        budgetDetailQueryWrapper.eq((Object)"budget_id", (Object)budgetId);
        budgetDetailQueryWrapper.eq((Object)"level_no", (Object)3);
        List budgetDetailEntities = CheckUtil.checkUtil.budgetDetailService.list((Wrapper)budgetDetailQueryWrapper);
        HashSet details = new HashSet();
        budgetDetailEntities.forEach(item -> details.add(item.getId()));
        QueryWrapper budgetPlanItemQueryWrapper = new QueryWrapper();
        budgetPlanItemQueryWrapper.eq((Object)"plan_id", (Object)planId);
        budgetPlanItemQueryWrapper.eq((Object)"leaf_level", (Object)3);
        List budgetPlanItemEntities = CheckUtil.checkUtil.budgetPlanItemService.list((Wrapper)budgetPlanItemQueryWrapper);
        ArrayList newList = new ArrayList();
        HashMap level3Map = new HashMap();
        budgetPlanItemEntities.forEach(item -> level3Map.put(item.getDetailId(), item));
        details.forEach(item -> {
            if (null == level3Map.get(item)) {
                allMonth.forEach(month -> {
                    BudgetPlanItemEntity entity = new BudgetPlanItemEntity();
                    entity.setPlanId(planId);
                    entity.setDetailId((Long)item);
                    entity.setLeafFlag(1);
                    entity.setLeafLevel(3);
                    entity.setYyearMonth((String)month);
                    newList.add(entity);
                });
            }
        });
        if (newList.size() > 0) {
            CheckUtil.checkUtil.budgetPlanItemService.saveOrUpdateBatch(newList);
        }
        return CommonResponse.success();
    }

    public static List<String> CheckAllBuilding(int flag, Long planId, Long budgetId) {
        if (null == planId) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"budget_id", (Object)budgetId);
            List list = CheckUtil.checkUtil.budgetPlanService.list((Wrapper)queryWrapper);
            planId = ((BudgetPlanEntity)((Object)list.get(0))).getId();
        }
        ArrayList<String> budgetBuildingNos = new ArrayList<String>();
        ArrayList<String> planBuildingNos = new ArrayList<String>();
        QueryWrapper budgetDetailQueryWrapper = new QueryWrapper();
        budgetDetailQueryWrapper.eq((Object)"budget_id", (Object)budgetId);
        budgetDetailQueryWrapper.eq((Object)"level_no", (Object)1);
        List budgetDetailEntities = CheckUtil.checkUtil.budgetDetailService.list((Wrapper)budgetDetailQueryWrapper);
        for (BudgetDetailEntity entity : budgetDetailEntities) {
            budgetBuildingNos.add(entity.getBuildingNo());
        }
        HashSet<Long> detailIds = new HashSet<Long>();
        if (flag == 1) {
            QueryWrapper budgetPlanItemQueryWrapper = new QueryWrapper();
            budgetPlanItemQueryWrapper.eq((Object)"plan_id", (Object)planId);
            List budgetPlanItemEntities = CheckUtil.checkUtil.budgetPlanItemService.list((Wrapper)budgetPlanItemQueryWrapper);
            for (BaseEntity entity : budgetPlanItemEntities) {
                detailIds.add(entity.getDetailId());
            }
        } else if (flag == 2) {
            QueryWrapper budgetPlanItemChangeEntityQueryWrapper = new QueryWrapper();
            budgetPlanItemChangeEntityQueryWrapper.eq((Object)"dr", (Object)0);
            budgetPlanItemChangeEntityQueryWrapper.eq((Object)"plan_id", (Object)planId);
            List list = CheckUtil.checkUtil.budgetPlanItemChangeService.list((Wrapper)budgetPlanItemChangeEntityQueryWrapper);
            for (BaseEntity entity : list) {
                detailIds.add(entity.getDetailId());
            }
        }
        budgetDetailEntities.clear();
        if (detailIds.size() > 0) {
            budgetDetailQueryWrapper = new QueryWrapper();
            budgetDetailQueryWrapper.in((Object)"id", detailIds);
            budgetDetailEntities = CheckUtil.checkUtil.budgetDetailService.list((Wrapper)budgetDetailQueryWrapper);
        }
        detailIds.clear();
        for (BudgetDetailEntity entity : budgetDetailEntities) {
            detailIds.add(Long.valueOf(entity.getInnerCode().substring(0, 18)));
        }
        budgetDetailEntities.clear();
        if (detailIds.size() > 0) {
            budgetDetailQueryWrapper = new QueryWrapper();
            budgetDetailQueryWrapper.in((Object)"id", detailIds);
            budgetDetailEntities = CheckUtil.checkUtil.budgetDetailService.list((Wrapper)budgetDetailQueryWrapper);
        }
        for (BudgetDetailEntity entity : budgetDetailEntities) {
            planBuildingNos.add(entity.getBuildingNo());
        }
        budgetBuildingNos.removeAll(planBuildingNos);
        return budgetBuildingNos;
    }
}

