package com.ejianc.business.budget.service.impl;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.bean.BudgetRecordEntity;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetRecordService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
public class BudgetChangeThread implements Runnable{

    private Logger logger;

    private IBudgetChangeService budgetChangeService;

    private IBudgetService budgetService;

    private IBudgetDetailService budgetDetailService;

    private IBudgetRecordService recordService;

    private IBudgetPlanService service;

    private Long billId;

	public void setLogger(Logger logger) {
		this.logger = logger;
	}

	public void setBudgetChangeService(IBudgetChangeService budgetChangeService) {
		this.budgetChangeService = budgetChangeService;
	}

	public void setBudgetService(IBudgetService budgetService) {
		this.budgetService = budgetService;
	}

	public void setBudgetDetailService(IBudgetDetailService budgetDetailService) {
		this.budgetDetailService = budgetDetailService;
	}

	public void setRecordService(IBudgetRecordService recordService) {
		this.recordService = recordService;
	}

	public void setService(IBudgetPlanService service) {
		this.service = service;
	}

	public void setBillId(Long billId) {
        this.billId = billId;
    }

    @Override
    public void run() {
        doSomething();
    }

    public void doSomething(){
		logger.info("回调线程开始执行："+billId.toString());
        Date startDate = new Date();
		BudgetChangeEntity budgetChangeEntity = budgetChangeService.selectById(billId);
		LambdaUpdateWrapper<BudgetChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(BudgetChangeEntity::getUsedTime, new Date());
		updateWrapper.eq(BudgetChangeEntity::getId, budgetChangeEntity.getId());
		budgetChangeService.update(budgetChangeEntity, updateWrapper, false);
		/**更新变更的审批时间  end */

        /**复制合同表数据到记录表 begin */
		BudgetVO budgetVO = budgetService.queryDetail(budgetChangeEntity.getBudgetId(), false);
		Map<Long, Integer> contIdVersionMap =  new HashMap<>();
		BudgetRecordEntity recordEntity = BeanMapper.map(budgetVO, BudgetRecordEntity.class);
		recordEntity.setBudgetId(recordEntity.getId());
		recordEntity.setId(null);
		if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
			recordEntity.getDetailList().forEach(vo -> {
				contIdVersionMap.put(vo.getId(), vo.getVersion());
				vo.setBudgetDetailId(vo.getId());
				vo.setId(null);
			});
		}
		recordService.saveOrUpdate(recordEntity, false);
		/**复制合同表数据到记录表 end */

        /**更新变更表表头数据到合同 begin */
		BudgetEntity budgetEntity = BeanMapper.map(budgetVO, BudgetEntity.class);
		budgetEntity.setBillCode(budgetChangeEntity.getBillCode());
		budgetEntity.setMemo(budgetChangeEntity.getMemo());
		budgetEntity.setCostbudgetMny(budgetChangeEntity.getCostbudgetMny());
		budgetEntity.setIncomebudgetAdjustMny(budgetChangeEntity.getIncomebudgetAdjustMny());
		budgetEntity.setIncomebudgetMny(budgetChangeEntity.getIncomebudgetMny());
		budgetEntity.setLaborMny(budgetChangeEntity.getLaborMny());
		budgetEntity.setManageMny(budgetChangeEntity.getManageMny());
		budgetEntity.setManageRate(budgetChangeEntity.getManageRate());
		budgetEntity.setMaterialMny(budgetChangeEntity.getMaterialMny());
		budgetEntity.setMachineryMny(budgetChangeEntity.getMachineryMny());
		budgetEntity.setTaxRatio(budgetChangeEntity.getTaxRatio());
		budgetEntity.setTaxFee(budgetChangeEntity.getTaxFee());
		budgetEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
		budgetService.updateById(budgetEntity);
		/**复制合同表数据到记录表 end */

        /**复制合同子表数据到记录表 begin */
		BudgetEntity budgetEntity1 = BeanMapper.map(budgetChangeEntity, BudgetEntity.class);
		List<BudgetDetailEntity> budgetDetailEntities = budgetEntity1.getDetailList();
		if(CollectionUtils.isNotEmpty(budgetDetailEntities)){
			budgetDetailEntities.forEach(budgetDetailEntity -> {
				//记录虚拟父子关系
				budgetDetailEntity.setTid(budgetDetailEntity.getId().toString());
				budgetDetailEntity.setTpid(budgetDetailEntity.getParentId() != null && budgetDetailEntity.getParentId() > 0 ? budgetDetailEntity.getParentId().toString() : "");
				Long contractBid = budgetDetailEntity.getSrcBid();
				budgetDetailEntity.setBudgetId(budgetChangeEntity.getBudgetId());
				budgetDetailEntity.setSrcBid(budgetDetailEntity.getId());
				budgetDetailEntity.setId(contractBid);
				budgetDetailEntity.setVersion(contIdVersionMap.get(contractBid));
			});
			budgetDetailService.saveOrUpdateBatch(budgetDetailEntities, budgetDetailEntities.size(), false);

			//根据更新后数据维护树形关系
			Map<String,Long> idMap=new HashMap<>();
			budgetDetailEntities.forEach(cdEntity ->{
				idMap.put(cdEntity.getTid(),cdEntity.getId());
			});

			budgetDetailEntities.forEach(cdEntity ->{
				if(StringUtils.isNotEmpty(cdEntity.getTpid())){
					cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
				}
			});

			// 生成结构码、内码、逻辑内码
			List<Map> resultMapList = BeanMapper.mapList(budgetDetailEntities, Map.class);
			List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
			List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
			List<BudgetDetailEntity> saveEntities = new ArrayList<>();
			treeToList(ListCodeDate, saveEntities);
			budgetDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);

		}
		logger.info("开始执行回写计划操作");
		//预算变更回写 计划
		CommonResponse<RecalculateVO> recalculate = service.recalculate(RecalculateVO.intsance(null, budgetChangeEntity.getBudgetId()), 1);
		if(!recalculate.isSuccess()){
			logger.info("recalculate执行错误！"+recalculate.getMsg());
		}
		logger.info("开始执行创建新的计划明细操作");
		service.createNewPlanItem(budgetChangeEntity.getBudgetId());
		Date endDate = new Date();
		logger.info("预算变更提交后回调函数执行都已完成，耗时"+(endDate.getTime() - startDate.getTime()));
    }
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            // 生成内码
            if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"),  ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            }else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetDetailEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, BudgetDetailEntity.class));
        }
    }
}
