package com.ejianc.business.utils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 预算校验工具类
 * @date 2022/7/1
 */
public class BudgetCheckUtil {

    /**
     * @description: 校验权重是否为1
     * @date: 2022/7/1
     */
    public static void checkWeightScale(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            List<Map<String, Object>> child = (List) ypd.get("children");
            if (child != null) {
                checkWeightScale(child);
                if ((Integer) ypd.get("levelNo") == 3 && !"5".equals(ypd.get("changeType").toString()) && !"del".equals(ypd.get("rowState"))) {
                    BigDecimal total = BigDecimal.ZERO;
                    for (Map<String, Object> childMap : child) {
                        if (!"5".equals(childMap.get("changeType").toString()) && !"del".equals(childMap.get("rowState"))) {
                            total = ComputeUtil.safeAdd(total, ComputeUtil.toBigDecimal(childMap.get("materialWeightScale")));
                        }
                    }
                    if (total.compareTo(new BigDecimal(100)) != 0) {
                        throw new BusinessException("工艺【" + ypd.get("craft").toString() + "】下的工序权重和不为1");
                    }
                }
            }
        }
    }

}
