package com.ejianc.business.probuilddiary.person.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 个人施工日志
 * 
 * @author generator
 * 
 */
public class PersonVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态名称
    private Long informantId; // 填报人id
    private String informantName; // 填报人名称
    private String informantCode; // 填报人编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date informantDate; // 填报日期
    private Long commitUserId; // 提交人id
    private String logTemplate;//日志模板
    private String logTemplateName;//日志模板

    private String logTemplateCode;//日志模板
    private Long orgId; // 项目所属项目部ID
    private String orgCode; // 项目所属项目部编码
    private String orgName; // 项目所属项目部名称
    private Long parentOrgId; // 项目所属上级组织ID
    private String parentOrgCode; // 项目所属上级组织编码
    private String parentOrgName; // 项目所属上级组织名称


    private List<PersonDetailVO> detailList = new ArrayList<>(); // 个人日志-施工内容（施工员）
    private List<PersonScheduleVO> scheduleList = new ArrayList<>(); // 个人日志-进度情况（施工员）
    private List<PersonTypeVO> typeList = new ArrayList<>(); // 个人日志-施工组织设计、方案、交底、变更情况（技术负责人）
    private List<PersonQualityVO> qualityList = new ArrayList<>(); // 个人日志-工程质量检查、验收情况（质检员）
    private List<PersonSafetyVO> safetyList = new ArrayList<>(); // 个人日志-安全活动情况（安全员）
    private List<PersonMaterialVO> materialList = new ArrayList<>(); // 个人日志-材料进场情况
    private List<PersonEquipmentVO> equipmentList = new ArrayList<>(); // 个人日志-设备进场情况（设备管理员）
    private List<PersonExamineVO> examineList = new ArrayList<>(); // 个人日志-原材料检验、时间、试块及见证取样送检等情况（取样员）
    private List<PersonInformationVO> informationList = new ArrayList<>(); // 个人日志-工程资料归档及会议情况（资料员）
    private List<PersonOtherVO> otherList = new ArrayList<>(); // 个人日志-其他情况
    public String getLogTemplateCode() {
        return logTemplateCode;
    }

    public void setLogTemplateCode(String logTemplateCode) {
        this.logTemplateCode = logTemplateCode;
    }

    public String getLogTemplateName() {
        return logTemplateName;
    }

    public void setLogTemplateName(String logTemplateName) {
        this.logTemplateName = logTemplateName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getLogTemplate() {
        return logTemplate;
    }

    public void setLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
    }

    public List<PersonMaterialVO> getMaterialList() {
        return materialList;
    }

    public void setMaterialList(List<PersonMaterialVO> materialList) {
        this.materialList = materialList;
    }

    public Long getCommitUserId() {
        return commitUserId;
    }

    public void setCommitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Long getInformantId() {
        return informantId;
    }
    @ReferDeserialTransfer
    public void setInformantId(Long informantId) {
        this.informantId = informantId;
    }
    public String getInformantName() {
        return informantName;
    }

    public void setInformantName(String informantName) {
        this.informantName = informantName;
    }
    public String getInformantCode() {
        return informantCode;
    }

    public void setInformantCode(String informantCode) {
        this.informantCode = informantCode;
    }
    public Date getInformantDate() {
        return informantDate;
    }

    public void setInformantDate(Date informantDate) {
        this.informantDate = informantDate;
    }
    
     public List<PersonDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<PersonDetailVO> detailList) {
        this.detailList = detailList;
     }
     public List<PersonScheduleVO> getScheduleList() {
        return scheduleList;
     }

     public void setScheduleList(List<PersonScheduleVO> scheduleList) {
        this.scheduleList = scheduleList;
     }
     public List<PersonTypeVO> getTypeList() {
        return typeList;
     }

     public void setTypeList(List<PersonTypeVO> typeList) {
        this.typeList = typeList;
     }
     public List<PersonQualityVO> getQualityList() {
        return qualityList;
     }

     public void setQualityList(List<PersonQualityVO> qualityList) {
        this.qualityList = qualityList;
     }
     public List<PersonSafetyVO> getSafetyList() {
        return safetyList;
     }

     public void setSafetyList(List<PersonSafetyVO> safetyList) {
        this.safetyList = safetyList;
     }

     public List<PersonEquipmentVO> getEquipmentList() {
        return equipmentList;
     }

     public void setEquipmentList(List<PersonEquipmentVO> equipmentList) {
        this.equipmentList = equipmentList;
     }
     public List<PersonExamineVO> getExamineList() {
        return examineList;
     }

     public void setExamineList(List<PersonExamineVO> examineList) {
        this.examineList = examineList;
     }
     public List<PersonInformationVO> getInformationList() {
        return informationList;
     }

     public void setInformationList(List<PersonInformationVO> informationList) {
        this.informationList = informationList;
     }
     public List<PersonOtherVO> getOtherList() {
        return otherList;
     }

     public void setOtherList(List<PersonOtherVO> otherList) {
        this.otherList = otherList;
     }
}
