package com.ejianc.business.probuilddiary.project.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目日志
 *
 * @author baipengyan
 */
public class ProjectLogVO extends BaseVO {
	private static final long serialVersionUID = 814697079958557702L;

	private Date effectiveDate; // 生效日期
	private String billCode; // 单据编号
	private String billName; // 单据名称
	private Integer billState; // 单据状态
	private String billStateName; // 单据状态名称
	private Long orgId; // 项目部id
	private String orgCode; // 项目部编码
	private String orgName; // 项目部名称
	private Long parentOrgId; // 项目部所属组织id
	private String parentOrgCode; // 项目部所属组织编码
	private String parentOrgName; // 项目部所属组织名称
	private Long projectId; // 项目id
	private String projectCode; // 项目编码
	private String projectName; // 项目名称
	private String sourceType; // 来源
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date fillDate; // 填报日期
	private String week; // 星期
	private String weather; // 天气
	private String windPower; // 风力
	private String humidity; // 湿度
	private String airQuality; // 空气质量
	private Long commitUserId; // 提交人id
	private String commitUserCode; // 提交人账号
	private String commitUserName; // 提交人名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date commitDate; // 提交日期

	private List<ProjectLogDetailVO> projectLogDetailList = new ArrayList<>(); // 项目日志-施工内容（施工员）
	private List<ProjectLogScheduleVO> projectLogScheduleList = new ArrayList<>(); // 项目日志-进度情况（施工员）
	private List<ProjectLogTypeVO> projectLogTypeList = new ArrayList<>(); // 项目日志-施工组织设计、方案、交底、变更情况（技术负责人）
	private List<ProjectLogQualityVO> projectLogQualityList = new ArrayList<>(); // 项目日志-工程质量检查、验收情况（质检员）
	private List<ProjectLogSafetyVO> projectLogSafetyList = new ArrayList<>(); // 项目日志-安全活动情况（安全员）
	private List<ProjectLogMaterialVO> projectLogMaterialList = new ArrayList<>(); // 项目日志-材料进场情况（材料员）
	private List<ProjectLogEquipmentVO> projectLogEquipmentList = new ArrayList<>(); // 项目日志-设备进场情况（设备管理员）
	private List<ProjectLogExamineVO> projectLogExamineList = new ArrayList<>(); // 项目日志-原材料检验、时间、试块及见证取样送检等情况（取样员）
	private List<ProjectLogInformationVO> projectLogInformationList = new ArrayList<>(); // 项目日志-工程资料归档及会议情况（资料员）
	private List<ProjectLogOtherVO> projectLogOtherList = new ArrayList<>(); // 项目日志-其他情况

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getParentOrgId() {
		return parentOrgId;
	}

	public void setParentOrgId(Long parentOrgId) {
		this.parentOrgId = parentOrgId;
	}

	public String getParentOrgCode() {
		return parentOrgCode;
	}

	public void setParentOrgCode(String parentOrgCode) {
		this.parentOrgCode = parentOrgCode;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public Date getFillDate() {
		return fillDate;
	}

	public void setFillDate(Date fillDate) {
		this.fillDate = fillDate;
	}

	public String getWeek() {
		return week;
	}

	public void setWeek(String week) {
		this.week = week;
	}

	public String getWeather() {
		return weather;
	}

	public void setWeather(String weather) {
		this.weather = weather;
	}

	public String getWindPower() {
		return windPower;
	}

	public void setWindPower(String windPower) {
		this.windPower = windPower;
	}

	public String getHumidity() {
		return humidity;
	}

	public void setHumidity(String humidity) {
		this.humidity = humidity;
	}

	public String getAirQuality() {
		return airQuality;
	}

	public void setAirQuality(String airQuality) {
		this.airQuality = airQuality;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public List<ProjectLogDetailVO> getProjectLogDetailList() {
		return projectLogDetailList;
	}

	public void setProjectLogDetailList(List<ProjectLogDetailVO> projectLogDetailList) {
		this.projectLogDetailList = projectLogDetailList;
	}

	public List<ProjectLogScheduleVO> getProjectLogScheduleList() {
		return projectLogScheduleList;
	}

	public void setProjectLogScheduleList(List<ProjectLogScheduleVO> projectLogScheduleList) {
		this.projectLogScheduleList = projectLogScheduleList;
	}

	public List<ProjectLogTypeVO> getProjectLogTypeList() {
		return projectLogTypeList;
	}

	public void setProjectLogTypeList(List<ProjectLogTypeVO> projectLogTypeList) {
		this.projectLogTypeList = projectLogTypeList;
	}

	public List<ProjectLogQualityVO> getProjectLogQualityList() {
		return projectLogQualityList;
	}

	public void setProjectLogQualityList(List<ProjectLogQualityVO> projectLogQualityList) {
		this.projectLogQualityList = projectLogQualityList;
	}

	public List<ProjectLogSafetyVO> getProjectLogSafetyList() {
		return projectLogSafetyList;
	}

	public void setProjectLogSafetyList(List<ProjectLogSafetyVO> projectLogSafetyList) {
		this.projectLogSafetyList = projectLogSafetyList;
	}

	public List<ProjectLogMaterialVO> getProjectLogMaterialList() {
		return projectLogMaterialList;
	}

	public void setProjectLogMaterialList(List<ProjectLogMaterialVO> projectLogMaterialList) {
		this.projectLogMaterialList = projectLogMaterialList;
	}

	public List<ProjectLogEquipmentVO> getProjectLogEquipmentList() {
		return projectLogEquipmentList;
	}

	public void setProjectLogEquipmentList(List<ProjectLogEquipmentVO> projectLogEquipmentList) {
		this.projectLogEquipmentList = projectLogEquipmentList;
	}

	public List<ProjectLogExamineVO> getProjectLogExamineList() {
		return projectLogExamineList;
	}

	public void setProjectLogExamineList(List<ProjectLogExamineVO> projectLogExamineList) {
		this.projectLogExamineList = projectLogExamineList;
	}

	public List<ProjectLogInformationVO> getProjectLogInformationList() {
		return projectLogInformationList;
	}

	public void setProjectLogInformationList(List<ProjectLogInformationVO> projectLogInformationList) {
		this.projectLogInformationList = projectLogInformationList;
	}

	public List<ProjectLogOtherVO> getProjectLogOtherList() {
		return projectLogOtherList;
	}

	public void setProjectLogOtherList(List<ProjectLogOtherVO> projectLogOtherList) {
		this.projectLogOtherList = projectLogOtherList;
	}
}
