package com.ejianc.business.probuilddiary.project.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 项目日志-工程质量检查、验收情况（质检员）
 *
 * @author baipengyan
 */
public class ProjectLogQualityVO extends BaseVO {
	private static final long serialVersionUID = 3288674363383376580L;

	private Long personId; // 个人日志id
	private Long qualityId; // 质量活动id
	private String qualityName; // 质量活动名称
	private String qualityCode; // 质量活动编码
	private String qualityMemo; // 工作描述
	private Long commitUserId; // 提交人id
	private String commitUserCode; // 提交人账号
	private String commitUserName; // 提交人名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date commitDate; // 提交日期
	private Long projectLogId; // 项目日志id
	private String fileType; // 文件类型
	private Boolean updateFlag; // 更新状态
	private String logNumber; // 日志项编码
	private Boolean projectManagerFlag; // 项目经理标识
	private String templateContent; // 模版内容，#分隔开的字段名称，例如：commitUserName#commitDate#workMemo，输出：张三 16：00 完成1号楼基础部分基坑支护


	public Long getPersonId() {
		return personId;
	}

	public void setPersonId(Long personId) {
		this.personId = personId;
	}

	public Long getQualityId() {
		return qualityId;
	}

	@ReferDeserialTransfer
	public void setQualityId(Long qualityId) {
		this.qualityId = qualityId;
	}

	public String getQualityName() {
		return qualityName;
	}

	public void setQualityName(String qualityName) {
		this.qualityName = qualityName;
	}

	public String getQualityCode() {
		return qualityCode;
	}

	public void setQualityCode(String qualityCode) {
		this.qualityCode = qualityCode;
	}

	public String getQualityMemo() {
		return qualityMemo;
	}

	public void setQualityMemo(String qualityMemo) {
		this.qualityMemo = qualityMemo;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public Long getProjectLogId() {
		return projectLogId;
	}

	public void setProjectLogId(Long projectLogId) {
		this.projectLogId = projectLogId;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public Boolean getUpdateFlag() {
		return updateFlag;
	}

	public void setUpdateFlag(Boolean updateFlag) {
		this.updateFlag = updateFlag;
	}

	public String getLogNumber() {
		return logNumber;
	}

	public void setLogNumber(String logNumber) {
		this.logNumber = logNumber;
	}

	public Boolean getProjectManagerFlag() {
		return projectManagerFlag;
	}

	public void setProjectManagerFlag(Boolean projectManagerFlag) {
		this.projectManagerFlag = projectManagerFlag;
	}

	public String getTemplateContent() {
		return templateContent;
	}

	public void setTemplateContent(String templateContent) {
		this.templateContent = templateContent;
	}
}
