/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.ledger.service.impl;

import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ledger")
public class LedgerBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final ILedgerService service;

    public LedgerBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, ILedgerService service) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.service = service;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        LedgerEntity entity = (LedgerEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserId(userContext.getUserId());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        LedgerEntity entity = (LedgerEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }
}

