/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.person.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="person")
public class PersonBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IPersonService service;
    private final IProjectLogService projectLogService;

    public PersonBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, IPersonService service, IProjectLogService projectLogService) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.service = service;
        this.projectLogService = projectLogService;
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        PersonEntity entity = (PersonEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserId(userContext.getUserId());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03--end");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        PersonEntity entity = (PersonEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserId(userContext.getUserId());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.syncProjectLog(entity);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    private void syncProjectLog(PersonEntity entity) {
        boolean hasProjectLog = this.projectLogService.hasProjectLog(entity.getProjectId(), entity.getInformantDate());
        this.projectLogService.personLogConvertToProjectLog(entity, hasProjectLog);
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PersonEntity entity = (PersonEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5\uff1a{}\uff0c{}", (Object)res.isSuccess(), (Object)res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u9879\u76ee\u8fd8\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        if (Boolean.TRUE.equals(entity.getGatherFlag())) {
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(ProjectLogEntity::getProjectId, (Object)entity.getProjectId());
            lambdaQuery.eq(ProjectLogEntity::getFillDate, (Object)entity.getInformantDate());
            ProjectLogEntity projectLogEntity = (ProjectLogEntity)((Object)this.projectLogService.getOne((Wrapper)lambdaQuery));
            if (null == projectLogEntity) {
                return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
            }
            if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(projectLogEntity.getBillState()) || BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(projectLogEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(projectLogEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(projectLogEntity.getBillState())) {
                throw new BusinessException("\u5f53\u524d\u4e2a\u4eba\u65e5\u5fd7\u5df2\u6c47\u603b\u81f3\u9879\u76ee\u65e5\u5fd7\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
            }
        }
        this.projectLogService.deleteAllDataByPersonId(entity.getId(), entity.getProjectId(), entity.getInformantDate());
        entity.setGatherFlag(Boolean.FALSE);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }
}

