package com.ejianc.business.procost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 成本单据明细
 * 
 * @author generator
 * 
 */
@ApiModel("成本单据明细")
public class HandshareDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表Id")
    private Long handshareId;
    @ApiModelProperty("核算对象主键")
    private Long wbsId;
    @ApiModelProperty("核算对象编码")
    private String wbsCode;
    @ApiModelProperty("核算对象名称")
    private String wbsName;
    @ApiModelProperty("科目主键")
    private Long subjectId;
    @ApiModelProperty("科目编号")
    private String subjectCode;
    @ApiModelProperty("科目名称")
    private String subjectName;
    @ApiModelProperty("发生成本(含税)")
    private BigDecimal happenTaxMny;
    @ApiModelProperty("发生成本(不含税)")
    private BigDecimal happenMny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("创建人名称")
    private String createUserName;
    private Long subjectParentId; // 科目上级主键

    public Long getSubjectParentId() {
        return subjectParentId;
    }

    public void setSubjectParentId(Long subjectParentId) {
        this.subjectParentId = subjectParentId;
    }

    /**
     * 主表Id
     */
    public Long getHandshareId() {
        return handshareId;
    }

    /**
     * 主表Id
     */
    public void setHandshareId(Long handshareId) {
        this.handshareId = handshareId;
    }
    /**
     * 核算对象主键
     */
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    /**
     * 核算对象编码
     */
    public String getWbsCode() {
        return wbsCode;
    }

    /**
     * 核算对象编码
     */
    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    /**
     * 核算对象名称
     */
    public String getWbsName() {
        return wbsName;
    }

    /**
     * 核算对象名称
     */
    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 科目编号
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 科目编号
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 发生成本(含税)
     */
    public BigDecimal getHappenTaxMny() {
        return happenTaxMny;
    }

    /**
     * 发生成本(含税)
     */
    public void setHappenTaxMny(BigDecimal happenTaxMny) {
        this.happenTaxMny = happenTaxMny;
    }
    /**
     * 发生成本(不含税)
     */
    public BigDecimal getHappenMny() {
        return happenMny;
    }

    /**
     * 发生成本(不含税)
     */
    public void setHappenMny(BigDecimal happenMny) {
        this.happenMny = happenMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    
}
