package com.ejianc.business.procost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.procost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.procost.vo.UnitDetailVO;

/**
 * 主材量价对比主表
 * 
 * @author generator
 * 
 */
@ApiModel("主材量价对比主表")
public class UnitVO extends BaseVO implements ITreeNodeB{
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("成本科目名称")
    private String subjectName;
    @ApiModelProperty("成本科目编码")
    private String subjectCode;
    @ApiModelProperty("描述")
    private String memo;
    @ApiModelProperty("集团成本科目主键")
    private Long orgSubjectId;
    @ApiModelProperty("父id")
    private Long parentId;
    @ApiModelProperty("内置编码")
    private String innerCode;
    @ApiModelProperty("是否启用 1启用 0禁用")
    private Integer enabled;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;

    private String tid;
    private String tpid;

    @ApiModelProperty("主材量价对比子表")
    private List<UnitDetailVO> unitDetailList = new ArrayList<>();

    private List<ITreeNodeB> children; //子集数据

    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 成本科目编码
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 成本科目编码
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 描述
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 描述
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 集团成本科目主键
     */
    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    /**
     * 集团成本科目主键
     */
    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }
    /**
     * 父id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 内置编码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 内置编码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    /**
     * 是否启用 1启用 0禁用
     */
    public Integer getEnabled() {
        return enabled;
    }

    /**
     * 是否启用 1启用 0禁用
     */
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    /**
     * 计量单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 计量单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    
     /**
      * 主材量价对比子表
      */
      public List<UnitDetailVO> getUnitDetailList() {
         return unitDetailList;
      }
     /**
      * 主材量价对比子表
      */
     public void setUnitDetailList(List<UnitDetailVO> unitDetailList) {
         this.unitDetailList = unitDetailList;
     }


    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return getParentId();
    }
    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
}
