/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.SubjectEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.ISubjectService;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/procost/"})
public class CostDetailApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService costDetailService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;

    @RequestMapping(value={"saveCostDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostDetailVO> saveCostDetail(@RequestBody List<CostDetailVO> list) {
        try {
            if (CollectionUtils.isNotEmpty(list)) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(SettingEntity::getProjectId, (Object)list.get(0).getProjectId());
                lambda.in(SettingEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                List settingEntityList = this.settingService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)settingEntityList)) {
                    LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(SubjectEntity::getSettingId, (Object)((SettingEntity)((Object)settingEntityList.get(0))).getId());
                    List subjectEntityList = this.subjectService.list((Wrapper)lambda2);
                    Map<Long, List<SubjectEntity>> map = subjectEntityList.stream().collect(Collectors.groupingBy(BaseEntity::getId));
                    for (CostDetailVO e : list) {
                        if (map.containsKey(e.getSubjectId())) continue;
                        return CommonResponse.error((String)"\u63d2\u5165\u5931\u8d25,\u660e\u7ec6\u4e2d\u79d1\u76ee\u6709\u4e0d\u5b58\u5728\u6210\u672c\u8bbe\u7f6e\u4e2d\u7684\u6570\u636e!");
                    }
                } else {
                    return CommonResponse.error((String)"\u63d2\u5165\u5931\u8d25,\u672a\u627e\u5230\u8be5\u9879\u76ee\u6210\u672c\u8bbe\u7f6e\u4fe1\u606f");
                }
                List listres = BeanMapper.mapList(list, CostDetailEntity.class);
                this.costDetailService.deleteCostDetail(((CostDetailEntity)((Object)listres.get(0))).getSourceId());
                this.costDetailService.saveBatch(listres);
            }
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u63d2\u5165\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u63d2\u5165\u6210\u529f");
    }

    @RequestMapping(value={"deleteCostDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostDetailVO> deleteCostDetail(@RequestParam Long id) {
        try {
            this.costDetailService.deleteCostDetail(id);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

