/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.MonthVO;
import com.ejianc.business.procost.vo.ShareDetailVO;
import com.ejianc.business.procost.vo.ShareVO;
import com.ejianc.business.procost.vo.SubjectFlagVO;
import com.ejianc.business.procost.vo.SubjectReportVO;
import com.ejianc.business.procost.vo.TemplateDatas;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"share"})
public class ShareController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IShareService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ShareVO> saveOrUpdate(@RequestBody ShareVO saveorUpdateVO) {
        return this.service.saveOrUpdateShare(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ShareVO> queryDetail(Long id) {
        ShareEntity entity = (ShareEntity)((Object)this.service.selectById(id));
        ShareVO vo = (ShareVO)BeanMapper.map((Object)((Object)entity), ShareVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryShareDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ShareDetailVO>> queryCopyDetail(HttpServletRequest request, Long projectId, String endDay, String taxFlag, String billType, String materialCost) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.getDetail(projectId, endDay, taxFlag, billType, materialCost, 0, request));
    }

    @RequestMapping(value={"/querySubjectFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubjectFlagVO> querySubjectFlag(Long sourceId, String billType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.getSubkectFlag(sourceId, billType));
    }

    @RequestMapping(value={"/queryYears"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<String>> queryYears(Long id) {
        Calendar calendar3;
        ArrayList<Long> listids = new ArrayList<Long>();
        listids.add(id);
        Date signDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(signDate);
        calendar.add(1, -1);
        calendar.getTime();
        Date beforeDate = calendar.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date());
        calendar2.add(1, 1);
        Date endDate = calendar2.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        ArrayList<String> list = new ArrayList<String>();
        do {
            list.add(sdf.format(endDate));
            calendar3 = Calendar.getInstance();
            calendar3.setTime(endDate);
            calendar3.add(1, -1);
        } while (beforeDate.before(endDate = calendar3.getTime()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryMonths"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MonthVO>> queryMonths(Long id, String year) {
        String MaxMonth = "";
        Boolean flag = true;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(ShareEntity::getProjectId, (Object)id);
        lambda.in(ShareEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(ShareEntity::getPeriod);
        List listShares = this.service.list((Wrapper)lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)listShares)) {
            MaxMonth = ((ShareEntity)((Object)listShares.get(0))).getPeriod();
        } else {
            flag = false;
        }
        List<MonthVO> list = this.service.getMonths(id, year);
        HashMap map = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> map.put(e.getMonth(), e));
        }
        ArrayList<MonthVO> listMonth = new ArrayList<MonthVO>();
        for (int i = 1; i < 13; ++i) {
            MonthVO vo;
            if (i < 10) {
                vo = new MonthVO();
                vo.setMonth(year + "-0" + i);
                if (flag.booleanValue()) {
                    if (vo.getMonth().compareTo(MaxMonth) > 0) {
                        vo.setFlag(true);
                    } else {
                        vo.setFlag(false);
                    }
                } else {
                    vo.setFlag(true);
                }
                if (map.containsKey(vo.getMonth())) {
                    vo.setCostMny(((MonthVO)map.get(vo.getMonth())).getCostMny());
                    vo.setLatCostMny(((MonthVO)map.get(vo.getMonth())).getLatCostMny());
                    vo.setCostFlag(true);
                } else {
                    vo.setCostMny(BigDecimal.ZERO);
                    vo.setLatCostMny(BigDecimal.ZERO);
                    vo.setCostFlag(false);
                }
                listMonth.add(vo);
                continue;
            }
            vo = new MonthVO();
            vo.setMonth(year + "-" + i);
            if (flag.booleanValue()) {
                if (vo.getMonth().compareTo(MaxMonth) > 0) {
                    vo.setFlag(true);
                } else {
                    vo.setFlag(false);
                }
            } else {
                vo.setFlag(true);
            }
            if (flag.booleanValue() && map.containsKey(vo.getMonth())) {
                vo.setCostMny(((MonthVO)map.get(vo.getMonth())).getCostMny());
                vo.setLatCostMny(((MonthVO)map.get(vo.getMonth())).getLatCostMny());
                vo.setCostFlag(true);
            } else {
                vo.setCostMny(BigDecimal.ZERO);
                vo.setLatCostMny(BigDecimal.ZERO);
                vo.setCostFlag(false);
            }
            listMonth.add(vo);
        }
        String periodRule = "1";
        listMonth.forEach(e -> {
            if ("1".equals(periodRule)) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, Integer.parseInt(e.getMonth().substring(0, 4)));
                calendar.set(2, Integer.parseInt(e.getMonth().substring(5, 7)) - 1);
                e.setEndDay(this.getEndDay(calendar));
            } else {
                int endDay = 25;
                if (endDay < 10) {
                    e.setEndDay(e.getMonth() + "-0" + endDay);
                } else {
                    e.setEndDay(e.getMonth() + "-" + endDay);
                }
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", listMonth);
    }

    @RequestMapping(value={"/querySubjectReports"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubjectReportVO>> querySubjectReports(Long projectId, String period, int type) {
        List<SubjectReportVO> list = this.service.getSubjectReport(projectId, period, type);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)TreeNodeBUtil.buildTree(list));
    }

    @RequestMapping(value={"/querySubjectReportAlls"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<TemplateDatas>> querySubjectReportAlls(@RequestBody ShareVO vo) {
        List<TemplateDatas> list = this.service.getSubjectReportAlls(vo.getProjectId(), vo.getPeriods(), vo.getType());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)TreeNodeBUtil.buildTree(list));
    }

    @RequestMapping(value={"/queryProReports"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubjectReportVO> queryProReports(HttpServletRequest request, Long projectId) {
        SubjectReportVO res = this.service.queryProReports(request, projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    public String getEndDay(Calendar calendar) {
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        calendar.set(5, calendar.getActualMaximum(5));
        return sdf2.format(calendar.getTime());
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShareVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ShareVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("period");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShareVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"periodRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ShareVO>> orderDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("period");
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billStateList));
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            queryParam.getParams().put("projectId", new Parameter("eq", conditionMap.get("projectId")));
        }
        queryParam.getOrderMap().put("period", "asc");
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShareVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

