package com.ejianc.business.procost.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.bean.BillSettingEntity;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.service.IBillSettingService;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.vo.BillSettingVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 单据设置
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("billSetting")
public class BillSettingController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBillSettingService service;

    @Autowired
    private ISettingService settingService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillSettingVO> saveOrUpdate(@RequestBody BillSettingVO saveorUpdateVO) {
    	BillSettingEntity entity = BeanMapper.map(saveorUpdateVO, BillSettingEntity.class);
    	service.saveOrUpdate(entity, false);
    	BillSettingVO vo = BeanMapper.map(entity, BillSettingVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillSettingVO> queryDetail(Long id) {
    	BillSettingEntity entity = service.selectById(id);
    	BillSettingVO vo = BeanMapper.map(entity, BillSettingVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description
     * @param projectId
     */
    @RequestMapping(value = "/queryBillTypes", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BillSettingEntity>> queryBillTypes(Long projectId) {
        LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
        lambda.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
//        lambda.eq(SettingEntity::getProjectId,projectId);
//        lambda.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        SettingEntity settingEntity = settingService.getOne(lambda);

        LambdaQueryWrapper<BillSettingEntity> lambda2 = Wrappers.<BillSettingEntity>lambdaQuery();
        lambda2.eq(BillSettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.in(BillSettingEntity::getType,2,settingEntity.getMaterialCost());
        return CommonResponse.success("查询详情数据成功！",service.list(lambda2));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillSettingVO> vos) {
        service.removeByIds(vos.stream().map(BillSettingVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillSettingVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<BillSettingEntity> page = service.queryPage(param,false);
        IPage<BillSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillSettingVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
