package com.ejianc.business.procost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.BillSettingEntity;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.ShareDetailEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.mapper.ShareMapper;
import com.ejianc.business.procost.service.*;
import com.ejianc.business.procost.vo.*;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 成本分摊
 * 
 * @author generator
 * 
 */
@Service("shareService")
public class ShareServiceImpl extends BaseServiceImpl<ShareMapper, ShareEntity> implements IShareService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Autowired
    private IBillSettingService billSettingService;

    @Autowired
    private ISettingService settingService;

    @Autowired
    private IShareDetailService shareDetailService;

    @Autowired
    private ICostDetailService costDetailService;

    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;

    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    @Override
    public CommonResponse<ShareVO> saveOrUpdateShare(ShareVO saveorUpdateVO) {
        if(CollectionUtils.isEmpty(saveorUpdateVO.getShareDetail())){
            return CommonResponse.error("费用项明细不允许为空!");
        }
        LambdaQueryWrapper<ShareEntity> lambda2 = Wrappers.<ShareEntity>lambdaQuery();
        lambda2.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ShareEntity::getProjectId,saveorUpdateVO.getProjectId());
        if(null!=saveorUpdateVO.getId()){
            lambda2.ne(ShareEntity::getId,saveorUpdateVO.getId());
        }
        lambda2.notIn(ShareEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ShareEntity> list = super.list(lambda2);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("该项目已存在未生效单据,请先处理未生效单据！");
        }

        LambdaQueryWrapper<ShareEntity> lambda = Wrappers.<ShareEntity>lambdaQuery();
        lambda.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ShareEntity::getProjectId,saveorUpdateVO.getProjectId());
        lambda.eq(ShareEntity::getPeriod,saveorUpdateVO.getPeriod());
        if(null!=saveorUpdateVO.getId()){
            lambda.ne(ShareEntity::getId,saveorUpdateVO.getId());
        }
        List<ShareEntity> list2 = super.list(lambda);
        if(CollectionUtils.isNotEmpty(list2)){
            return CommonResponse.error("该项目的成本期间已存在,不允许重复新增");
        }


        LambdaQueryWrapper<ShareEntity> lambda3 = Wrappers.<ShareEntity>lambdaQuery();
        lambda3.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda3.eq(ShareEntity::getProjectId,saveorUpdateVO.getProjectId());
        if(null!=saveorUpdateVO.getId()){
            lambda3.ne(ShareEntity::getId,saveorUpdateVO.getId());
        }
        lambda3.gt(ShareEntity::getPeriod,saveorUpdateVO.getPeriod());
        lambda3.orderByDesc(ShareEntity::getPeriod);
        List<ShareEntity> list3 = super.list(lambda3);
        if(CollectionUtils.isNotEmpty(list3)){
            return CommonResponse.error("不允许早于最大成本期间,该项目的最大成本期间为【"+list3.get(0).getPeriod()+"】");
        }
        ShareEntity entity = BeanMapper.map(saveorUpdateVO, ShareEntity.class);
        if(null!=entity.getId()){
            LambdaQueryWrapper<ShareDetailEntity> lambdaDetail = Wrappers.<ShareDetailEntity>lambdaQuery();
            lambdaDetail.eq(ShareDetailEntity::getTenantId,InvocationInfoProxy.getTenantid());
            lambdaDetail.eq(ShareDetailEntity::getShareId,entity.getId());
            //修改需要先情况所有子表
            shareDetailService.remove(lambdaDetail);
            List<ShareDetailEntity> shareDetailEntities = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(entity.getShareDetail())){
                entity.getShareDetail().forEach(e->{
                    if(!"del".equals(e.getRowState())){
                        e.setId(null);
                        shareDetailEntities.add(e);
                    }
                });
                entity.setShareDetail(shareDetailEntities);
            }
        }
        super.saveOrUpdate(entity, false);
        ShareVO vo = BeanMapper.map(entity, ShareVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<MonthVO> getMonths(Long projectId, String year) {
        return baseMapper.geMonths(projectId,year);
    }

    @Override
    public List<SubjectReportVO> getSubjectReport(Long projectId, String period, int type,Long wbsId) {
        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.shareSubjectOrgApi();
        if(!resDate.isSuccess()) {
            throw new BusinessException("查询科目信息失败!");
        }
        List<Long> wbsIdList = new ArrayList<>();
        if(wbsId!=null){
            CommonResponse<List<ProjectWbsVO>> commonResponse = shareProjectWbsApi.queryProjectWbsList(wbsId);
            if(!commonResponse.isSuccess()) {
                throw new BusinessException("查询核算对象信息失败!");
            }
            List<ProjectWbsVO> projectWbsVOList = commonResponse.getData();
            wbsIdList = projectWbsVOList.stream().map(ProjectWbsVO::getId).collect(Collectors.toList());
        }
        List<SubjectReportsVO> list = baseMapper.getSubjectReport(projectId,period,0,wbsIdList);
        List<SubjectReportsVO> listsum = baseMapper.getSubjectReport(projectId,period,1,wbsIdList);
        Map<Long,BigDecimal> map = new HashMap<>();
        Map<Long,SubjectReportsVO> mapList = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listsum)){
            listsum.forEach(e->{
                map.put(e.getId(),e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
            });
        }
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                mapList.put(e.getSubjectId(),e);
                if(map.containsKey(e.getId())){
                    e.setHappenMnySum(map.get(e.getId()));
                }
            });
        }

        List<SubjectOrgVO> subjectOrgVOList = resDate.getData();
        List<SubjectReportsVO> allList = new ArrayList<>();
        for(int i=0;i<subjectOrgVOList.size();i++){
            SubjectOrgVO subjectOrgVO = subjectOrgVOList.get(i);
            SubjectReportsVO vo = new SubjectReportsVO();
            vo.setId(subjectOrgVO.getId());
            vo.setNumber(i+1);
            vo.setSubjectId(subjectOrgVO.getId());
            vo.setSubjectCode(subjectOrgVO.getSubjectCode());
            vo.setSubjectName(subjectOrgVO.getSubjectName());
            vo.setParentId(subjectOrgVO.getParentId());
            SubjectReportsVO subjectReportsVO = mapList.get(subjectOrgVO.getId());
            if(null!=subjectReportsVO){
                vo.setHappenDate(subjectReportsVO.getHappenDate());
                vo.setHappenMny(subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny());
                vo.setHappenMnySum(subjectReportsVO.getHappenMnySum()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnySum());
            }else{
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }


        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(999L);
        tempVo.setNumber(0);
        tempVo.setParentId(000L);
        allList.add(tempVo);
        List<SubjectReportsVO> listres = new ArrayList<>();
        SubjectReportsVO vo =   calculateValue(allList);
        printGoal(vo,listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        if(0==type){
            listres.remove(0);
            return BeanMapper.mapList(listres,SubjectReportVO.class);
        }else{
            List<SubjectReportVO> lists = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(listres)){
                listres.forEach(e->{
                    if(000L!=e.getParentId()&&BigDecimal.ZERO.compareTo(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny())!=0){
                        lists.add(BeanMapper.map(e,SubjectReportVO.class));
                    }
                });
            }
            return lists;
        }
    }


    /*
        二维表树形思路
        1，取成本发生的有效数据，分组出期间(列信息)
        2，取科目树(行信息)
        3，循环科目树，期间，有效数据，合成map<科目主键+期间 组合主键，List<本期成本金额,含本期累计>>
        4，根据科目树增加列信息，根据行+列找map 对应的数据
     */
    @Override
    public List<TemplateDatas> getSubjectReportAlls(Long projectId, List<String> periods, int type) {
        //查询审批通过的成本分摊对应发生的金额
        List<SubjectReportsVO> costDetailList = baseMapper.getCostDetails(projectId);

        //科目树
        List<SubjectReportVO> costSetting = baseMapper.getCostSetting(projectId);

        Set<String> period = new HashSet<>();
        List<String> fields = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(costDetailList)){
            costDetailList.forEach(e->{
                if(StringUtils.isNotEmpty(e.getPeriod())){
                    period.add(e.getPeriod());
                }
            });
            List<String> periodList = new ArrayList<>(period);
            if(CollectionUtils.isNotEmpty(period)){
                for(int i=0;i<periodList.size();i++){
                    fields.add(periodList.get(i));
                }
                Collections.sort(fields);
            }
        }
        //map<科目主键+期间 组合主键，List<本期成本金额,含本期累计>>
        Map<String,List<BigDecimal>> maps = new HashMap<>();
        if(CollectionUtils.isNotEmpty(costSetting)) {
            for(int i=0;i<costSetting.size();i++){
                Long subjectId = costSetting.get(i).getId();
                for(int k=0;k<fields.size();k++){
                    String nowPeriod = fields.get(k)==null?"":fields.get(k);
                    BigDecimal happenMnySum = BigDecimal.ZERO;//当前期间合计
                    BigDecimal happenMnySums = BigDecimal.ZERO;//不含当期间累计
                    for(int n=0;n<costDetailList.size();n++){
                        String dateString = costDetailList.get(n).getPeriod();
                        if(subjectId.equals(costDetailList.get(n).getSubjectId())&&nowPeriod.compareTo(dateString)>0){
                            BigDecimal happenMny= costDetailList.get(n).getHappenMny()==null?BigDecimal.ZERO:costDetailList.get(n).getHappenMny();
                            happenMnySums = happenMnySums.add(happenMny);
                        }else if(subjectId.equals(costDetailList.get(n).getSubjectId())&&nowPeriod.compareTo(dateString)==0){
                            BigDecimal happenMny= costDetailList.get(n).getHappenMny()==null?BigDecimal.ZERO:costDetailList.get(n).getHappenMny();
                            happenMnySum = happenMnySum.add(happenMny);
                        }
                    }
                    List<BigDecimal> listnew = new ArrayList<>();
                    listnew.add(happenMnySum);
                    listnew.add(happenMnySum.add(happenMnySums));
                    maps.put(subjectId+nowPeriod,listnew);
                }
            }
        }

        //循环科目树
        List<TemplateDatas> listRes = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(costSetting)) {
            for(int i=0;i<costSetting.size();i++){
                SubjectReportVO e = costSetting.get(i);
                TemplateDatas td = TemplateDatas.New();
                td = BeanMapper.map(e,TemplateDatas.class);
                BigDecimal periodMnys = BigDecimal.ZERO;
                if(CollectionUtils.isNotEmpty(periods)){
                    //说明前端传回个别期间，需按照前端传的显示
                    for(String key:periods){
                        td.addField(key,key);
                        td.addField(key+"-Sum","含本期累计");
                        if(maps.containsKey(e.getId()+key)){
                            td.add(key,maps.get(e.getId()+key).get(0));
                            periodMnys = periodMnys.add(maps.get(e.getId()+key).get(0));
                            td.add(key+"-Sum",maps.get(e.getId()+key).get(1));
                        }else{
                            td.add(key,BigDecimal.ZERO);
                            td.add(key+"-Sum",BigDecimal.ZERO);
                        }
                    }
                }else{
                    //说明前端没传期间，需按照所有的显示
                    for(String key:fields){
                        td.addField(key,key);
                        td.addField(key+"-Sum","含本期累计");
                        if(maps.containsKey(e.getId()+key)){
                            td.add(key,maps.get(e.getId()+key).get(0));
                            periodMnys = periodMnys.add(maps.get(e.getId()+key).get(0));
                            td.add(key+"-Sum",maps.get(e.getId()+key).get(1));
                        }else{
                            td.add(key,BigDecimal.ZERO);
                            td.add(key+"-Sum",BigDecimal.ZERO);
                        }
                    }
                }

                td.setNumber(i+1);
                td.setPeriodMnys(periodMnys);
                listRes.add(td);
            }
        }
        return listRes;
    }

    @Override
    public SubjectReportVO queryProReports(HttpServletRequest request,Long projectId) {
        LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
        lambda.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
//        lambda.eq(SettingEntity::getProjectId,projectId);
//        lambda.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettingEntity> shareEntityList = settingService.list(lambda);

        SubjectReportVO resVo = new SubjectReportVO();
        LambdaQueryWrapper<ShareEntity> lambda2 = Wrappers.<ShareEntity>lambdaQuery();
        lambda2.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ShareEntity::getProjectId,projectId);
        lambda2.in(ShareEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ShareEntity> list = super.list(lambda2);
        BigDecimal happenMny = list.stream().map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO,BigDecimal::add);
        resVo.setHappenMny(happenMny);//项目已分摊成本
        if(CollectionUtils.isNotEmpty(shareEntityList)){
            List<ShareDetailVO> listDetail = getDetail(projectId,"",shareEntityList.get(0).getTaxFlag(),null,shareEntityList.get(0).getMaterialCost(),1,request);
            BigDecimal sum = listDetail.stream().map(ShareDetailVO::getHappenMny).reduce(BigDecimal.ZERO,BigDecimal::add);
            resVo.setHappenMnySum(sum);
        }
        return resVo;
    }


    @Override
    public List<ShareDetailVO> getDetail(Long projectId, String endDay, String taxFlag,String billType,String materialCost,int type, HttpServletRequest request) {
        //type 0 -成本节点使用     type= 1  报表使用
        List<BillSettingEntity> list = new ArrayList<>();
        List<ShareDetailVO> listRes = new ArrayList<>();
        if(null!=billType&&!"".equals(billType)){
            LambdaQueryWrapper<BillSettingEntity> lambda = Wrappers.<BillSettingEntity>lambdaQuery();
            lambda.eq(BillSettingEntity::getBillTypeCode,billType);
            lambda.ne(BillSettingEntity::getType,9);
            list = billSettingService.list(lambda);
        }else{
            LambdaQueryWrapper<BillSettingEntity> lambda = Wrappers.<BillSettingEntity>lambdaQuery();
            lambda.in(BillSettingEntity::getType,2);
            list = billSettingService.list(lambda);
        }
        String authority = request.getHeader("authority");
        //创建一个固定数量的线程池
        ExecutorService threadPool = Executors.newFixedThreadPool(list.size());
        List<Future<JSONObject>> callables = new ArrayList<>();
        for(BillSettingEntity entity:list ){
            String condition = "";
            if(null!=endDay&&!"".equals(endDay)){
                condition = entity.getConditions().replace("projectId","'"+projectId+"'").replace("endDate","'"+endDay+"'");
            }else if(type==1){
                condition = entity.getConditions().replace("projectId","'"+projectId+"'");
                String endDate = condition.substring(condition.lastIndexOf("and proportion_flag != 1"),condition.lastIndexOf("order")-1);
                condition = condition.replace(endDate,"");
            }else {
                condition = entity.getConditions().replace("projectId","'"+projectId+"'");
                String endDate = condition.substring(condition.lastIndexOf("and"),condition.lastIndexOf("order")-1);
                condition = condition.replace(endDate,"");
            }

            Callable<JSONObject> shareDetailCallable = new ShareServiceImpl.BillDetailCallable(RequestContextHolder.getRequestAttributes(),entity.getBillTypeCode(),entity.getParameter(),condition,authority,taxFlag,entity.getPath());
            Future<JSONObject> shareDetailFuture = threadPool.submit(shareDetailCallable);
            callables.add(shareDetailFuture);
        }

        for(Future<JSONObject> callable:callables){
            try {
                JSONObject json = callable.get();
                if(null!=json){
                    listRes.addAll((List<ShareDetailVO>)json.get("jsonRes"));
                }
            } catch (Exception e) {
                logger.error("获取单据信息异常：", e);
            } finally {
                threadPool.shutdown();
            }
        }
        return listRes;
    }

    @Override
    public SubjectFlagVO getSubkectFlag(Long sourceId, String billType) {
        BillSettingEntity billSettingEntity = new BillSettingEntity();
        LambdaQueryWrapper<BillSettingEntity> lambda = Wrappers.<BillSettingEntity>lambdaQuery();
        lambda.eq(BillSettingEntity::getType,9);
        billSettingEntity = billSettingService.getOne(lambda);
        List<Map<String, Object>> list = commenQueryFieldsService.queryBillList(billType,billSettingEntity.getParameter(),billSettingEntity.getConditions().replace("billId","'"+sourceId+"'"));
        SubjectFlagVO newsVos = null;
        if(CollectionUtils.isNotEmpty(list)){
            newsVos = BeanMapper.map(list.get(0), SubjectFlagVO.class);
        }
        return newsVos;
    }

    class BillDetailCallable implements Callable<JSONObject> {

        private RequestAttributes context;
        private String billTypeCode;
        private String parameter;
        private String condition;
        private String authority;
        private String taxFlag;
        private String path;

        public BillDetailCallable(RequestAttributes context,String billTypeCode, String parameter, String condition, String authority,String taxFlag,String path) {
            this.context = context;
            this.billTypeCode = billTypeCode;
            this.parameter = parameter;
            this.condition = condition;
            this.authority = authority;
            this.taxFlag = taxFlag;
            this.path = path;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject jsonObject = new JSONObject();
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);
            List<Map<String, Object>> list = commenQueryFieldsService.queryBillList(billTypeCode,parameter,condition);
            List<ShareDetailVO> newsVos = null;
            if(CollectionUtils.isNotEmpty(list)){
                newsVos = BeanMapper.mapList(list, ShareDetailVO.class);
                newsVos.forEach(e->{
                    e.setBillType(billTypeCode);
                    if("0".equals(taxFlag)){
                        e.setHappenMny(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                    }
                    e.setRowState("add");
                    e.setId(e.getSourceId());
                    e.setPath(path);
                });
            }
            jsonObject.put("jsonRes", newsVos);
            return jsonObject;
        }
    }

    //找到最底层的叶子节点
    public List<SubjectReportsVO> getBottomNode(List<SubjectReportsVO> listGoal) {
        Map<Long, SubjectReportsVO> map = new HashMap<Long, SubjectReportsVO>();
        for (SubjectReportsVO g : listGoal) {
            map.put(g.getId(), g);
        }

        for (SubjectReportsVO g : listGoal) {
            Long pid = g.getParentId();
            if (map.containsKey(pid)) {
                map.remove(pid);
            }
        }
        return new ArrayList<SubjectReportsVO>(map.values());
    }

    public List<SubjectReportsVO> setParentValue(List<SubjectReportsVO> listAllGoal, List<SubjectReportsVO> listBottomGoal) {

        Map<Long, List<SubjectReportsVO>> map = new HashMap<Long, List<SubjectReportsVO>>();
        for (SubjectReportsVO g : listBottomGoal) {
            Long pid = g.getParentId();
            List<SubjectReportsVO> listGoal = map.get(pid);
            if (listGoal == null) {
                listGoal = new ArrayList<SubjectReportsVO>();
            }
            listGoal.add(g);
            map.put(pid, listGoal);
        }

        for (Long i : map.keySet()) {
            List<SubjectReportsVO> tempListGoal = map.get(i);
            BigDecimal result = BigDecimal.ZERO;
            BigDecimal result2 = BigDecimal.ZERO;
            for (SubjectReportsVO g : tempListGoal) {
                result = result.add(g.getHappenMny()==null?BigDecimal.ZERO:g.getHappenMny());
                result2 = result2.add(g.getHappenMnySum()==null?BigDecimal.ZERO:g.getHappenMnySum());
            }
            for (SubjectReportsVO g : listAllGoal) {
                Long id = g.getId();
                if (id.longValue() == i.longValue()) {
                    List<SubjectReportsVO> tempList = g.getChildren();
                    if (tempList != null) {
                        tempListGoal.addAll(tempList);
                    }
                    g.setChildren(tempListGoal);
                    BigDecimal score = g.getHappenMny()==null?BigDecimal.ZERO:g.getHappenMny();
                    BigDecimal score2 = g.getHappenMnySum()==null?BigDecimal.ZERO:g.getHappenMnySum();
                    score = score.add(result);
                    score2 = score2.add(result2);
                    g.setHappenMny(score);
                    g.setHappenMnySum(score2);
                }
            }
        }

        for (SubjectReportsVO g : listBottomGoal) {
            listAllGoal.remove(g);
        }

        return listAllGoal;
    }

    public SubjectReportsVO calculateValue(List<SubjectReportsVO> listGoal) {
        if (listGoal.size() == 1) {
            return listGoal.get(0);
        } else {
            List<SubjectReportsVO> listBottomGoal = getBottomNode(listGoal);
            List<SubjectReportsVO> list = setParentValue(listGoal, listBottomGoal);
            return calculateValue(list);
        }
    }


    public void printGoal(SubjectReportsVO goal,List<SubjectReportsVO> list) {
        list.add(goal);
        List<SubjectReportsVO> listGoal = goal.getChildren();
        if (listGoal == null || listGoal.size() == 0) {
            return;
        }
        for (SubjectReportsVO g : listGoal) {
            printGoal(g,list);
        }
    }



}
