/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMJJFApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.service.IHandshareService;
import com.ejianc.business.procost.vo.HandshareVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"handshare"})
@Api(value="\u6210\u672c\u5355\u636e", tags={"\u6210\u672c\u5355\u636e"})
public class HandshareController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecutionApi executionApi;
    private static final String BILL_CODE = "HAND_SHARE";
    @Autowired
    private IHandshareService service;
    @Autowired
    private IPMJJFApi pmjjfApi;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HandshareVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody HandshareVO saveOrUpdateVO) {
        String period;
        PMJJFVO jjfVo;
        HandshareEntity entity = (HandshareEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, HandshareEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        HandshareEntity dbentity = null;
        if (null != saveOrUpdateVO.getId() && "1".equals(entity.getCwFlag())) {
            dbentity = (HandshareEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        }
        this.service.saveOrUpdate((Object)entity, false);
        if ((saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) && "1".equals(entity.getCwFlag())) {
            jjfVo = (PMJJFVO)BeanMapper.map((Object)((Object)entity), PMJJFVO.class);
            period = jjfVo.getPeriod();
            jjfVo.setPeriod(period.replace("-", ""));
            this.logger.info("\u8c03\u7528\u8d39\u7528\u671f\u95f4\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)jjfVo));
            this.pmjjfApi.updateFlag(jjfVo);
        }
        if (null != saveOrUpdateVO.getId() && "1".equals(entity.getCwFlag()) && !"1".equals(dbentity.getCwFlag())) {
            jjfVo = (PMJJFVO)BeanMapper.map((Object)((Object)entity), PMJJFVO.class);
            period = jjfVo.getPeriod();
            jjfVo.setPeriod(period.replace("-", ""));
            this.logger.info("\u8c03\u7528\u8d39\u7528\u671f\u95f4\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)jjfVo));
            this.pmjjfApi.updateFlag(jjfVo);
        }
        HandshareVO vo = (HandshareVO)BeanMapper.map((Object)((Object)entity), HandshareVO.class);
        ExecutionVO executionVO = this.service.targetCost(vo);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<HandshareVO> queryDetail(@RequestParam Long id) {
        HandshareEntity entity = (HandshareEntity)((Object)this.service.selectById(id));
        HandshareVO vo = (HandshareVO)BeanMapper.map((Object)((Object)entity), HandshareVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<HandshareVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (HandshareVO vo : vos) {
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                HandshareEntity entity = (HandshareEntity)((Object)this.service.selectById(vo.getId()));
                ExecutionVO executionVO = this.service.targetCost((HandshareVO)BeanMapper.map((Object)((Object)entity), HandshareVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
                if (!"1".equals(entity.getCwFlag())) continue;
                PMJJFVO jjfVo = (PMJJFVO)BeanMapper.map((Object)((Object)entity), PMJJFVO.class);
                String period = jjfVo.getPeriod();
                jjfVo.setPeriod(period.replace("-", ""));
                jjfVo.setCwFlag("0");
                this.logger.info("\u8c03\u7528\u8d39\u7528\u671f\u95f4\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)jjfVo));
                this.pmjjfApi.updateFlag(jjfVo);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<HandshareVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("period");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), HandshareVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Handshare-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refHandshareData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<HandshareVO>> refHandshareData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), HandshareVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

