package com.ejianc.business.procost.service.impl;

import com.ejianc.business.procost.vo.HandshareDetailVO;
import com.ejianc.business.procost.vo.HandshareVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.procost.mapper.HandshareMapper;
import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.service.IHandshareService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 成本单据
 *
 * @author generator
 */
@Service("handshareService")
public class HandshareServiceImpl extends BaseServiceImpl<HandshareMapper, HandshareEntity> implements IHandshareService {

    private static final String BillType = "EJCBT202205000032";//此处需要根据实际修改

    private static final String linkUrl = "/ejc-procost-frontend/#/handshare/card?id=";//此处需要根据实际修改

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Override
    public ExecutionVO targetCost(HandshareVO vo) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(vo.getId());
        totalVO.setTenantId(vo.getTenantId());
        totalVO.setBillCode(vo.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.财务取数成本.getCode());
        totalVO.setBillCategory(BillCategoryEnum.其他.getCode());
        totalVO.setProjectId(vo.getProjectId());
        totalVO.setOrgId(vo.getOrgId());
        totalVO.setMoney(vo.getCostTaxMny());
        totalVO.setTaxMoney(vo.getCostTaxMny());
        totalVO.setLinkUrl(BaseHost + linkUrl + vo.getId());
        for (HandshareDetailVO planDetailVO : vo.getHandshareDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(vo.getId());
            detailExecutionVO.setDocType(DocTypeEnum.成本科目.getCode());
            detailExecutionVO.setDocId(planDetailVO.getSubjectId());
            detailExecutionVO.setName(planDetailVO.getSubjectName());
            detailExecutionVO.setCode(planDetailVO.getSubjectCode());
            detailExecutionVO.setCategoryId(planDetailVO.getSubjectParentId());
            detailExecutionVO.setMoney(planDetailVO.getHappenMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getHappenTaxMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}
