/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller.desktop;

import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.ThreeReportVO;
import com.ejianc.business.procost.vo.desktop.DesktopThreeReportVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"procostDesktop"})
public class ProcostDesktopController
implements Serializable {
    @Autowired
    private IShareService shareService;
    @Autowired
    IProjectPoolApi projectPoolApi;

    @RequestMapping(value={"/queryThreeReport"}, method={RequestMethod.GET})
    public CommonResponse<DesktopThreeReportVO> queryThreeReport(@RequestParam(value="orgId") Long orgId) {
        CommonResponse listCommonResponse = this.projectPoolApi.queryProjectListByProjectDepartmentId(orgId);
        if (!listCommonResponse.isSuccess() && CollectionUtils.isEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u4e0b\u9762\u7684\u9879\u76ee\u4fe1\u606f\uff01");
        }
        List data = (List)listCommonResponse.getData();
        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)data.get(0);
        String endPeriod = DateFormatUtil.formatDate((String)"yyyy-MM", (Date)new Date());
        List<ThreeReportVO> list = this.shareService.getThreeReports(projectPoolSetVO.getId(), endPeriod);
        DesktopThreeReportVO resObj = new DesktopThreeReportVO();
        List incomeBudget = resObj.getIncomeBudget();
        List targetCost = resObj.getTargetCost();
        List realCost = resObj.getRealCost();
        List incomeTargetRate = resObj.getIncomeTargetRate();
        List targetRealRate = resObj.getTargetRealRate();
        List incomeRealRate = resObj.getIncomeRealRate();
        if (CollectionUtils.isNotEmpty(list)) {
            List threeReportVOS = TreeNodeBUtil.buildTree(list);
            for (ThreeReportVO threeReportVO : threeReportVOS) {
                int index = 0;
                index = "01".equals(threeReportVO.getSubjectCode()) ? 0 : ("03".equals(threeReportVO.getSubjectCode()) ? 1 : ("02".equals(threeReportVO.getSubjectCode()) ? 2 : ("04".equals(threeReportVO.getSubjectCode()) ? 3 : 4)));
                incomeBudget.set(index, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)incomeBudget.get(index)), (BigDecimal)threeReportVO.getYsHappenMny()));
                targetCost.set(index, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)targetCost.get(index)), (BigDecimal)threeReportVO.getCbHappenMny()));
                realCost.set(index, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)realCost.get(index)), (BigDecimal)threeReportVO.getHappenMny()));
                incomeTargetRate.set(index, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)incomeTargetRate.get(index)), (BigDecimal)threeReportVO.getSrmbRate()));
                targetRealRate.set(index, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)targetRealRate.get(index)), (BigDecimal)threeReportVO.getMbsjRate()));
                incomeRealRate.set(index, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)incomeRealRate.get(index)), (BigDecimal)threeReportVO.getSrsjRate()));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resObj);
    }

    public static void main(String[] args) {
        String endPeriod = DateFormatUtil.formatDate((String)"yyyy-MM", (Date)new Date());
        System.out.println(endPeriod);
    }
}

