/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.api.IProincomeBudgetApi;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.procost.bean.BillSettingEntity;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.ShareDetailEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.mapper.ShareMapper;
import com.ejianc.business.procost.service.IBillSettingService;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.util.DateUtil;
import com.ejianc.business.procost.vo.MonthVO;
import com.ejianc.business.procost.vo.ShareDetailVO;
import com.ejianc.business.procost.vo.ShareVO;
import com.ejianc.business.procost.vo.SqlParam;
import com.ejianc.business.procost.vo.SubjectFlagVO;
import com.ejianc.business.procost.vo.SubjectReportVO;
import com.ejianc.business.procost.vo.SubjectReportsVO;
import com.ejianc.business.procost.vo.TemplateDatas;
import com.ejianc.business.procost.vo.ThreeReportVO;
import com.ejianc.business.targetcost.api.ITargetCostFinishApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="shareService")
public class ShareServiceImpl
extends BaseServiceImpl<ShareMapper, ShareEntity>
implements IShareService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillSettingService billSettingService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareDetailService shareDetailService;
    @Autowired
    private IProincomeBudgetApi budgetApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;
    @Autowired
    private ITargetCostFinishApi targetCostFinishApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;
    @Value(value="${procost.costSubjectId}")
    private String costSubjectId;

    @Override
    public CommonResponse<ShareVO> saveOrUpdateShare(ShareVO saveorUpdateVO) {
        List list2;
        if (CollectionUtils.isEmpty((Collection)saveorUpdateVO.getShareDetail())) {
            return CommonResponse.error((String)"\u8d39\u7528\u9879\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda2.eq(ShareEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
        if (null != saveorUpdateVO.getId()) {
            lambda2.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        lambda2.notIn(ShareEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambda2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u8bf7\u5148\u5904\u7406\u672a\u751f\u6548\u5355\u636e\uff01");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(ShareEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
        lambda.eq(ShareEntity::getPeriod, (Object)saveorUpdateVO.getPeriod());
        if (null != saveorUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list2 = super.list((Wrapper)lambda)))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u7684\u6210\u672c\u671f\u95f4\u5df2\u5b58\u5728,\u4e0d\u5141\u8bb8\u91cd\u590d\u65b0\u589e");
        }
        LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
        lambda3.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda3.eq(ShareEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
        if (null != saveorUpdateVO.getId()) {
            lambda3.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        lambda3.gt(ShareEntity::getPeriod, (Object)saveorUpdateVO.getPeriod());
        lambda3.orderByDesc(ShareEntity::getPeriod);
        List list3 = super.list((Wrapper)lambda3);
        if (CollectionUtils.isNotEmpty((Collection)list3)) {
            return CommonResponse.error((String)("\u4e0d\u5141\u8bb8\u65e9\u4e8e\u6700\u5927\u6210\u672c\u671f\u95f4,\u8be5\u9879\u76ee\u7684\u6700\u5927\u6210\u672c\u671f\u95f4\u4e3a\u3010" + ((ShareEntity)((Object)list3.get(0))).getPeriod() + "\u3011"));
        }
        ShareEntity entity = (ShareEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ShareEntity.class));
        if (null != entity.getId()) {
            LambdaQueryWrapper lambdaDetail = Wrappers.lambdaQuery();
            lambdaDetail.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambdaDetail.eq(ShareDetailEntity::getShareId, (Object)entity.getId());
            this.shareDetailService.remove((Wrapper)lambdaDetail);
            ArrayList<ShareDetailEntity> shareDetailEntities = new ArrayList<ShareDetailEntity>();
            if (CollectionUtils.isNotEmpty(entity.getShareDetail())) {
                entity.getShareDetail().forEach(e -> {
                    if (!"del".equals(e.getRowState())) {
                        e.setId(null);
                        shareDetailEntities.add((ShareDetailEntity)((Object)e));
                    }
                });
                entity.setShareDetail(shareDetailEntities);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        BigDecimal sumCostMny = entity.getSumCostMny() == null ? BigDecimal.ZERO : entity.getSumCostMny();
        BigDecimal costMny = entity.getCostMny() == null ? BigDecimal.ZERO : entity.getCostMny();
        ShareVO vo = (ShareVO)BeanMapper.map((Object)((Object)entity), ShareVO.class);
        vo.setSumCostMnys(sumCostMny.add(costMny));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<MonthVO> getMonths(Long projectId, String year) {
        return ((ShareMapper)this.baseMapper).geMonths(projectId, year);
    }

    @Override
    public List<SubjectReportVO> getSubjectReport(Long projectId, String period, int type, Long wbsId) {
        SubjectReportsVO vo;
        CommonResponse resDate = this.shareSubjectOrgApi.shareSubjectOrgApi();
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u79d1\u76ee\u4fe1\u606f\u5931\u8d25!");
        }
        List<Long> wbsIdList = new ArrayList<Long>();
        if (wbsId != null) {
            CommonResponse commonResponse = this.shareProjectWbsApi.queryProjectWbsList(wbsId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f\u5931\u8d25!");
            }
            List projectWbsVOList = (List)commonResponse.getData();
            wbsIdList = projectWbsVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        List<SubjectReportsVO> list = ((ShareMapper)this.baseMapper).getSubjectReport(projectId, period, 0, wbsIdList);
        List<SubjectReportsVO> listsum = ((ShareMapper)this.baseMapper).getSubjectReport(projectId, period, 1, wbsIdList);
        HashMap map = new HashMap();
        HashMap mapList = new HashMap();
        if (CollectionUtils.isNotEmpty(listsum)) {
            listsum.forEach(e -> map.put(e.getSubjectId(), e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny()));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> {
                if (map.containsKey(e.getSubjectId())) {
                    e.setHappenMnySum((BigDecimal)map.get(e.getSubjectId()));
                }
                mapList.put(e.getSubjectId(), e);
            });
        }
        List subjectOrgVOList = (List)resDate.getData();
        ArrayList<SubjectReportsVO> allList = new ArrayList<SubjectReportsVO>();
        for (int i = 0; i < subjectOrgVOList.size(); ++i) {
            SubjectOrgVO subjectOrgVO = (SubjectOrgVO)subjectOrgVOList.get(i);
            vo = new SubjectReportsVO();
            vo.setId(subjectOrgVO.getId());
            vo.setNumber(Integer.valueOf(i + 1));
            vo.setSubjectId(subjectOrgVO.getId());
            vo.setSubjectCode(subjectOrgVO.getSubjectCode());
            vo.setSubjectName(subjectOrgVO.getSubjectName());
            vo.setParentId(subjectOrgVO.getParentId());
            SubjectReportsVO subjectReportsVO = (SubjectReportsVO)mapList.get(subjectOrgVO.getId());
            if (null != subjectReportsVO) {
                vo.setHappenDate(subjectReportsVO.getHappenDate());
                vo.setHappenMny(subjectReportsVO.getHappenMny() == null ? BigDecimal.ZERO : subjectReportsVO.getHappenMny());
                vo.setHappenMnySum(subjectReportsVO.getHappenMnySum() == null ? BigDecimal.ZERO : subjectReportsVO.getHappenMnySum());
            } else {
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }
        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(Long.valueOf(999L));
        tempVo.setNumber(Integer.valueOf(0));
        tempVo.setParentId(Long.valueOf(0L));
        allList.add(tempVo);
        List<Object> listres = new ArrayList<SubjectReportsVO>();
        vo = this.calculateValue(allList);
        this.printGoal(vo, listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        if (0 == type) {
            listres.remove(0);
            return BeanMapper.mapList(listres, SubjectReportVO.class);
        }
        ArrayList<SubjectReportVO> lists = new ArrayList<SubjectReportVO>();
        if (CollectionUtils.isNotEmpty(listres)) {
            listres.forEach(e -> {
                if (0L != e.getParentId() && BigDecimal.ZERO.compareTo(e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny()) != 0) {
                    lists.add((SubjectReportVO)BeanMapper.map((Object)e, SubjectReportVO.class));
                }
            });
        }
        return lists;
    }

    @Override
    public List<TemplateDatas> getSubjectReportAlls(Long projectId, List<String> periods, int type) {
        int i;
        List<SubjectReportsVO> costDetailList = ((ShareMapper)this.baseMapper).getCostDetails(projectId);
        List<SubjectReportVO> costSetting = ((ShareMapper)this.baseMapper).getCostSetting(projectId);
        HashSet period = new HashSet();
        ArrayList fields = new ArrayList();
        if (CollectionUtils.isNotEmpty(costDetailList)) {
            costDetailList.forEach(e -> {
                if (StringUtils.isNotEmpty((CharSequence)e.getPeriod())) {
                    period.add(e.getPeriod());
                }
            });
            ArrayList periodList = new ArrayList(period);
            if (CollectionUtils.isNotEmpty(period)) {
                for (i = 0; i < periodList.size(); ++i) {
                    fields.add(periodList.get(i));
                }
                Collections.sort(fields);
            }
        }
        HashMap maps = new HashMap();
        if (CollectionUtils.isNotEmpty(costSetting)) {
            for (i = 0; i < costSetting.size(); ++i) {
                Long subjectId = costSetting.get(i).getId();
                for (int k = 0; k < fields.size(); ++k) {
                    String nowPeriod = fields.get(k) == null ? "" : (String)fields.get(k);
                    BigDecimal happenMnySum = BigDecimal.ZERO;
                    BigDecimal happenMnySums = BigDecimal.ZERO;
                    for (int n = 0; n < costDetailList.size(); ++n) {
                        BigDecimal happenMny;
                        String dateString = costDetailList.get(n).getPeriod();
                        if (subjectId.equals(costDetailList.get(n).getSubjectId()) && nowPeriod.compareTo(dateString) > 0) {
                            happenMny = costDetailList.get(n).getHappenMny() == null ? BigDecimal.ZERO : costDetailList.get(n).getHappenMny();
                            happenMnySums = happenMnySums.add(happenMny);
                            continue;
                        }
                        if (!subjectId.equals(costDetailList.get(n).getSubjectId()) || nowPeriod.compareTo(dateString) != 0) continue;
                        happenMny = costDetailList.get(n).getHappenMny() == null ? BigDecimal.ZERO : costDetailList.get(n).getHappenMny();
                        happenMnySum = happenMnySum.add(happenMny);
                    }
                    ArrayList<BigDecimal> listnew = new ArrayList<BigDecimal>();
                    listnew.add(happenMnySum);
                    listnew.add(happenMnySum.add(happenMnySums));
                    maps.put(subjectId + nowPeriod, listnew);
                }
            }
        }
        ArrayList<TemplateDatas> listRes = new ArrayList<TemplateDatas>();
        if (CollectionUtils.isNotEmpty(costSetting)) {
            for (int i2 = 0; i2 < costSetting.size(); ++i2) {
                SubjectReportVO e2 = costSetting.get(i2);
                TemplateDatas td = TemplateDatas.New();
                td = (TemplateDatas)BeanMapper.map((Object)e2, TemplateDatas.class);
                BigDecimal periodMnys = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(periods)) {
                    for (String key : periods) {
                        td.addField(key, key);
                        td.addField(key + "-Sum", "\u542b\u672c\u671f\u7d2f\u8ba1");
                        if (maps.containsKey(e2.getId() + key)) {
                            td.add(key, (BigDecimal)((List)maps.get(e2.getId() + key)).get(0));
                            periodMnys = periodMnys.add((BigDecimal)((List)maps.get(e2.getId() + key)).get(0));
                            td.add(key + "-Sum", (BigDecimal)((List)maps.get(e2.getId() + key)).get(1));
                            continue;
                        }
                        td.add(key, BigDecimal.ZERO);
                        td.add(key + "-Sum", BigDecimal.ZERO);
                    }
                } else {
                    for (String key : fields) {
                        td.addField(key, key);
                        td.addField(key + "-Sum", "\u542b\u672c\u671f\u7d2f\u8ba1");
                        if (maps.containsKey(e2.getId() + key)) {
                            td.add(key, (BigDecimal)((List)maps.get(e2.getId() + key)).get(0));
                            periodMnys = periodMnys.add((BigDecimal)((List)maps.get(e2.getId() + key)).get(0));
                            td.add(key + "-Sum", (BigDecimal)((List)maps.get(e2.getId() + key)).get(1));
                            continue;
                        }
                        td.add(key, BigDecimal.ZERO);
                        td.add(key + "-Sum", BigDecimal.ZERO);
                    }
                }
                td.setNumber(Integer.valueOf(i2 + 1));
                td.setPeriodMnys(periodMnys);
                listRes.add(td);
            }
        }
        return listRes;
    }

    @Override
    public SubjectReportVO queryProReports(HttpServletRequest request, Long projectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List shareEntityList = this.settingService.list((Wrapper)lambda);
        SubjectReportVO resVo = new SubjectReportVO();
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda2.eq(ShareEntity::getProjectId, (Object)projectId);
        lambda2.in(ShareEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambda2);
        BigDecimal happenMny = list.stream().map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        resVo.setHappenMny(happenMny);
        if (CollectionUtils.isNotEmpty((Collection)shareEntityList)) {
            List<ShareDetailVO> listDetail = this.getDetail(projectId, "", ((SettingEntity)((Object)shareEntityList.get(0))).getTaxFlag(), null, ((SettingEntity)((Object)shareEntityList.get(0))).getMaterialCost(), 1, request);
            BigDecimal sum = listDetail.stream().map(ShareDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            resVo.setHappenMnySum(sum);
        }
        return resVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShareDetailVO> getDetail(Long projectId, String endDay, String taxFlag, String billType, String materialCost, int type, HttpServletRequest request) {
        QueryWrapper queryWrapper;
        List list = new ArrayList();
        ArrayList<ShareDetailVO> listRes = new ArrayList<ShareDetailVO>();
        if (null != billType && !"".equals(billType)) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"bill_type_code", (Object)billType);
            queryWrapper.ne((Object)"type", (Object)9);
            list = this.billSettingService.list((Wrapper)queryWrapper);
        } else {
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"type", new Object[]{2});
            list = this.billSettingService.list((Wrapper)queryWrapper);
        }
        String authority = request.getHeader("authority");
        ExecutorService threadPool = null;
        try {
            threadPool = Executors.newFixedThreadPool(list.size());
            ArrayList<Future<JSONObject>> callables = new ArrayList<Future<JSONObject>>();
            for (BillSettingEntity billSettingEntity : list) {
                String endDate;
                this.logger.info("condition\u62fc\u63a5\u524d---\uff1a" + billSettingEntity.getBillType());
                String condition = "";
                if (null != endDay && !"".equals(endDay)) {
                    condition = billSettingEntity.getConditions().replace("projectId", "'" + projectId + "'").replace("endDate", "'" + endDay + "'");
                } else if (type == 1) {
                    condition = billSettingEntity.getConditions().replace("projectId", "'" + projectId + "'");
                    endDate = condition.substring(condition.lastIndexOf("and proportion_flag != 1"), condition.lastIndexOf("order") - 1);
                    condition = condition.replace(endDate, "");
                } else {
                    condition = billSettingEntity.getConditions().replace("projectId", "'" + projectId + "'");
                    endDate = condition.substring(condition.lastIndexOf("and "), condition.lastIndexOf("order") - 1);
                    condition = condition.replace(endDate, "");
                }
                this.logger.info("condition\u62fc\u63a5\u540e---\uff1a" + condition);
                BillDetailCallable shareDetailCallable = new BillDetailCallable(RequestContextHolder.getRequestAttributes(), billSettingEntity.getBillTypeCode(), billSettingEntity.getParameter(), condition, authority, taxFlag, billSettingEntity.getPath());
                Future<JSONObject> shareDetailFuture = threadPool.submit(shareDetailCallable);
                callables.add(shareDetailFuture);
            }
            for (Future future : callables) {
                JSONObject json = (JSONObject)future.get();
                if (null == json || null == json.get((Object)"jsonRes")) continue;
                listRes.addAll((List)json.get((Object)"jsonRes"));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (null != threadPool) {
                threadPool.shutdown();
            }
        }
        return listRes;
    }

    @Override
    public SubjectFlagVO getSubkectFlag(Long sourceId, String billType) {
        BillSettingEntity billSettingEntity = new BillSettingEntity();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BillSettingEntity::getType, (Object)9);
        billSettingEntity = (BillSettingEntity)((Object)this.billSettingService.getOne((Wrapper)lambda));
        List list = this.commenQueryFieldsService.queryBillList(billType, billSettingEntity.getParameter(), billSettingEntity.getConditions().replace("billId", "'" + sourceId + "'"));
        SubjectFlagVO newsVos = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            newsVos = (SubjectFlagVO)BeanMapper.map(list.get(0), SubjectFlagVO.class);
        }
        return newsVos;
    }

    @Override
    public List<SubjectReportVO> getCostAllDetails(Long projectId, String beginPeriod, String endPeriod) {
        SubjectReportsVO vo;
        boolean type = false;
        CommonResponse resDate = this.shareSubjectOrgApi.shareSubjectOrgApi();
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u79d1\u76ee\u4fe1\u606f\u5931\u8d25!");
        }
        List<SubjectReportsVO> listsum = ((ShareMapper)this.baseMapper).getCostAllDetails(projectId, beginPeriod, endPeriod);
        HashMap map = new HashMap();
        HashMap mapList = new HashMap();
        if (CollectionUtils.isNotEmpty(listsum)) {
            listsum.forEach(e -> mapList.put(e.getSubjectId(), e));
        }
        List subjectOrgVOList = (List)resDate.getData();
        ArrayList<SubjectReportsVO> allList = new ArrayList<SubjectReportsVO>();
        for (int i = 0; i < subjectOrgVOList.size(); ++i) {
            SubjectOrgVO subjectOrgVO = (SubjectOrgVO)subjectOrgVOList.get(i);
            vo = new SubjectReportsVO();
            vo.setId(subjectOrgVO.getId());
            vo.setNumber(Integer.valueOf(i + 1));
            vo.setSubjectId(subjectOrgVO.getId());
            vo.setSubjectCode(subjectOrgVO.getSubjectCode());
            vo.setSubjectName(subjectOrgVO.getSubjectName());
            vo.setParentId(subjectOrgVO.getParentId());
            SubjectReportsVO subjectReportsVO = (SubjectReportsVO)mapList.get(subjectOrgVO.getId());
            if (null != subjectReportsVO) {
                vo.setHappenDate(subjectReportsVO.getHappenDate());
                vo.setHappenMny(subjectReportsVO.getHappenMny() == null ? BigDecimal.ZERO : subjectReportsVO.getHappenMny());
                vo.setHappenMnySum(subjectReportsVO.getHappenMnySum() == null ? BigDecimal.ZERO : subjectReportsVO.getHappenMnySum());
            } else {
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }
        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(Long.valueOf(999L));
        tempVo.setNumber(Integer.valueOf(0));
        tempVo.setParentId(Long.valueOf(0L));
        allList.add(tempVo);
        List<Object> listres = new ArrayList<SubjectReportsVO>();
        vo = this.calculateValue(allList);
        this.printGoal(vo, listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        if (!type) {
            listres.remove(0);
            return BeanMapper.mapList(listres, SubjectReportVO.class);
        }
        ArrayList<SubjectReportVO> lists = new ArrayList<SubjectReportVO>();
        if (CollectionUtils.isNotEmpty(listres)) {
            listres.forEach(e -> {
                if (0L != e.getParentId() && BigDecimal.ZERO.compareTo(e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny()) != 0) {
                    lists.add((SubjectReportVO)BeanMapper.map((Object)e, SubjectReportVO.class));
                }
            });
        }
        return lists;
    }

    @Override
    public List<SubjectReportVO> getDetailsBySubjectId(Long projectId, String beginPeriod, String endPeriod, Long subjectId) {
        CommonResponse commonResponse;
        QueryParam param = new QueryParam();
        param.getParams().put("innerCode", new Parameter("like", (Object)subjectId));
        CommonResponse resDate = this.shareSubjectOrgApi.querySubjectOrg(param);
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u79d1\u76ee\u4fe1\u606f\u5931\u8d25!");
        }
        List<Long> subjectIdList = ((List)resDate.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        this.logger.info("\u79d1\u76ee\u4e3b\u952e--" + subjectIdList);
        List<SubjectReportsVO> list = ((ShareMapper)this.baseMapper).getDetailsBySubjectId(projectId, beginPeriod, endPeriod, subjectIdList);
        HashMap mapList = new HashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> mapList.put(e.getWbsId(), e));
        }
        if (!(commonResponse = this.shareProjectWbsApi.queryByProjectId(projectId)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f\u5931\u8d25!");
        }
        List projectWbsVOList = (List)commonResponse.getData();
        ArrayList<SubjectReportsVO> listres = new ArrayList<SubjectReportsVO>();
        for (int i = 0; i < projectWbsVOList.size(); ++i) {
            SubjectReportsVO reportsVO = new SubjectReportsVO();
            ProjectWbsVO projectWbsVO = (ProjectWbsVO)projectWbsVOList.get(i);
            reportsVO.setId(projectWbsVO.getId());
            reportsVO.setWbsId(projectWbsVO.getId());
            reportsVO.setWbsId(projectWbsVO.getId());
            reportsVO.setWbsName(projectWbsVO.getName());
            reportsVO.setWbsCode(projectWbsVO.getCode());
            reportsVO.setParentId(projectWbsVO.getParentId());
            SubjectReportsVO subjectReportsVO = (SubjectReportsVO)mapList.get(projectWbsVO.getId());
            if (null != subjectReportsVO) {
                reportsVO.setHappenMny(subjectReportsVO.getHappenMny() == null ? BigDecimal.ZERO : subjectReportsVO.getHappenMny());
                reportsVO.setHappenTaxMny(subjectReportsVO.getHappenTaxMny() == null ? BigDecimal.ZERO : subjectReportsVO.getHappenTaxMny());
                reportsVO.setSubjectId(subjectReportsVO.getSubjectId());
            }
            listres.add(reportsVO);
        }
        return BeanMapper.mapList(listres, SubjectReportVO.class);
    }

    @Override
    public List<SubjectReportsVO> getDetailsByWbsId(Long projectId, String beginPeriod, String endPeriod, Long subjectId, Long wbsId) {
        List<SubjectReportsVO> res;
        QueryParam param = new QueryParam();
        param.getParams().put("innerCode", new Parameter("like", (Object)subjectId));
        CommonResponse resDate = this.shareSubjectOrgApi.querySubjectOrg(param);
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u79d1\u76ee\u4fe1\u606f\u5931\u8d25!");
        }
        List<Long> subjectIdList = ((List)resDate.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        this.logger.info("\u79d1\u76ee\u4e3b\u952e--" + subjectIdList);
        CommonResponse commonResponse = this.shareProjectWbsApi.queryByProjectId(projectId);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f\u5931\u8d25!");
        }
        List projectWbsVOList = (List)commonResponse.getData();
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)projectWbsVOList)) {
            projectWbsVOList.forEach(e -> map.put(e.getId(), e.getName()));
        }
        if (CollectionUtils.isNotEmpty(res = ((ShareMapper)this.baseMapper).getDetailsByWbsId(projectId, beginPeriod, endPeriod, subjectIdList, wbsId))) {
            res.forEach(e -> e.setWbsName((String)map.get(e.getWbsId())));
        }
        return res;
    }

    @Override
    public List<ThreeReportVO> getThreeReports(Long projectId, String endPeriod) {
        SubjectReportsVO vo;
        CommonResponse mbRes;
        boolean type = false;
        QueryParam param = new QueryParam();
        param.getParams().put("subject_name", new Parameter("ne", (Object)"\u7a0e\u91d1"));
        CommonResponse resDate = this.shareSubjectOrgApi.querySubjectOrg(param);
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u79d1\u76ee\u4fe1\u606f\u5931\u8d25!");
        }
        this.logger.info("\u79d1\u76ee\u4fe1\u606f-----" + JSONObject.toJSONString((Object)resDate.getData()));
        CommonResponse ysRes = this.budgetApi.querySumBudgetMny(projectId, endPeriod);
        if (!ysRes.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9884\u7b97\u4fe1\u606f\u5931\u8d25!");
        }
        List budgetReportVOList = (List)ysRes.getData();
        this.logger.info("\u9884\u7b97\u8fd4\u56de\u4fe1\u606f---------" + JSONObject.toJSONString((Object)budgetReportVOList));
        HashMap ysMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)budgetReportVOList)) {
            List ysList = BeanMapper.mapList((Iterable)budgetReportVOList, SubjectReportsVO.class);
            ysList.forEach(e -> ysMap.put(e.getSubjectId(), e));
        }
        List<SubjectReportsVO> listPeriod = ((ShareMapper)this.baseMapper).getCostDetail(projectId, endPeriod);
        HashMap mapPeriod = new HashMap();
        if (CollectionUtils.isNotEmpty(listPeriod)) {
            listPeriod.forEach(e -> mapPeriod.put(e.getSubjectId(), e));
        }
        List<SubjectReportsVO> listAll = ((ShareMapper)this.baseMapper).getCostDetail(projectId, "");
        HashMap cbMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listAll)) {
            listAll.forEach(e -> {
                e.setHappenMnyAll(e.getHappenMny());
                e.setHappenTaxMnyAll(e.getHappenTaxMny());
                if (mapPeriod.containsKey(e.getSubjectId())) {
                    e.setHappenMny(((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenMny() == null ? BigDecimal.ZERO : ((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenMny());
                    e.setHappenTaxMny(((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenTaxMny() == null ? BigDecimal.ZERO : ((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenTaxMny());
                } else {
                    e.setHappenMny(null);
                    e.setHappenTaxMny(null);
                }
                cbMap.put(e.getSubjectId(), e);
            });
        }
        if (!(mbRes = this.targetCostFinishApi.costReportQuery(projectId, endPeriod)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\uff0c\u76ee\u6807\u4fe1\u606f\u5931\u8d25!");
        }
        List mbReportVOList = (List)mbRes.getData();
        this.logger.info("\u76ee\u6807\u8fd4\u56de\u4fe1\u606f---------" + JSONObject.toJSONString((Object)mbReportVOList));
        HashMap sjMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)mbReportVOList)) {
            List sjList = BeanMapper.mapList((Iterable)mbReportVOList, SubjectReportsVO.class);
            sjList.forEach(e -> sjMap.put(e.getSubjectId(), e));
        }
        List subjectOrgVOList = (List)resDate.getData();
        HashMap mapList = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)subjectOrgVOList)) {
            subjectOrgVOList.forEach(e -> {
                SubjectReportsVO vo = new SubjectReportsVO();
                SubjectReportsVO ysvo = (SubjectReportsVO)ysMap.get(e.getId());
                SubjectReportsVO cbvo = (SubjectReportsVO)cbMap.get(e.getId());
                SubjectReportsVO sjvo = (SubjectReportsVO)sjMap.get(e.getId());
                vo.setSubjectId(e.getId());
                vo.setSubjectName(e.getSubjectName());
                vo.setSubjectCode(e.getSubjectCode());
                if (null != ysvo) {
                    vo.setYsHappenMny(ysvo.getYsHappenMny());
                    vo.setYsHappenTaxMny(ysvo.getYsHappenTaxMny());
                    vo.setYsHappenMnyAll(ysvo.getYsHappenMnyAll());
                    vo.setYsHappenTaxMnyAll(ysvo.getYsHappenTaxMnyAll());
                }
                if (null != cbvo) {
                    vo.setHappenMny(cbvo.getHappenMny());
                    vo.setHappenMnyAll(cbvo.getHappenMnyAll());
                    vo.setHappenTaxMny(cbvo.getHappenTaxMny());
                    vo.setHappenTaxMnyAll(cbvo.getHappenTaxMnyAll());
                }
                if (null != sjvo) {
                    vo.setCbHappenMny(sjvo.getCbHappenMny());
                    vo.setCbHappenTaxMny(sjvo.getCbHappenTaxMny());
                    vo.setCbHappenMnyAll(sjvo.getCbHappenMnyAll());
                    vo.setCbHappenTaxMnyAll(sjvo.getCbHappenTaxMnyAll());
                }
                mapList.put(e.getId(), vo);
            });
        }
        ArrayList<SubjectReportsVO> allList = new ArrayList<SubjectReportsVO>();
        for (int i = 0; i < subjectOrgVOList.size(); ++i) {
            SubjectOrgVO subjectOrgVO = (SubjectOrgVO)subjectOrgVOList.get(i);
            vo = (SubjectReportsVO)mapList.get(subjectOrgVO.getId());
            if (null != vo) {
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(Integer.valueOf(i + 1));
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
            } else {
                vo = new SubjectReportsVO();
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(Integer.valueOf(i + 1));
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }
        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(Long.valueOf(999L));
        tempVo.setNumber(Integer.valueOf(0));
        tempVo.setParentId(Long.valueOf(0L));
        allList.add(tempVo);
        List<Object> listres = new ArrayList<SubjectReportsVO>();
        vo = this.calculateValue2(allList);
        this.printGoal(vo, listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        listres.remove(0);
        listres.forEach(e -> {
            BigDecimal happenMny = e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny();
            BigDecimal ysHappenMny = e.getYsHappenMny() == null ? BigDecimal.ZERO : e.getYsHappenMny();
            BigDecimal cbHappenMny = e.getCbHappenMny() == null ? BigDecimal.ZERO : e.getCbHappenMny();
            BigDecimal srmbdifMny = ysHappenMny.subtract(cbHappenMny);
            BigDecimal srmbRate = BigDecimal.ZERO;
            if (srmbdifMny.compareTo(BigDecimal.ZERO) != 0 && ysHappenMny.compareTo(BigDecimal.ZERO) != 0) {
                srmbRate = srmbdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny, 2, 5);
            }
            e.setSrmbdifMny(srmbdifMny);
            e.setSrmbRate(srmbRate);
            BigDecimal mbsjdifMny = cbHappenMny.subtract(happenMny);
            BigDecimal mbsjRate = BigDecimal.ZERO;
            if (mbsjdifMny.compareTo(BigDecimal.ZERO) != 0 && cbHappenMny.compareTo(BigDecimal.ZERO) != 0) {
                mbsjRate = mbsjdifMny.multiply(new BigDecimal(100)).divide(cbHappenMny, 2, 5);
            }
            e.setMbsjdifMny(mbsjdifMny);
            e.setMbsjRate(mbsjRate);
            BigDecimal srsjdifMny = ysHappenMny.subtract(happenMny);
            BigDecimal srsjRate = BigDecimal.ZERO;
            if (srsjdifMny.compareTo(BigDecimal.ZERO) != 0 && ysHappenMny.compareTo(BigDecimal.ZERO) != 0) {
                srsjRate = srsjdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny, 2, 5);
            }
            e.setSrsjdifMny(srsjdifMny);
            e.setSrsjRate(srsjRate);
        });
        return BeanMapper.mapList(listres, ThreeReportVO.class);
    }

    @Override
    public List<ThreeReportVO> getNumpReports(Long projectId, String endPeriod) {
        SubjectReportsVO vo;
        CommonResponse mbRes;
        boolean type = false;
        QueryParam param = new QueryParam();
        param.getParams().put("innerCode", new Parameter("like", (Object)this.costSubjectId));
        CommonResponse resDate = this.shareSubjectOrgApi.querySubjectOrg(param);
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u79d1\u76ee\u4fe1\u606f\u5931\u8d25!");
        }
        this.logger.info("\u79d1\u76ee\u4fe1\u606f-----" + JSONObject.toJSONString((Object)resDate.getData()));
        CommonResponse ysRes = this.budgetApi.querySumBudgetMny(projectId, endPeriod);
        if (!ysRes.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9884\u7b97\u4fe1\u606f\u5931\u8d25!");
        }
        this.logger.info("\u9884\u7b97\u4fe1\u606f-----" + JSONObject.toJSONString((Object)ysRes.getData()));
        List budgetReportVOList = (List)ysRes.getData();
        HashMap ysMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)budgetReportVOList)) {
            List ysList = BeanMapper.mapList((Iterable)budgetReportVOList, SubjectReportsVO.class);
            ysList.forEach(e -> ysMap.put(e.getSubjectId(), e));
        }
        List<SubjectReportsVO> listPeriod = ((ShareMapper)this.baseMapper).getCostDetail(projectId, endPeriod);
        HashMap mapPeriod = new HashMap();
        if (CollectionUtils.isNotEmpty(listPeriod)) {
            listPeriod.forEach(e -> mapPeriod.put(e.getSubjectId(), e));
        }
        List<SubjectReportsVO> listAll = ((ShareMapper)this.baseMapper).getCostDetail(projectId, "");
        HashMap cbMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listAll)) {
            listAll.forEach(e -> {
                e.setHappenMnyAll(e.getHappenMny());
                e.setHappenTaxMnyAll(e.getHappenTaxMny());
                if (mapPeriod.containsKey(e.getSubjectId())) {
                    e.setHappenMny(((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenMny() == null ? BigDecimal.ZERO : ((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenMny());
                    e.setHappenTaxMny(((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenTaxMny() == null ? BigDecimal.ZERO : ((SubjectReportsVO)mapPeriod.get(e.getSubjectId())).getHappenTaxMny());
                } else {
                    e.setHappenMny(null);
                    e.setHappenTaxMny(null);
                }
                cbMap.put(e.getSubjectId(), e);
            });
        }
        if (!(mbRes = this.targetCostFinishApi.costReportQuery(projectId, endPeriod)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\uff0c\u76ee\u6807\u4fe1\u606f\u5931\u8d25!");
        }
        List mbReportVOList = (List)mbRes.getData();
        this.logger.info("\u76ee\u6807\u8fd4\u56de\u4fe1\u606f---------" + JSONObject.toJSONString((Object)mbReportVOList));
        HashMap mbMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)mbReportVOList)) {
            List mbList = BeanMapper.mapList((Iterable)mbReportVOList, SubjectReportsVO.class);
            mbList.forEach(e -> mbMap.put(e.getSubjectId(), e));
        }
        List subjectOrgVOList = (List)resDate.getData();
        HashMap mapList = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)subjectOrgVOList)) {
            subjectOrgVOList.forEach(e -> {
                SubjectReportsVO vo = new SubjectReportsVO();
                SubjectReportsVO ysvo = (SubjectReportsVO)ysMap.get(e.getId());
                SubjectReportsVO cbvo = (SubjectReportsVO)cbMap.get(e.getId());
                SubjectReportsVO mbvo = (SubjectReportsVO)mbMap.get(e.getId());
                vo.setSubjectId(e.getId());
                vo.setSubjectName(e.getSubjectName());
                vo.setSubjectCode(e.getSubjectCode());
                if (null != ysvo) {
                    vo.setYsHappenMny(ysvo.getYsHappenMny());
                    vo.setYsHappenTaxMny(ysvo.getYsHappenTaxMny());
                    vo.setYsHappenMnyAll(ysvo.getYsHappenMnyAll());
                    vo.setYsHappenTaxMnyAll(ysvo.getYsHappenTaxMnyAll());
                    BigDecimal ysNum = ysvo.getYsNum();
                    BigDecimal ysHappenMny = ysvo.getYsHappenMny();
                    vo.setYsNum(ysNum);
                    vo.setYsNumAll(ysvo.getYsNumAll());
                    if (null != ysNum && null != ysHappenMny && ysNum.compareTo(BigDecimal.ZERO) > 0 && ysHappenMny.compareTo(BigDecimal.ZERO) > 0) {
                        vo.setYsPrice(ysHappenMny.divide(ysNum, 2, 5));
                    }
                }
                if (null != cbvo) {
                    vo.setHappenMny(cbvo.getHappenMny());
                    vo.setHappenMnyAll(cbvo.getHappenMnyAll());
                    vo.setHappenTaxMny(cbvo.getHappenTaxMny());
                    vo.setHappenTaxMnyAll(cbvo.getHappenTaxMnyAll());
                    BigDecimal num = cbvo.getNum();
                    BigDecimal happenMny = cbvo.getHappenMny();
                    if (null != num && null != happenMny && num.compareTo(BigDecimal.ZERO) > 0 && happenMny.compareTo(BigDecimal.ZERO) > 0) {
                        vo.setNum(num);
                        vo.setPrice(happenMny.divide(num, 2, 5));
                    }
                }
                if (null != mbvo) {
                    vo.setCbHappenMny(mbvo.getCbHappenMny());
                    vo.setCbHappenTaxMny(mbvo.getCbHappenTaxMny());
                    vo.setCbHappenMnyAll(mbvo.getCbHappenMnyAll());
                    vo.setCbHappenTaxMnyAll(mbvo.getCbHappenTaxMnyAll());
                    BigDecimal mbnum = mbvo.getCbNum();
                    BigDecimal mbhappenMny = mbvo.getCbHappenMny();
                    vo.setCbNum(mbnum);
                    vo.setCbNumAll(mbvo.getCbNumAll());
                    if (null != mbnum && null != mbhappenMny && mbnum.compareTo(BigDecimal.ZERO) > 0 && mbhappenMny.compareTo(BigDecimal.ZERO) > 0) {
                        vo.setCbPrice(mbhappenMny.divide(mbnum, 2, 5));
                    }
                }
                mapList.put(e.getId(), vo);
            });
        }
        ArrayList<SubjectReportsVO> allList = new ArrayList<SubjectReportsVO>();
        for (int i = 0; i < subjectOrgVOList.size(); ++i) {
            SubjectOrgVO subjectOrgVO = (SubjectOrgVO)subjectOrgVOList.get(i);
            vo = (SubjectReportsVO)mapList.get(subjectOrgVO.getId());
            if (null != vo) {
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(Integer.valueOf(i + 1));
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
            } else {
                vo = new SubjectReportsVO();
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(Integer.valueOf(i + 1));
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }
        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(Long.valueOf(999L));
        tempVo.setNumber(Integer.valueOf(0));
        tempVo.setParentId(Long.valueOf(0L));
        allList.add(tempVo);
        List<Object> listres = new ArrayList<SubjectReportsVO>();
        vo = this.calculateValue2(allList);
        this.printGoal(vo, listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        listres.remove(0);
        listres.forEach(e -> {
            BigDecimal happenMny = e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny();
            BigDecimal num = e.getNum() == null ? BigDecimal.ZERO : e.getNum();
            BigDecimal ysHappenMny = e.getYsHappenMny() == null ? BigDecimal.ZERO : e.getYsHappenMny();
            BigDecimal ysNum = e.getYsNum() == null ? BigDecimal.ZERO : e.getYsNum();
            BigDecimal cbHappenMny = e.getCbHappenMny() == null ? BigDecimal.ZERO : e.getCbHappenMny();
            BigDecimal cbNum = e.getCbNum() == null ? BigDecimal.ZERO : e.getCbNum();
            BigDecimal srmbNum = ysNum.subtract(cbNum);
            BigDecimal srmbNumRate = BigDecimal.ZERO;
            if (srmbNum.compareTo(BigDecimal.ZERO) != 0 && ysNum.compareTo(BigDecimal.ZERO) != 0) {
                srmbNumRate = srmbNum.multiply(new BigDecimal(100)).divide(ysNum, 2, 5);
            }
            e.setSrmbNum(srmbNum);
            e.setSrmbNumRate(srmbNumRate);
            BigDecimal srmbdifMny = ysHappenMny.subtract(cbHappenMny);
            BigDecimal srmbRate = BigDecimal.ZERO;
            if (srmbdifMny.compareTo(BigDecimal.ZERO) != 0 && ysHappenMny.compareTo(BigDecimal.ZERO) != 0) {
                srmbRate = srmbdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny, 2, 5);
            }
            e.setSrmbdifMny(srmbdifMny);
            e.setSrmbRate(srmbRate);
            BigDecimal mbsjNum = cbNum.subtract(num);
            BigDecimal mbsjNumRate = BigDecimal.ZERO;
            if (mbsjNum.compareTo(BigDecimal.ZERO) != 0 && cbNum.compareTo(BigDecimal.ZERO) != 0) {
                mbsjNumRate = mbsjNum.multiply(new BigDecimal(100)).divide(cbNum, 2, 5);
            }
            e.setMbsjNum(mbsjNum);
            e.setMbsjNumRate(mbsjNumRate);
            BigDecimal mbsjdifMny = cbHappenMny.subtract(happenMny);
            BigDecimal mbsjRate = BigDecimal.ZERO;
            if (mbsjdifMny.compareTo(BigDecimal.ZERO) != 0 && cbHappenMny.compareTo(BigDecimal.ZERO) != 0) {
                mbsjRate = mbsjdifMny.multiply(new BigDecimal(100)).divide(cbHappenMny, 2, 5);
            }
            e.setMbsjdifMny(mbsjdifMny);
            e.setMbsjRate(mbsjRate);
            BigDecimal srsjNum = ysNum.subtract(num);
            BigDecimal srsjNumRate = BigDecimal.ZERO;
            if (srsjNum.compareTo(BigDecimal.ZERO) != 0 && ysNum.compareTo(BigDecimal.ZERO) != 0) {
                srsjNumRate = srsjNum.multiply(new BigDecimal(100)).divide(ysNum, 2, 5);
            }
            e.setSrsjNum(srsjNum);
            e.setSrsjNumRate(srsjNumRate);
            BigDecimal srsjdifMny = ysHappenMny.subtract(happenMny);
            BigDecimal srsjRate = BigDecimal.ZERO;
            if (srsjdifMny.compareTo(BigDecimal.ZERO) != 0 && ysHappenMny.compareTo(BigDecimal.ZERO) != 0) {
                srsjRate = srsjdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny, 2, 5);
            }
            e.setSrsjdifMny(srsjdifMny);
            e.setSrsjRate(srsjRate);
        });
        return BeanMapper.mapList(listres, ThreeReportVO.class);
    }

    public List<SubjectReportsVO> getBottomNode(List<SubjectReportsVO> listGoal) {
        HashMap<Long, SubjectReportsVO> map = new HashMap<Long, SubjectReportsVO>();
        for (SubjectReportsVO g : listGoal) {
            map.put(g.getId(), g);
        }
        for (SubjectReportsVO g : listGoal) {
            Long pid = g.getParentId();
            if (!map.containsKey(pid)) continue;
            map.remove(pid);
        }
        return new ArrayList<SubjectReportsVO>(map.values());
    }

    public List<SubjectReportsVO> setParentValue(List<SubjectReportsVO> listAllGoal, List<SubjectReportsVO> listBottomGoal) {
        HashMap<Long, ArrayList<SubjectReportsVO>> map = new HashMap<Long, ArrayList<SubjectReportsVO>>();
        for (SubjectReportsVO g : listBottomGoal) {
            Long pid = g.getParentId();
            ArrayList<SubjectReportsVO> listGoal = (ArrayList<SubjectReportsVO>)map.get(pid);
            if (listGoal == null) {
                listGoal = new ArrayList<SubjectReportsVO>();
            }
            listGoal.add(g);
            map.put(pid, listGoal);
        }
        for (Long i : map.keySet()) {
            List tempListGoal = (List)map.get(i);
            BigDecimal result = BigDecimal.ZERO;
            BigDecimal result2 = BigDecimal.ZERO;
            for (SubjectReportsVO g : tempListGoal) {
                result = result.add(g.getHappenMny() == null ? BigDecimal.ZERO : g.getHappenMny());
                result2 = result2.add(g.getHappenMnySum() == null ? BigDecimal.ZERO : g.getHappenMnySum());
            }
            for (SubjectReportsVO g : listAllGoal) {
                Long id = g.getId();
                if (id.longValue() != i.longValue()) continue;
                List tempList = g.getChildren();
                if (tempList != null) {
                    tempListGoal.addAll(tempList);
                }
                g.setChildren(tempListGoal);
                BigDecimal score = g.getHappenMny() == null ? BigDecimal.ZERO : g.getHappenMny();
                BigDecimal score2 = g.getHappenMnySum() == null ? BigDecimal.ZERO : g.getHappenMnySum();
                score = score.add(result);
                score2 = score2.add(result2);
                g.setHappenMny(score);
                g.setHappenMnySum(score2);
            }
        }
        for (SubjectReportsVO g : listBottomGoal) {
            listAllGoal.remove(g);
        }
        return listAllGoal;
    }

    public List<SubjectReportsVO> setParentValue2(List<SubjectReportsVO> listAllGoal, List<SubjectReportsVO> listBottomGoal) {
        HashMap<Long, ArrayList<SubjectReportsVO>> map = new HashMap<Long, ArrayList<SubjectReportsVO>>();
        for (SubjectReportsVO g : listBottomGoal) {
            Long pid = g.getParentId();
            ArrayList<SubjectReportsVO> listGoal = (ArrayList<SubjectReportsVO>)map.get(pid);
            if (listGoal == null) {
                listGoal = new ArrayList<SubjectReportsVO>();
            }
            listGoal.add(g);
            map.put(pid, listGoal);
        }
        for (Long i : map.keySet()) {
            List tempListGoal = (List)map.get(i);
            BigDecimal result = BigDecimal.ZERO;
            BigDecimal result2 = BigDecimal.ZERO;
            BigDecimal result3 = BigDecimal.ZERO;
            BigDecimal result4 = BigDecimal.ZERO;
            BigDecimal result5 = BigDecimal.ZERO;
            BigDecimal result6 = BigDecimal.ZERO;
            BigDecimal result7 = BigDecimal.ZERO;
            BigDecimal result8 = BigDecimal.ZERO;
            BigDecimal result9 = BigDecimal.ZERO;
            BigDecimal result10 = BigDecimal.ZERO;
            for (SubjectReportsVO g : tempListGoal) {
                result = result.add(g.getHappenMny() == null ? BigDecimal.ZERO : g.getHappenMny());
                result2 = result2.add(g.getHappenTaxMny() == null ? BigDecimal.ZERO : g.getHappenTaxMny());
                result3 = result3.add(g.getHappenMnyAll() == null ? BigDecimal.ZERO : g.getHappenMnyAll());
                result4 = result4.add(g.getHappenTaxMnyAll() == null ? BigDecimal.ZERO : g.getHappenTaxMnyAll());
                result5 = result5.add(g.getYsHappenMny() == null ? BigDecimal.ZERO : g.getYsHappenMny());
                result6 = result6.add(g.getYsHappenTaxMny() == null ? BigDecimal.ZERO : g.getYsHappenTaxMny());
                result7 = result7.add(g.getYsHappenMnyAll() == null ? BigDecimal.ZERO : g.getYsHappenMnyAll());
                result8 = result8.add(g.getYsHappenTaxMnyAll() == null ? BigDecimal.ZERO : g.getYsHappenTaxMnyAll());
                result9 = result9.add(g.getCbHappenMny() == null ? BigDecimal.ZERO : g.getCbHappenMny());
                result10 = result10.add(g.getCbHappenTaxMny() == null ? BigDecimal.ZERO : g.getCbHappenTaxMny());
            }
            for (SubjectReportsVO g : listAllGoal) {
                Long id = g.getId();
                if (id.longValue() != i.longValue()) continue;
                List tempList = g.getChildren();
                if (tempList != null) {
                    tempListGoal.addAll(tempList);
                }
                g.setChildren(tempListGoal);
                BigDecimal score = g.getHappenMny() == null ? BigDecimal.ZERO : g.getHappenMny();
                BigDecimal score2 = g.getHappenTaxMny() == null ? BigDecimal.ZERO : g.getHappenTaxMny();
                BigDecimal score3 = g.getHappenMnyAll() == null ? BigDecimal.ZERO : g.getHappenMnyAll();
                BigDecimal score4 = g.getHappenTaxMnyAll() == null ? BigDecimal.ZERO : g.getHappenTaxMnyAll();
                BigDecimal score5 = g.getYsHappenMny() == null ? BigDecimal.ZERO : g.getYsHappenMny();
                BigDecimal score6 = g.getYsHappenTaxMny() == null ? BigDecimal.ZERO : g.getYsHappenTaxMny();
                BigDecimal score7 = g.getYsHappenMnyAll() == null ? BigDecimal.ZERO : g.getYsHappenMnyAll();
                BigDecimal score8 = g.getYsHappenTaxMnyAll() == null ? BigDecimal.ZERO : g.getYsHappenTaxMnyAll();
                BigDecimal score9 = g.getCbHappenMny() == null ? BigDecimal.ZERO : g.getCbHappenMny();
                BigDecimal score10 = g.getCbHappenTaxMny() == null ? BigDecimal.ZERO : g.getCbHappenTaxMny();
                score = score.add(result);
                score2 = score2.add(result2);
                score3 = score3.add(result3);
                score4 = score4.add(result4);
                score5 = score5.add(result5);
                score6 = score6.add(result6);
                score7 = score7.add(result7);
                score8 = score8.add(result8);
                score9 = score9.add(result9);
                score10 = score10.add(result10);
                g.setHappenMny(score);
                g.setHappenTaxMny(score2);
                g.setHappenMnyAll(score3);
                g.setHappenTaxMnyAll(score4);
                g.setYsHappenMny(score5);
                g.setYsHappenTaxMny(score6);
                g.setYsHappenMnyAll(score7);
                g.setYsHappenTaxMnyAll(score8);
                g.setCbHappenMny(score9);
                g.setCbHappenTaxMny(score10);
            }
        }
        for (SubjectReportsVO g : listBottomGoal) {
            listAllGoal.remove(g);
        }
        return listAllGoal;
    }

    public SubjectReportsVO calculateValue(List<SubjectReportsVO> listGoal) {
        if (listGoal.size() == 1) {
            return listGoal.get(0);
        }
        List<SubjectReportsVO> listBottomGoal = this.getBottomNode(listGoal);
        List<SubjectReportsVO> list = this.setParentValue(listGoal, listBottomGoal);
        return this.calculateValue(list);
    }

    public void printGoal(SubjectReportsVO goal, List<SubjectReportsVO> list) {
        list.add(goal);
        List listGoal = goal.getChildren();
        if (listGoal == null || listGoal.size() == 0) {
            return;
        }
        for (SubjectReportsVO g : listGoal) {
            this.printGoal(g, list);
        }
    }

    public SubjectReportsVO calculateValue2(List<SubjectReportsVO> listGoal) {
        if (listGoal.size() == 1) {
            return listGoal.get(0);
        }
        List<SubjectReportsVO> listBottomGoal = this.getBottomNode(listGoal);
        List<SubjectReportsVO> list = this.setParentValue2(listGoal, listBottomGoal);
        return this.calculateValue2(list);
    }

    @Override
    public List<Map<String, Object>> queryCollectionWarnCost(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        Date date = new Date();
        Date oneDate = DateUtil.setDays(date, 1);
        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
        Date oldDate = DateUtil.addMonths(oneDate, -1);
        String s = DateFormatUtil.formatDate((String)"yyyy-MM", (Date)oldDate);
        CommonResponse jsonArrayCommonResponse = this.projectPoolApi.queryProjectPoolList(null, null, null);
        if (!jsonArrayCommonResponse.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u9879\u76ee\u5931\u8d25\uff01\u62a5\u9519\u4fe1\u606f:-----{}" + jsonArrayCommonResponse.getMsg());
            return mapList;
        }
        JSONArray data = (JSONArray)jsonArrayCommonResponse.getData();
        List projectData = JSONObject.parseArray((String)data.toJSONString(), ProjectPoolSetVO.class);
        this.logger.info("\u9879\u76ee\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)projectData.size());
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ShareEntity::getPeriod, (Object)s);
        lambda.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambda);
        this.logger.info("\u6210\u672c\u6761\u6570\uff1a{}", (Object)list.size());
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t -> null != t.getTenantId()).collect(Collectors.groupingBy(BaseEntity::getTenantId));
        this.logger.info("\u6210\u672c\u79df\u6237\u5206\u7ec4\u6761\u6570\uff1a{}", (Object)costTenantIdMap.size());
        for (SqlParam sqlParam : sqlParamList) {
            Integer day = sqlParam.getValue().intValue();
            this.logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u5f53\u524d\u6708\u7b2c\u4e00\u5929\u65e5\u671f\uff1a{}\uff0c\u5dee\u503c\uff1a{},\u4e0a\u4e00\u4e2a\u6708\uff1a{},\u9694\u5929\u6570\uff1a{},\u79df\u6237id:{}", new Object[]{DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)date), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oneDate), betweenDays, s, day, sqlParam.getTenantId()});
            if (betweenDays < day) {
                this.logger.error("\u4e0d\u5230\u9884\u8b66\u65f6\u95f4");
                continue;
            }
            ArrayList shareList = null == costTenantIdMap.get(sqlParam.getTenantId()) ? new ArrayList() : costTenantIdMap.get(sqlParam.getTenantId());
            Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t -> null != t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
            if (!CollectionUtils.isNotEmpty((Collection)projectData)) continue;
            for (ProjectPoolSetVO projectPoolSetVO : projectData) {
                List<ShareEntity> shareEntities;
                if (null == projectPoolSetVO.getTenantId() || !projectPoolSetVO.getTenantId().equals(sqlParam.getTenantId()) || null != (shareEntities = costMap.get(projectPoolSetVO.getId())) && !CollectionUtils.isEmpty(shareEntities)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgId", projectPoolSetVO.getOrgId());
                map.put("orgName", projectPoolSetVO.getOrgName());
                map.put("tenantId", projectPoolSetVO.getTenantId());
                map.put("projectName", projectPoolSetVO.getName());
                map.put("projectId", projectPoolSetVO.getId());
                map.put("warnLevel", sqlParam.getWarnLevel());
                mapList.add(map);
            }
        }
        return mapList;
    }

    @Override
    public List<Map<String, Object>> queryOutputWarnCost(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        CommonResponse mapCommonResponse = this.proincomeContractApi.queryTotalProduction();
        if (!mapCommonResponse.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u4ea7\u503c\u62a5\u91cf\u5931\u8d25\uff0c\u62a5\u9519\u4fe1\u606f\uff1a{}", (Object)mapCommonResponse.getMsg());
        }
        Map data = (Map)mapCommonResponse.getData();
        this.logger.info("\u4ea7\u503c\u62a5\u91cf\u6761\u6570\uff1a{}", (Object)data.size());
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambda);
        this.logger.info("\u6210\u672c\u6761\u6570\uff1a{}", (Object)list.size());
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t -> null != t.getTenantId()).collect(Collectors.groupingBy(BaseEntity::getTenantId));
        this.logger.info("\u6210\u672c\u79df\u6237\u5206\u7ec4\u6761\u6570\uff1a{}", (Object)costTenantIdMap.size());
        for (SqlParam sqlParam : sqlParamList) {
            Map<Long, List<ShareEntity>> costMap;
            BigDecimal bigDecimal = null == sqlParam.getValue() ? BigDecimal.ZERO : new BigDecimal(sqlParam.getValue());
            BigDecimal roleValue = ComputeUtil.safeDiv((BigDecimal)bigDecimal, (BigDecimal)new BigDecimal("100")).setScale(4, 4);
            List<Object> shareList = null == costTenantIdMap.get(sqlParam.getTenantId()) ? new ArrayList() : costTenantIdMap.get(sqlParam.getTenantId());
            if (CollectionUtils.isEmpty(shareList) || !MapUtil.isNotEmpty(costMap = shareList.stream().filter(t -> null != t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId)))) continue;
            for (Long projectId : costMap.keySet()) {
                List<ShareEntity> shareCost = costMap.get(projectId);
                if (null == shareCost || CollectionUtils.isEmpty(shareCost)) continue;
                ShareEntity shareEntity = shareCost.get(0);
                BigDecimal reduce = shareCost.stream().filter(e -> null != e.getCostMny()).map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                ProductionVO productionVO = (ProductionVO)data.get(projectId);
                BigDecimal productionTaxMny = null == productionVO ? BigDecimal.ZERO : (null == productionVO.getProductionTaxMny() ? BigDecimal.ZERO : productionVO.getProductionTaxMny());
                BigDecimal bigDecimal1 = ComputeUtil.safeMultiply((BigDecimal)productionTaxMny, (BigDecimal)roleValue);
                this.logger.info("--\u9879\u76eeid\uff1a{},\u9879\u76ee\u540d\u79f0\uff1a{},\u5b9e\u9645\u6210\u672c\u7d2f\u8ba1\uff1a{},\u4ea7\u503c\u62a5\u91cf\u7d2f\u8ba1\uff1a{},\u767e\u5206\u6bd4\uff1a{},\u767e\u5206\u6bd4\u540e\u4ea7\u503c\u62a5\u91cf\u7d2f\u8ba1\uff1a{}--", new Object[]{projectId, shareEntity.getProjectName(), reduce, productionTaxMny, roleValue, bigDecimal1});
                if (bigDecimal1.compareTo(BigDecimal.ZERO) <= 0 || reduce.compareTo(bigDecimal1) <= 0) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgId", shareEntity.getParentOrgId());
                map.put("orgName", shareEntity.getParentOrgName());
                map.put("tenantId", shareEntity.getTenantId());
                map.put("projectName", shareEntity.getProjectName());
                map.put("projectId", shareEntity.getId());
                map.put("warnLevel", sqlParam.getWarnLevel());
                mapList.add(map);
            }
        }
        return mapList;
    }

    class BillDetailCallable
    implements Callable<JSONObject> {
        private RequestAttributes context;
        private String billTypeCode;
        private String parameter;
        private String condition;
        private String authority;
        private String taxFlag;
        private String path;

        public BillDetailCallable(RequestAttributes context, String billTypeCode, String parameter, String condition, String authority, String taxFlag, String path) {
            this.context = context;
            this.billTypeCode = billTypeCode;
            this.parameter = parameter;
            this.condition = condition;
            this.authority = authority;
            this.taxFlag = taxFlag;
            this.path = path;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject jsonObject = new JSONObject();
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            List list = ShareServiceImpl.this.commenQueryFieldsService.queryBillList(this.billTypeCode, this.parameter, this.condition);
            List newsVos = null;
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                newsVos = BeanMapper.mapList((Iterable)list, ShareDetailVO.class);
                newsVos.forEach(e -> {
                    e.setBillType(this.billTypeCode);
                    if ("0".equals(this.taxFlag)) {
                        e.setHappenMny(e.getHappenTaxMny() == null ? BigDecimal.ZERO : e.getHappenTaxMny());
                    }
                    e.setRowState("add");
                    e.setId(e.getSourceId());
                    e.setPath(this.path);
                });
            }
            jsonObject.put("jsonRes", (Object)newsVos);
            return jsonObject;
        }
    }
}

