package com.ejianc.business.procost.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.procost.bean.UnitDetailEntity;
import com.ejianc.business.procost.service.IUnitDetailService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.UnitDetailVO;
import com.ejianc.business.procost.vo.UnitVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.procost.mapper.UnitMapper;
import com.ejianc.business.procost.bean.UnitEntity;
import com.ejianc.business.procost.service.IUnitService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 主材量价对比主表
 *
 * @author generator
 */
@Service("unitService")
public class UnitServiceImpl extends BaseServiceImpl<UnitMapper, UnitEntity> implements IUnitService {

    @Autowired
    private IUnitDetailService unitDetailService;

    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    /**
     * 批量进行保存
     *
     * @param voList 数据
     * @return 保存结果
     */
    @Override
    public List<UnitVO> saveUnitBatch(List<UnitVO> voList) {
        if (CollectionUtils.isEmpty(voList)) return voList;
        // 删除原来的数据
        baseMapper.deleteUnitAll();
        List<UnitEntity> entityList = new ArrayList<>();
        for (UnitVO vo : voList) {
            if (!"del".equals(vo.getRowState())) {
                entityList.add(BeanMapper.map(vo, UnitEntity.class));
            }
        }
        if (CollectionUtils.isNotEmpty(entityList)) super.saveOrUpdateBatch(entityList);
        return this.buildUnitTree(entityList);
    }

    /**
     * 批量保存子表数据
     *
     * @param detailList 子表数据
     * @return 保存结果
     */
    @Override
    public List<UnitDetailVO> saveUnitDetailBatch(List<UnitDetailVO> detailList) {
        if (CollectionUtils.isEmpty(detailList)) return detailList;
        // 子表父id相同，取第一个
        Long pid = detailList.get(0).getPid();
        baseMapper.deleteUnitDetailByPid(pid);
        List<UnitDetailEntity> detailEntityList = new ArrayList<>();
        for (UnitDetailVO detailVO : detailList) {
            if (!"del".equals(detailVO.getRowState())) {
                detailEntityList.add(BeanMapper.map(detailVO, UnitDetailEntity.class));
            }
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            unitDetailService.saveOrUpdateBatch(detailEntityList);
        }
        return BeanMapper.mapList(detailEntityList, UnitDetailVO.class);
    }

    /**
     * 查询列表
     *
     * @param param 查询条件
     * @return 查询结果
     */
    @Override
    public List<UnitVO> queryUnitList(QueryParam param) {
        List<UnitEntity> unitEntityList = super.queryList(param, false);
        List<UnitVO> voList = this.buildUnitTree(unitEntityList);
        return voList;
    }

    /**
     * 构建树
     *
     * @param unitEntityList 实体
     * @return 结果
     */
    private List<UnitVO> buildUnitTree(List<UnitEntity> unitEntityList) {
        return this.buildUnitTreeVo(BeanMapper.mapList(unitEntityList, UnitVO.class));
    }

    /**
     * 构建树
     *
     * @param voList 实体
     * @return 结果
     */
    private List<UnitVO> buildUnitTreeVo(List<UnitVO> voList){
        if (CollectionUtils.isNotEmpty(voList)) {
            return TreeNodeBUtil.buildTree(voList);
        }
        return new ArrayList<>();
    }

    /**
     * 根据父id查询字表列表
     *
     * @param pid 父ID
     * @return 查询结果
     */
    @Override
    public List<UnitDetailVO> queryUnitDetailByPid(Long pid) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, pid));
        List<UnitDetailEntity> list = unitDetailService.queryList(queryParam, false);
        return BeanMapper.mapList(list, UnitDetailVO.class);
    }

    /**
     * 查询末级及末级对应的子集列表
     *
     * @return 查询结果
     */
    @Override
    public Map<Long, List<UnitDetailVO>> queryUnitDetailMap() {
        Map<Long, List<UnitDetailVO>> rtnMap = new HashMap<>();
        // 查询所有父id
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentId", new Parameter(QueryParam.NE, null));
        List<UnitEntity> unitList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(unitList)) return rtnMap;
        List<Long> parentIdList = unitList.stream().map(UnitEntity::getParentId).collect(Collectors.toList());
        // 查询末级
        QueryParam cParam = new QueryParam();
        cParam.getParams().put("id", new Parameter(QueryParam.NOT_IN, parentIdList));
        List<UnitEntity> cList = super.queryList(cParam, false);
        if (CollectionUtils.isEmpty(cList)) return rtnMap;
        List<Long> idList = cList.stream().map(UnitEntity::getId).collect(Collectors.toList());
        // 查询子集
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("pid", new Parameter(QueryParam.IN, idList));
        List<UnitDetailEntity> detailList = unitDetailService.queryList(detailParam, false);
        if (CollectionUtils.isEmpty(detailList)) return rtnMap;
        List<UnitDetailVO> detailVoList = BeanMapper.mapList(detailList, UnitDetailVO.class);
        rtnMap = detailVoList.stream().collect(Collectors.groupingBy(UnitDetailVO::getPid));
        return rtnMap;
    }

    /**
     * 将传过来的列表组装成树
     *
     * @param voList 页面数据
     * @return 树形
     */
    @Override
    public List<UnitVO> packUnitTree(List<UnitVO> voList) {
        if (CollectionUtils.isEmpty(voList)) return voList;
        List<Long> ids = voList.stream().map(UnitVO::getId).collect(Collectors.toList());
        // 添加父级
        List<String> innerCodeList = voList.stream().map(UnitVO::getInnerCode).collect(Collectors.toList());
        List<Long> innerCodes = new ArrayList<>();
        innerCodeList.forEach(x -> {
            if (StringUtils.isNotEmpty(x)) {
                innerCodes.addAll(Arrays.stream(x.split(",")).map(Long::valueOf).filter(y -> !ids.contains(y))
                        .collect(Collectors.toList()));
            }
        });
        if (CollectionUtils.isNotEmpty(innerCodes)) {
            QueryParam shareParam = new QueryParam();
            shareParam.getParams().put("id", new Parameter(QueryParam.IN, innerCodes));
            CommonResponse<List<SubjectOrgVO>> response = shareSubjectOrgApi.querySubjectOrg(shareParam);
            if (!response.isSuccess()) {
                throw new BusinessException("查询父级信息失败！");
            }
            List<SubjectOrgVO> resList = response.getData();
            for (SubjectOrgVO subjectOrgVO : resList) {
                UnitVO unitVO = new UnitVO();
                unitVO.setId(subjectOrgVO.getId());
                unitVO.setSubjectName(subjectOrgVO.getSubjectName());
                unitVO.setSubjectCode(subjectOrgVO.getSubjectCode());
                unitVO.setMemo(subjectOrgVO.getMemo());
                unitVO.setOrgSubjectId(subjectOrgVO.getId());
                unitVO.setParentId(subjectOrgVO.getParentId());
                unitVO.setInnerCode(subjectOrgVO.getInnerCode());
                voList.add(unitVO);
            }
            ids.addAll(innerCodes);
        }
        return this.buildUnitTreeVo(voList);
    }
}
