/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.procost.bean.UnitDetailEntity;
import com.ejianc.business.procost.bean.UnitEntity;
import com.ejianc.business.procost.mapper.UnitMapper;
import com.ejianc.business.procost.service.IUnitDetailService;
import com.ejianc.business.procost.service.IUnitService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.UnitDetailVO;
import com.ejianc.business.procost.vo.UnitVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="unitService")
public class UnitServiceImpl
extends BaseServiceImpl<UnitMapper, UnitEntity>
implements IUnitService {
    @Autowired
    private IUnitDetailService unitDetailService;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    @Override
    public List<UnitVO> saveUnitBatch(List<UnitVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return voList;
        }
        ((UnitMapper)this.baseMapper).deleteUnitAll();
        ArrayList<UnitEntity> entityList = new ArrayList<UnitEntity>();
        for (UnitVO vo : voList) {
            if ("del".equals(vo.getRowState())) continue;
            entityList.add((UnitEntity)((Object)BeanMapper.map((Object)vo, UnitEntity.class)));
        }
        if (CollectionUtils.isNotEmpty(entityList)) {
            super.saveOrUpdateBatch(entityList);
        }
        return this.buildUnitTree(entityList);
    }

    @Override
    public List<UnitDetailVO> saveUnitDetailBatch(List<UnitDetailVO> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return detailList;
        }
        Long pid = detailList.get(0).getPid();
        ((UnitMapper)this.baseMapper).deleteUnitDetailByPid(pid);
        ArrayList<Object> detailEntityList = new ArrayList<Object>();
        for (UnitDetailVO detailVO : detailList) {
            if ("del".equals(detailVO.getRowState())) continue;
            detailEntityList.add(BeanMapper.map((Object)detailVO, UnitDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            this.unitDetailService.saveOrUpdateBatch(detailEntityList);
        }
        return BeanMapper.mapList(detailEntityList, UnitDetailVO.class);
    }

    @Override
    public List<UnitVO> queryUnitList(QueryParam param) {
        List unitEntityList = super.queryList(param, false);
        List<UnitVO> voList = this.buildUnitTree(unitEntityList);
        return voList;
    }

    private List<UnitVO> buildUnitTree(List<UnitEntity> unitEntityList) {
        return this.buildUnitTreeVo(BeanMapper.mapList(unitEntityList, UnitVO.class));
    }

    private List<UnitVO> buildUnitTreeVo(List<UnitVO> voList) {
        if (CollectionUtils.isNotEmpty(voList)) {
            return TreeNodeBUtil.buildTree(voList);
        }
        return new ArrayList<UnitVO>();
    }

    @Override
    public List<UnitDetailVO> queryUnitDetailByPid(Long pid) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)pid));
        List list = this.unitDetailService.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)list, UnitDetailVO.class);
    }

    @Override
    public Map<Long, List<UnitDetailVO>> queryUnitDetailMap() {
        Map<Long, List<UnitDetailVO>> rtnMap = new HashMap<Long, List<UnitDetailVO>>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentId", new Parameter("ne", null));
        List unitList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            return rtnMap;
        }
        List parentIdList = unitList.stream().map(UnitEntity::getParentId).collect(Collectors.toList());
        QueryParam cParam = new QueryParam();
        cParam.getParams().put("id", new Parameter("not_in", parentIdList));
        List cList = super.queryList(cParam, false);
        if (CollectionUtils.isEmpty((Collection)cList)) {
            return rtnMap;
        }
        List idList = cList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("pid", new Parameter("in", idList));
        List detailList = this.unitDetailService.queryList(detailParam, false);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return rtnMap;
        }
        List detailVoList = BeanMapper.mapList((Iterable)detailList, UnitDetailVO.class);
        rtnMap = detailVoList.stream().collect(Collectors.groupingBy(UnitDetailVO::getPid));
        return rtnMap;
    }

    @Override
    public List<UnitVO> packUnitTree(List<UnitVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return voList;
        }
        List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<String> innerCodeList = voList.stream().map(UnitVO::getInnerCode).collect(Collectors.toList());
        ArrayList innerCodes = new ArrayList();
        innerCodeList.forEach(x -> {
            if (StringUtils.isNotEmpty((CharSequence)x)) {
                innerCodes.addAll(Arrays.stream(x.split(",")).map(Long::valueOf).filter(y -> !ids.contains(y)).collect(Collectors.toList()));
            }
        });
        if (CollectionUtils.isNotEmpty(innerCodes)) {
            QueryParam shareParam = new QueryParam();
            shareParam.getParams().put("id", new Parameter("in", innerCodes));
            CommonResponse response = this.shareSubjectOrgApi.querySubjectOrg(shareParam);
            if (!response.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7236\u7ea7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List resList = (List)response.getData();
            for (SubjectOrgVO subjectOrgVO : resList) {
                UnitVO unitVO = new UnitVO();
                unitVO.setId(subjectOrgVO.getId());
                unitVO.setSubjectName(subjectOrgVO.getSubjectName());
                unitVO.setSubjectCode(subjectOrgVO.getSubjectCode());
                unitVO.setMemo(subjectOrgVO.getMemo());
                unitVO.setOrgSubjectId(subjectOrgVO.getId());
                unitVO.setParentId(subjectOrgVO.getParentId());
                unitVO.setInnerCode(subjectOrgVO.getInnerCode());
                voList.add(unitVO);
            }
            ids.addAll(innerCodes);
        }
        return this.buildUnitTreeVo(voList);
    }
}

