package com.ejianc.business.procost.controller;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.procost.bean.ShareDetailEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.util.DateUtil;
import com.ejianc.business.procost.vo.ShareDetailVO;
import com.ejianc.business.procost.vo.SqlParam;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 成本分摊费用明细
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("warnTiming")
public class WarnTimingController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IShareService shareService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;

    /**
     *  定时预警--实际成本未归集
     */
    @RequestMapping(value = "/notCollectionTimingWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> notCollectionTimingWarn(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        //获取时间
        Date date = new Date();
        Date oneDate = DateUtil.setDays(date, 1);
        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
        Date oldDate = DateUtil.addMonths(oneDate, -1);
        String s = DateFormatUtil.formatDate("yyyy-MM", oldDate);
        //租户分组后的项目
        Map<Long,List<ProjectPoolSetVO>> projectMap = new HashMap<>();
        CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectPoolList(null, null, null);
        if(jsonArrayCommonResponse.isSuccess() && null!=jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty(jsonArrayCommonResponse.getData())){
            JSONArray data = jsonArrayCommonResponse.getData();
            List<ProjectPoolSetVO> projectData = JSONObject.parseArray(data.toJSONString(), ProjectPoolSetVO.class);
            projectMap = projectData.stream().filter(t -> null != t.getTenantId()).collect(Collectors.groupingBy(ProjectPoolSetVO::getTenantId));
            if(null==projectMap){
                projectMap = new HashMap<>();
            }
            logger.info("项目信息条数：{}",projectData.size());
        }
        //获取实际成本
        LambdaQueryWrapper<ShareEntity> lambda = new LambdaQueryWrapper<ShareEntity>();
        lambda.eq(ShareEntity::getPeriod,s);
        lambda.eq(ShareEntity::getDr, BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ShareEntity> list = shareService.list(lambda);
        logger.info("成本条数：{}",list.size());
        //按照租户id分组
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t->null!=t.getTenantId()).collect(Collectors.groupingBy(ShareEntity::getTenantId));
        logger.info("成本租户分组条数：{}",costTenantIdMap.size());
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
// 1、根据租户合同纬度，查询合同
// 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
// 3、根据预警设置判断该合同数据属于哪个等级
// 4、符合等级，则拼接预警数据，并保存到 list
// 5、发送数据
//获取项目
            List<ProjectPoolSetVO> projectPoolSetVOS = projectMap.get(tenantId);
            if (null!=projectPoolSetVOS && ListUtil.isNotEmpty(projectPoolSetVOS)) {
                for (ProjectPoolSetVO projectPoolSetVO : projectPoolSetVOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = projectPoolSetVO.getProjectDepartmentId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = orgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        //按照项目分组
                        List<ShareEntity> shareList = null==costTenantIdMap.get(tenantId) ? new ArrayList<>(): costTenantIdMap.get(tenantId);
                        Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
                        List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            Integer day = set.getIntValue("parameterValue");
                            logger.info("当前日期：{},当前月第一天日期：{}，差值：{},上一个月：{},隔天数：{},租户id:{}",DateFormatUtil.formatDate("yyyy-MM-dd",date), DateFormatUtil.formatDate("yyyy-MM-dd",oneDate),betweenDays,s,day,tenantId);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day) && (null==shareEntities || CollectionUtils.isEmpty(shareEntities))){
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day) && (null==shareEntities || CollectionUtils.isEmpty(shareEntities))){
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day) && (null==shareEntities || CollectionUtils.isEmpty(shareEntities))){
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +projectPoolSetVO.getName());
                            vo.setPcTitle("成本归集单");
//                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(projectPoolSetVO.getOrgId());
//发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(projectPoolSetVO.getOrgId()+"");
                            vo.setOrgName(projectPoolSetVO.getOrgName());
                            vo.setSourceId(projectPoolSetVO.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(projectPoolSetVO.getName()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(projectPoolSetVO.getName()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(projectPoolSetVO.getName()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
//        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
//        if(!warnResp.isSuccess()) {
//            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
//            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
//        }
        return CommonResponse.success("任务接受处理成功！"+JSONObject.toJSONString(warnList));
    }
    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("成本归集单"+"-"+ String.valueOf(m.get("projectName")));
            vo.setPcTitle("成本归集单");
//            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(strLon(m.get("orgId")));
            vo.setOrgName(String.valueOf(m.get("orgName")));
            vo.setSourceId(String.valueOf(m.get("projectId")));
            vo.setTenantId(strLon(m.get("tenantId")));
            vo.setWarnLevel(String.valueOf(m.get("warnLevel")));
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#",String.valueOf(m.get("projectName")))
            );
            resp.add(vo);
        }
        logger.info("发送预警参数：{}", JSONObject.toJSONString(resp));
        return resp;
    }
    private Long strLon(Object obj) {
        if(null==obj){
            return null;
        }
        String s = obj.toString();
        if(StringUtils.isEmpty(s)){
            return null;
        }
        return Long.valueOf(s);
    }


    /**
     *  定时预警--累计实际成本超过累计产值
     */
    @RequestMapping(value = "/costOutputTimingWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> costOutputTimingWarn(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        //获取产值报量
        Map<Long, ProductionVO> data = new HashMap<>();
        CommonResponse<Map<Long, ProductionVO>> mapCommonResponse = proincomeContractApi.queryTotalProduction();
        logger.info("产值报量api结果：{}",mapCommonResponse.getMsg());
        if(mapCommonResponse.isSuccess() && null!=mapCommonResponse.getData()){
            data = mapCommonResponse.getData();
        }
        logger.info("产值报量条数：{}",data.size());
        Map<Long, ProjectPoolSetVO> projectMap = new HashMap<>();
        CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectPoolList(null, null, null);
        logger.info("项目池api结果：{}",jsonArrayCommonResponse.getMsg());
        if(jsonArrayCommonResponse.isSuccess() && null!=jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty(jsonArrayCommonResponse.getData())){
            JSONArray jsonArray = jsonArrayCommonResponse.getData();
            List<ProjectPoolSetVO> projectData = JSONObject.parseArray(jsonArray.toJSONString(), ProjectPoolSetVO.class);
            projectMap = projectData.stream().filter(t -> null != t.getId()).collect(Collectors.toMap(ProjectPoolSetVO::getId, item -> item, (v1, v2) -> v2));
        }
        logger.info("项目信息条数：{}",projectMap.size());
        //获取实际成本
        LambdaQueryWrapper<ShareEntity> lambda = new LambdaQueryWrapper<ShareEntity>();
        lambda.eq(ShareEntity::getDr, BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ShareEntity> list = shareService.list(lambda);
        logger.info("成本条数：{}",list.size());
        //按照租户id分组
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t->null!=t.getTenantId()).collect(Collectors.groupingBy(ShareEntity::getTenantId));
        logger.info("成本租户分组条数：{}",costTenantIdMap.size());
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
// 1、根据租户合同纬度，查询合同
// 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
// 3、根据预警设置判断该合同数据属于哪个等级
// 4、符合等级，则拼接预警数据，并保存到 list
// 5、发送数据
//获取项目
            List<ShareEntity> shareEntityList = costTenantIdMap.get(tenantId);
            //按照项目分组
            List<ShareEntity> shareList = null==shareEntityList ? new ArrayList<>(): shareEntityList;
            if(CollectionUtils.isEmpty(shareList)){
                continue;
            }
            Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
            if (MapUtil.isNotEmpty(costMap)) {
                for (Long projectId : costMap.keySet()) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    List<ShareEntity> shareCost = costMap.get(projectId);
                    if(null==shareCost || CollectionUtils.isEmpty(shareCost)){
                        continue;
                    }
                    Long orgId = shareCost.get(0).getOrgId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = orgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        //按照项目分组
                        ProjectPoolSetVO projectPoolSetVO = projectMap.get(projectId);
                        ShareEntity shareEntity = shareCost.get(0);
                        //累计实际成本
                        BigDecimal costMny = shareCost.stream().filter(e -> null!= e.getCostMny()).map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                        ProductionVO productionVO = data.get(projectId);
                        //累计产值报量金额
                        BigDecimal productionTaxMny =null==productionVO ? BigDecimal.ZERO : (null==productionVO.getProductionTaxMny() ? BigDecimal.ZERO:productionVO.getProductionTaxMny());
                        Long parentOrgId = null==projectPoolSetVO ? shareEntity.getParentOrgId():projectPoolSetVO.getOrgId();
                        String parentOrgName = null==projectPoolSetVO ? shareEntity.getParentOrgName():projectPoolSetVO.getOrgName();
                        List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            //参数值
                            BigDecimal bigDecimal = null ==set.getBigDecimal("parameterValue")? BigDecimal.ZERO: ComputeUtil.safeDiv(set.getBigDecimal("parameterValue"), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                            //百分比后的产值报量金额
                            BigDecimal bigDecimal1 = ComputeUtil.safeMultiply(productionTaxMny, bigDecimal);
                            logger.info("--项目id：{},项目名称：{},实际成本累计：{},产值报量累计：{},百分比：{},百分比后产值报量累计：{}--",projectId,shareEntity.getProjectName(),costMny,productionTaxMny,bigDecimal,bigDecimal1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if(bigDecimal1.compareTo(BigDecimal.ZERO)>0 && costMny.compareTo(bigDecimal1)>0){
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if(bigDecimal1.compareTo(BigDecimal.ZERO)>0 && costMny.compareTo(bigDecimal1)>0){
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if(bigDecimal1.compareTo(BigDecimal.ZERO)>0 && costMny.compareTo(bigDecimal1)>0){
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +projectPoolSetVO.getName());
                            vo.setPcTitle("成本归集单");
//                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(projectPoolSetVO.getOrgId());
//发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(projectPoolSetVO.getOrgId()+"");
                            vo.setOrgName(projectPoolSetVO.getOrgName());
                            vo.setSourceId(projectPoolSetVO.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(projectPoolSetVO.getName()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(projectPoolSetVO.getName()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(projectPoolSetVO.getName()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
//        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
//        if(!warnResp.isSuccess()) {
//            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
//            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
//        }
        return CommonResponse.success("任务接受处理成功！"+JSONObject.toJSONString(warnList));
    }

}
