package com.ejianc.business.procost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procost.bean.ReportDetailEntity;
/**
 * 成本分析报告
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procost_report")
public class ReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="project_code")
    private String projectCode; // 项目部编码
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="structure_type")
    private Long structureType; // 结构形式
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 成本类别Id
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 成本类别名称
    @TableField(value="contract_file_path")
    private String contractFilePath; // 合同附件路径
    @TableField(value="contract_file_id")
    private Long contractFileId; // 合同附件Id
    @TableField(value="contract_template_id")
    private Long contractTemplateId; // 合同模板Id
    @TableField(value="contract_template_name")
    private String contractTemplateName; // 合同模板名称
    @TableField(value="def1")
    private String def1; // 工程成本分析节点设置
    @TableField(value="contract_id")
    private Long contractId; // 合同Id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="nic_contract_mny")
    private BigDecimal nicContractMny; // 工程造价调整后总金额(不含暂列金额)
    @TableField(value="contract_valuation_type")
    private Long contractValuationType; // 合同计价形式
    @TableField(value="contract_base_tax_mny")
    private BigDecimal contractBaseTaxMny; // 签约合同价（含税）
    @TableField(value="contract_base_mny")
    private BigDecimal contractBaseMny; // 其中不含税金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 其中增值税
    @TableField(value="provisional_mny")
    private BigDecimal provisionalMny; // 暂列金额（无税）
    @TableField(value="engineering_type_id")
    private Long engineeringTypeId; // 工程类别Id
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类别名称
    @TableField(value="built_area")
    private BigDecimal builtArea; // 建筑面积(㎡)
    @TableField(value="contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value="start_date")
    private Date startDate; // 合同开工日期
    @TableField(value="end_date")
    private Date endDate; // 合同竣工日期
    @TableField(value="funds_source_id")
    private Long fundsSourceId; // 资金来源(自定义档案)
    @TableField(value="funds_source")
    private String fundsSource; // 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
    @TableField(value="address")
    private String address; // 项目地址
    @TableField(value="report_date")
    private Date reportDate; // 本次截止日期
    @TableField(value="completion")
    private String completion; // 工程进度已完成情况
    @TableField(value="srcztj_mny")
    private BigDecimal srcztjMny; // 收入产值统计（无税）
    @TableField(value="mbcbtj_mny")
    private BigDecimal mbcbtjMny; // 目标成本统计（无税）
    @TableField(value="sjcbtj_mny")
    private BigDecimal sjcbtjMny; // 实际成本（无税）
    @TableField(value="srsj_rate")
    private BigDecimal srsjRate;
    @TableField(value="mbsj_rate")
    private BigDecimal mbsjRate;
    @TableField(value="material_income_mny")
    private BigDecimal materialIncomeMny; // 材料费收入产值
    @TableField(value="material_targetcost_mny")
    private BigDecimal materialTargetcostMny; // 目标成本
    @TableField(value="material_cost_mny")
    private BigDecimal materialCostMny; // 实际成本
    @TableField(value="material_srsj_mny")
    private BigDecimal materialSrsjMny; // 收入实际对比盈亏（±）
    @TableField(value="material_mbsj_mny")
    private BigDecimal materialMbsjMny; // 目标实际对比盈亏（±）
    @TableField(value="gj_income_num")
    private BigDecimal gjIncomeNum; // 预算收入用量
    @TableField(value="gj_targetcost_num")
    private BigDecimal gjTargetcostNum; // 目标成本用量
    @TableField(value="gj_cost_num")
    private BigDecimal gjCostNum; // 实际成本用量
    @TableField(value="gj_srsj_num")
    private BigDecimal gjSrsjNum; // 收入实际用量对比盈亏（±）
    @TableField(value="gj_mbsj_num")
    private BigDecimal gjMbsjNum; // 目标实际用量对比盈亏（±）
    @TableField(value="gj_income_mny")
    private BigDecimal gjIncomeMny; // 预算收入金额
    @TableField(value="gj_targetcost_mny")
    private BigDecimal gjTargetcostMny; // 目标成本金额
    @TableField(value="gj_cost_mny")
    private BigDecimal gjCostMny; // 实际成本金额
    @TableField(value="gj_srsj_mny")
    private BigDecimal gjSrsjMny; // 收入实际金额对比盈亏（±）
    @TableField(value="gj_mbsj_mny")
    private BigDecimal gjMbsjMny; // 目标实际金额对比盈亏（±）
    @TableField(value="spt_income_num")
    private BigDecimal sptIncomeNum; // 预算收入用量
    @TableField(value="spt_targetcost_num")
    private BigDecimal sptTargetcostNum; // 目标成本用量
    @TableField(value="spt_cost_num")
    private BigDecimal sptCostNum; // 实际成本用量
    @TableField(value="spt_srsj_num")
    private BigDecimal sptSrsjNum; // 收入实际用量对比盈亏（±）
    @TableField(value="spt_mbsj_num")
    private BigDecimal sptMbsjNum; // 目标实际用量对比盈亏（±）
    @TableField(value="spt_income_mny")
    private BigDecimal sptIncomeMny; // 预算收入金额
    @TableField(value="spt_targetcost_mny")
    private BigDecimal sptTargetcostMny; // 目标成本金额
    @TableField(value="spt_cost_mny")
    private BigDecimal sptCostMny; // 实际成本金额
    @TableField(value="spt_srsj_mny")
    private BigDecimal sptSrsjMny; // 收入实际金额对比盈亏（±）
    @TableField(value="spt_mbsj_mny")
    private BigDecimal sptMbsjMny; // 目标实际金额对比盈亏（±）
    @TableField(value="sub_income_mny")
    private BigDecimal subIncomeMny; // 分包预算收入金额
    @TableField(value="sub_targetcost_mny")
    private BigDecimal subTargetcostMny; // 目标成本金额
    @TableField(value="sub_cost_mny")
    private BigDecimal subCostMny; // 实际成本金额
    @TableField(value="sub_srsj_mny")
    private BigDecimal subSrsjMny; // 收入实际金额对比盈亏（±）
    @TableField(value="sub_mbsj_mny")
    private BigDecimal subMbsjMny; // 目标实际金额对比盈亏（±）
    @TableField(value="jjf_income_mny")
    private BigDecimal jjfIncomeMny; // 预算收入金额
    @TableField(value="jjf_targetcost_mny")
    private BigDecimal jjfTargetcostMny; // 目标成本金额
    @TableField(value="jjf_cost_mny")
    private BigDecimal jjfCostMny; // 实际成本金额
    @TableField(value="jjf_srsj_mny")
    private BigDecimal jjfSrsjMny; // 收入实际金额对比盈亏（±）
    @TableField(value="jjf_mbsj_mny")
    private BigDecimal jjfMbsjMny; // 目标实际金额对比盈亏（±）
    @TableField(value="sj_income_mny")
    private BigDecimal sjIncomeMny; // 业主确认税金
    @TableField(value="sj_targetcost_mny")
    private BigDecimal sjTargetcostMny; // 目标税金
    @TableField(value="sj_cost_mny")
    private BigDecimal sjCostMny; // 实际税金
    @TableField(value="sj_mny")
    private BigDecimal sjMny; // 累计税负
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="reportDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<ReportDetailEntity> reportDetailList = new ArrayList<>(); // 成本分析报告明细


    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getSrsjRate() {
        return srsjRate;
    }

    public void setSrsjRate(BigDecimal srsjRate) {
        this.srsjRate = srsjRate;
    }

    public BigDecimal getMbsjRate() {
        return mbsjRate;
    }

    public void setMbsjRate(BigDecimal mbsjRate) {
        this.mbsjRate = mbsjRate;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }
    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }
    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }
    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getContractBaseTaxMny() {
        return contractBaseTaxMny;
    }

    public void setContractBaseTaxMny(BigDecimal contractBaseTaxMny) {
        this.contractBaseTaxMny = contractBaseTaxMny;
    }
    public BigDecimal getContractBaseMny() {
        return contractBaseMny;
    }

    public void setContractBaseMny(BigDecimal contractBaseMny) {
        this.contractBaseMny = contractBaseMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public String getCompletion() {
        return completion;
    }

    public void setCompletion(String completion) {
        this.completion = completion;
    }
    public BigDecimal getSrcztjMny() {
        return srcztjMny;
    }

    public void setSrcztjMny(BigDecimal srcztjMny) {
        this.srcztjMny = srcztjMny;
    }
    public BigDecimal getMbcbtjMny() {
        return mbcbtjMny;
    }

    public void setMbcbtjMny(BigDecimal mbcbtjMny) {
        this.mbcbtjMny = mbcbtjMny;
    }
    public BigDecimal getSjcbtjMny() {
        return sjcbtjMny;
    }

    public void setSjcbtjMny(BigDecimal sjcbtjMny) {
        this.sjcbtjMny = sjcbtjMny;
    }
    public BigDecimal getMaterialIncomeMny() {
        return materialIncomeMny;
    }

    public void setMaterialIncomeMny(BigDecimal materialIncomeMny) {
        this.materialIncomeMny = materialIncomeMny;
    }
    public BigDecimal getMaterialTargetcostMny() {
        return materialTargetcostMny;
    }

    public void setMaterialTargetcostMny(BigDecimal materialTargetcostMny) {
        this.materialTargetcostMny = materialTargetcostMny;
    }
    public BigDecimal getMaterialCostMny() {
        return materialCostMny;
    }

    public void setMaterialCostMny(BigDecimal materialCostMny) {
        this.materialCostMny = materialCostMny;
    }
    public BigDecimal getMaterialSrsjMny() {
        return materialSrsjMny;
    }

    public void setMaterialSrsjMny(BigDecimal materialSrsjMny) {
        this.materialSrsjMny = materialSrsjMny;
    }
    public BigDecimal getMaterialMbsjMny() {
        return materialMbsjMny;
    }

    public void setMaterialMbsjMny(BigDecimal materialMbsjMny) {
        this.materialMbsjMny = materialMbsjMny;
    }
    public BigDecimal getGjIncomeNum() {
        return gjIncomeNum;
    }

    public void setGjIncomeNum(BigDecimal gjIncomeNum) {
        this.gjIncomeNum = gjIncomeNum;
    }
    public BigDecimal getGjTargetcostNum() {
        return gjTargetcostNum;
    }

    public void setGjTargetcostNum(BigDecimal gjTargetcostNum) {
        this.gjTargetcostNum = gjTargetcostNum;
    }
    public BigDecimal getGjCostNum() {
        return gjCostNum;
    }

    public void setGjCostNum(BigDecimal gjCostNum) {
        this.gjCostNum = gjCostNum;
    }
    public BigDecimal getGjSrsjNum() {
        return gjSrsjNum;
    }

    public void setGjSrsjNum(BigDecimal gjSrsjNum) {
        this.gjSrsjNum = gjSrsjNum;
    }
    public BigDecimal getGjMbsjNum() {
        return gjMbsjNum;
    }

    public void setGjMbsjNum(BigDecimal gjMbsjNum) {
        this.gjMbsjNum = gjMbsjNum;
    }
    public BigDecimal getGjIncomeMny() {
        return gjIncomeMny;
    }

    public void setGjIncomeMny(BigDecimal gjIncomeMny) {
        this.gjIncomeMny = gjIncomeMny;
    }
    public BigDecimal getGjTargetcostMny() {
        return gjTargetcostMny;
    }

    public void setGjTargetcostMny(BigDecimal gjTargetcostMny) {
        this.gjTargetcostMny = gjTargetcostMny;
    }
    public BigDecimal getGjCostMny() {
        return gjCostMny;
    }

    public void setGjCostMny(BigDecimal gjCostMny) {
        this.gjCostMny = gjCostMny;
    }
    public BigDecimal getGjSrsjMny() {
        return gjSrsjMny;
    }

    public void setGjSrsjMny(BigDecimal gjSrsjMny) {
        this.gjSrsjMny = gjSrsjMny;
    }
    public BigDecimal getGjMbsjMny() {
        return gjMbsjMny;
    }

    public void setGjMbsjMny(BigDecimal gjMbsjMny) {
        this.gjMbsjMny = gjMbsjMny;
    }
    public BigDecimal getSptIncomeNum() {
        return sptIncomeNum;
    }

    public void setSptIncomeNum(BigDecimal sptIncomeNum) {
        this.sptIncomeNum = sptIncomeNum;
    }
    public BigDecimal getSptTargetcostNum() {
        return sptTargetcostNum;
    }

    public void setSptTargetcostNum(BigDecimal sptTargetcostNum) {
        this.sptTargetcostNum = sptTargetcostNum;
    }
    public BigDecimal getSptCostNum() {
        return sptCostNum;
    }

    public void setSptCostNum(BigDecimal sptCostNum) {
        this.sptCostNum = sptCostNum;
    }
    public BigDecimal getSptSrsjNum() {
        return sptSrsjNum;
    }

    public void setSptSrsjNum(BigDecimal sptSrsjNum) {
        this.sptSrsjNum = sptSrsjNum;
    }
    public BigDecimal getSptMbsjNum() {
        return sptMbsjNum;
    }

    public void setSptMbsjNum(BigDecimal sptMbsjNum) {
        this.sptMbsjNum = sptMbsjNum;
    }
    public BigDecimal getSptIncomeMny() {
        return sptIncomeMny;
    }

    public void setSptIncomeMny(BigDecimal sptIncomeMny) {
        this.sptIncomeMny = sptIncomeMny;
    }
    public BigDecimal getSptTargetcostMny() {
        return sptTargetcostMny;
    }

    public void setSptTargetcostMny(BigDecimal sptTargetcostMny) {
        this.sptTargetcostMny = sptTargetcostMny;
    }
    public BigDecimal getSptCostMny() {
        return sptCostMny;
    }

    public void setSptCostMny(BigDecimal sptCostMny) {
        this.sptCostMny = sptCostMny;
    }
    public BigDecimal getSptSrsjMny() {
        return sptSrsjMny;
    }

    public void setSptSrsjMny(BigDecimal sptSrsjMny) {
        this.sptSrsjMny = sptSrsjMny;
    }
    public BigDecimal getSptMbsjMny() {
        return sptMbsjMny;
    }

    public void setSptMbsjMny(BigDecimal sptMbsjMny) {
        this.sptMbsjMny = sptMbsjMny;
    }
    public BigDecimal getSubIncomeMny() {
        return subIncomeMny;
    }

    public void setSubIncomeMny(BigDecimal subIncomeMny) {
        this.subIncomeMny = subIncomeMny;
    }
    public BigDecimal getSubTargetcostMny() {
        return subTargetcostMny;
    }

    public void setSubTargetcostMny(BigDecimal subTargetcostMny) {
        this.subTargetcostMny = subTargetcostMny;
    }
    public BigDecimal getSubCostMny() {
        return subCostMny;
    }

    public void setSubCostMny(BigDecimal subCostMny) {
        this.subCostMny = subCostMny;
    }
    public BigDecimal getSubSrsjMny() {
        return subSrsjMny;
    }

    public void setSubSrsjMny(BigDecimal subSrsjMny) {
        this.subSrsjMny = subSrsjMny;
    }
    public BigDecimal getSubMbsjMny() {
        return subMbsjMny;
    }

    public void setSubMbsjMny(BigDecimal subMbsjMny) {
        this.subMbsjMny = subMbsjMny;
    }
    public BigDecimal getJjfIncomeMny() {
        return jjfIncomeMny;
    }

    public void setJjfIncomeMny(BigDecimal jjfIncomeMny) {
        this.jjfIncomeMny = jjfIncomeMny;
    }
    public BigDecimal getJjfTargetcostMny() {
        return jjfTargetcostMny;
    }

    public void setJjfTargetcostMny(BigDecimal jjfTargetcostMny) {
        this.jjfTargetcostMny = jjfTargetcostMny;
    }
    public BigDecimal getJjfCostMny() {
        return jjfCostMny;
    }

    public void setJjfCostMny(BigDecimal jjfCostMny) {
        this.jjfCostMny = jjfCostMny;
    }
    public BigDecimal getJjfSrsjMny() {
        return jjfSrsjMny;
    }

    public void setJjfSrsjMny(BigDecimal jjfSrsjMny) {
        this.jjfSrsjMny = jjfSrsjMny;
    }
    public BigDecimal getJjfMbsjMny() {
        return jjfMbsjMny;
    }

    public void setJjfMbsjMny(BigDecimal jjfMbsjMny) {
        this.jjfMbsjMny = jjfMbsjMny;
    }
    public BigDecimal getSjIncomeMny() {
        return sjIncomeMny;
    }

    public void setSjIncomeMny(BigDecimal sjIncomeMny) {
        this.sjIncomeMny = sjIncomeMny;
    }
    public BigDecimal getSjTargetcostMny() {
        return sjTargetcostMny;
    }

    public void setSjTargetcostMny(BigDecimal sjTargetcostMny) {
        this.sjTargetcostMny = sjTargetcostMny;
    }
    public BigDecimal getSjCostMny() {
        return sjCostMny;
    }

    public void setSjCostMny(BigDecimal sjCostMny) {
        this.sjCostMny = sjCostMny;
    }
    public BigDecimal getSjMny() {
        return sjMny;
    }

    public void setSjMny(BigDecimal sjMny) {
        this.sjMny = sjMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    public List<ReportDetailEntity> getReportDetailList() {
        return reportDetailList;
    }

    public void setReportDetailList(List<ReportDetailEntity> reportDetailList) {
        this.reportDetailList = reportDetailList;
    }
}
