package com.ejianc.business.procost.mapper;

import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.vo.MonthVO;
import com.ejianc.business.procost.vo.SubjectReportAllsVO;
import com.ejianc.business.procost.vo.SubjectReportVO;
import com.ejianc.business.procost.vo.SubjectReportsVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 成本分摊
 * 
 * @author generator
 * 
 */
@Mapper
public interface ShareMapper extends BaseCrudMapper<ShareEntity> {

    List<MonthVO> geMonths(@Param("projectId") Long projectId,@Param("year") String year);

    List<SubjectReportsVO> getSubjectReport(@Param("projectId") Long projectId, @Param("period") String period, @Param("flag") int flag,@Param("wbsIdList") List<Long> wbsIdList);

    List<SubjectReportsVO> getCostDetails(@Param("projectId") Long projectId);

    List<SubjectReportVO> getCostSetting(@Param("projectId") Long projectId);


    List<SubjectReportsVO> getCostAllDetails(@Param("projectId") Long projectId,@Param("beginPeriod") String beginPeriod,@Param("endPeriod") String endPeriod);

    List<SubjectReportsVO> getCostDetail(@Param("projectId") Long projectId,@Param("beginPeriod") String beginPeriod,@Param("endPeriod") String endPeriod);

    List<SubjectReportsVO> getCostDetailUnit(@Param("projectId") Long projectId,@Param("beginPeriod") String beginPeriod,@Param("endPeriod") String endPeriod);

    List<SubjectReportsVO> getDetailsBySubjectId(@Param("projectId") Long projectId,@Param("beginPeriod") String beginPeriod,@Param("endPeriod") String endPeriod,@Param("subjectIdList") List<Long> subjectIdList);

    List<SubjectReportsVO> getDetailsByWbsId(@Param("projectId") Long projectId,@Param("beginPeriod") String beginPeriod,@Param("endPeriod") String endPeriod,@Param("subjectIdList") List<Long> subjectIdList,@Param("wbsId") Long wbsId);
}
