/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.mapper.CostDetailMapper;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costDetailService")
public class CostDetailServiceImpl
extends BaseServiceImpl<CostDetailMapper, CostDetailEntity>
implements ICostDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectSetApi;

    @Override
    public boolean deleteCostDetail(Long id) {
        return ((CostDetailMapper)this.baseMapper).deleteCostDetail(id);
    }

    @Override
    public CommonResponse<BigDecimal> queryTaxesByOrg(String year, Long orgId) {
        List list;
        BigDecimal sum = BigDecimal.ZERO;
        List<Object> projectIds = new ArrayList();
        List<ProjectPoolSetVO> projectList = this.queryProjectPoolList("1", null, orgId);
        projectIds = projectList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(projectIds)) {
            return CommonResponse.success((String)"\u9879\u76ee\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(CostDetailEntity::getSourceType, (Object)"COST_HANDSHARE");
        lambda.eq(CostDetailEntity::getProportionFlag, (Object)"1");
        lambda.in(CostDetailEntity::getProjectId, projectIds);
        if (StringUtils.isNotEmpty((CharSequence)year)) {
            lambda.le(CostDetailEntity::getPeriod, (Object)(year + "-12"));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)lambda)))) {
            sum = list.stream().filter(item -> null != item.getHappenMny()).map(CostDetailEntity::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return CommonResponse.success((Object)sum);
    }

    public List<ProjectPoolSetVO> queryProjectPoolList(String projectStatus, String dateIn, Long orgId) {
        CommonResponse resp = this.projectSetApi.queryProjectPoolList(projectStatus, dateIn, orgId);
        ArrayList<ProjectPoolSetVO> result = new ArrayList();
        if (resp.isSuccess()) {
            result = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectPoolSetVO.class);
        } else {
            this.logger.error(resp.getMsg());
        }
        return result;
    }
}

