package com.ejianc.business.procost.controller.desktop;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.home.util.PageUtil;
import com.ejianc.business.contractbase.home.vo.ProjectPoolSetTreeVO;
import com.ejianc.business.contractbase.utils.ITreeNodeB;
import com.ejianc.business.contractbase.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2023/1/10 15:56
 */
@RestController
@RequestMapping("/treeReport/")
public class TreeReportController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String QUERY_TABLE_DETAIL_URL = "ejc-report-web/tbl/queryDetailByCode";
    private final String QUERY_REPORT_DATA_URL = "ejc-report-web/data/report/readByCode/";

    private final static Integer QUERY_TIMEOUT = 60;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IProjectPoolApi projectSetApi;

    @Autowired(required=false)
    private RestHighLevelClient client;

    private final String[] proj_targetcost_sum_cols = new String[]{"targetCostTotalMny", "contTotalMny", "zhichuzonge（zhijie+jianjie）",
            "rgfCostMny", "rgfContMny", "clfCostMny", "sbfCostMny", "sbfContMny", "zyfbCostMny", "zyfbContMny", "qtzcCostMny", "qtzcContMny",
    "jjfCostMny", "jjfContMny", "jjfContMnyF", "sjCostMny", "sjContMny", "sjContMnyF"};
    private final String[] proj_cost_sum_cols = new String[]{"outPutTaxMny", "bugetTaxMny", "quoteTaxMny", "targetCostTaxMny", "finishTaxMny",
    "costTaxMny", "mubiao-shijijiechao", "mubiao-shijijiechaobili", "targetCostTaxCpuMny", "costTmpTaxMny", "wancheng-shijijiechao", "finishTempTaxMny"};
    private final String[] proj_cost_calc_cols = new String[]{"mubiao-shijijiechaobili /= mubiao-shijijiechao // targetCostTaxCpuMny"};
    private final String[] proj_targetcost_calc_cols = new String[]{"scale /= contTotalMny // targetCostTotalMny /* Num-100",
            "zongjiechaobili /= targetCostTotalMny /- contTotalMny /+ jjfContMnyF /+ sjContMnyF // targetCostTotalMny",
    "rgfScale /= rgfCostMny /- rgfContMny // rgfCostMny /* Num-100",
    "clfScale /= clfCostMny /- clfContMny // clfCostMny /* Num-100",
    "sbfScale /= sbfCostMny /- sbfContMny // sbfCostMny /* Num-100",
    "zyfbScale /= zyfbCostMny /- zyfbContMny // zyfbCostMny /* Num-100",
    "qtzcScale /= qtzcCostMny /- qtzcContMny // qtzcCostMny /* Num-100",
    "jjfScale /= jjfCostMny /- jjfContMny // jjfCostMny /* Num-100",
    "sjScale /= sjCostMny /- sjContMny // sjCostMny /* Num-100",
    };

    /**
     * 项目目标执行台账、项目成本台账属性数据处理
     *
     * @param req
     * @param queryParam
     * @return
     * @throws Exception
     */
    @PostMapping(value = "pagePrjTreeReport/{tableCode}")
    public CommonResponse<JSONObject> pagePrjTreeReport(HttpServletRequest req, @PathVariable String tableCode, @RequestBody QueryParam queryParam) throws Exception {
        JSONObject resp = new JSONObject();
        Integer total = 0;

        Map<String, String> header = new HashMap<>();
        header.put("authority", req.getHeader("authority"));
        header.put("content-type", "application/json;charset=UTF-8");


        //1、查询报表信息
        Map<String, String> tblParam = new HashMap<>();
        tblParam.put("tableCode", tableCode);
        String respStr = HttpTookit.get(BaseHost + QUERY_TABLE_DETAIL_URL, tblParam, header);
        logger.info("根据报表编码-【{}】查询报表结果：{}", tableCode, respStr);
        CommonResponse<JSONObject> tblResp = JSONObject.parseObject(respStr, CommonResponse.class);
        if(!tblResp.isSuccess()) {
            logger.error("查询报表信息失败: {}", respStr);
            return CommonResponse.error("查询报表信息失败");
        }
        JSONObject tableEntity = tblResp.getData();

        String[] sumCols = null, calcCols = null;
        if(tableEntity.getString("code").equals("proj_targetcost")) {
            sumCols = proj_targetcost_sum_cols;
            calcCols = proj_targetcost_calc_cols;
        } else {
            sumCols = proj_cost_sum_cols;
            calcCols = proj_cost_calc_cols;
        }

        //2、若报表有自定义查询参数
        String msg = configQueryParam(tableEntity, queryParam, req);
        if(StringUtils.isNotBlank(msg)) {
            logger.error("报表参数组装失败: {}", msg);
            return CommonResponse.error(msg);
        }

        //3、根据页面参数筛选出匹配的项目信息
        QueryParam projectParam = new QueryParam();
        if(queryParam.getParams().containsKey("orgId")) {
            projectParam.getParams().put("orgId", new Parameter(QueryParam.EQ, queryParam.getParams().get("orgId")));
        }
        if(queryParam.getParams().containsKey("parentOrgId")) {
            projectParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    queryParam.getParams().get("parentOrgId")));
        }
        if(queryParam.getParams().containsKey("statusName")) {
            List<String> status = Arrays.stream(queryParam.getParams().get("statusName").getValue().toString().split(",")).filter(item -> !"无".equals(item)).map(item -> getProjectStatus(item)).collect(Collectors.toList());
            projectParam.getParams().put("projectStatus", new Parameter(QueryParam.IN,
                    status));
        }
        if(queryParam.getParams().containsKey("projectDate")) {
            projectParam.getParams().put("projectDate", new Parameter(QueryParam.BETWEEN, queryParam.getParams().get("projectDate")));
        }
        projectParam.getOrderMap().put("id", "asc");

        logger.info("查询项目列表参数：{}", JSONObject.toJSONString(projectParam));
        String projectRespStr = HttpTookit.postByJson(BaseHost + "ejc-share-web/api/projectPool/getProjectPoolList", JSONObject.toJSONString(queryParam), header, 10000, 10000);
        CommonResponse<JSONArray> projectResp = JSONObject.parseObject(projectRespStr, CommonResponse.class);

        if(!projectResp.isSuccess()) {
            logger.error("查询项目信息失败: {}", projectRespStr);
            return CommonResponse.error("查询项目信息失败！");
        }
        List<ProjectPoolSetTreeVO> treeVos = BeanMapper.mapList(JSONArray.parseArray(JSONObject.toJSONString(projectResp.getData()), ProjectPoolSetTreeVO.class),ProjectPoolSetTreeVO.class);
        // 主子项目的返回数据
        List<ProjectPoolSetTreeVO> treeList = TreeNodeBUtil.buildTree(treeVos);
        total = treeList.size();
        treeList = PageUtil.listToPage(treeList, queryParam.getPageIndex(), queryParam.getPageSize());

        //4、将项目Id信息放入参数中查询报表数据
        Map<String, JSONObject> topTreeNodeMap = new HashMap<>();
        List<String> topPrjIds = new ArrayList<>();
        List<Long> projectIds = new ArrayList<>();
        Map<String, String> pidMap = new HashMap<>();
        JSONObject node = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for(ProjectPoolSetTreeVO treeNode : treeList) {
            node = new JSONObject();
            node.put("id", treeNode.getId());
            node.put("name", treeNode.getName());
            node.put("projectDate", sdf.format(treeNode.getProjectDate()));
            node.put("statusName", getProjectStatusName(treeNode.getProjectStatus()));

            topTreeNodeMap.put(node.getString("id"), node);
            projectIds.add(treeNode.getId());
            topPrjIds.add(treeNode.getId().toString());

            if(CollectionUtils.isNotEmpty(treeNode.getChildren())) {
                for(ITreeNodeB child : treeNode.getChildren()) {
                    projectIds.add(child.getNodeID());
                    pidMap.put(child.getNodeID().toString(), treeNode.getId().toString());
                }
            }
        }

        queryParam.getParams().put("id", new Parameter(QueryParam.IN, projectIds));

        QueryParam reportListParam = Utils.deepCopy(queryParam);
        reportListParam.setPageIndex(1);
        reportListParam.setPageSize(projectIds.size());

        //5、将报表数据拼接成树形，子级项目数据汇总到父级项目中
        String reportDataStr = HttpTookit.postByJson(BaseHost + QUERY_REPORT_DATA_URL + tableEntity.getString("code"),
                JSONObject.toJSONString(reportListParam), header, 10000, 10000);
        CommonResponse<JSONObject> reportDataResp = JSONObject.parseObject(reportDataStr, CommonResponse.class);
        if(!reportDataResp.isSuccess()) {
            logger.error("报表数据查询失败：{}", reportDataStr);
            return CommonResponse.error("查询报表数据失败！");
        }
        JSONObject reportData = reportDataResp.getData();
        JSONObject pageData = reportData.getJSONObject("data");
        List<JSONObject> pageList = JSONObject.parseArray(pageData.getString("records"), JSONObject.class);

        JSONObject tmp = null;
        JSONArray children = null;
        for(JSONObject item : pageList) {
            tmp = topTreeNodeMap.get(pidMap.get(item.getString("id")));
            children = tmp.getJSONArray("children");
            if(null == children) {
                children = new JSONArray();
            }
            children.add(item);
            sumCol(tmp, item, sumCols);
            topTreeNodeMap.put(tmp.getString("id"), tmp);
        }

        List<JSONObject> newRecords = new ArrayList<>(topPrjIds.size());
        String calcRsColIndex = null, calcColIndex = null, symbol = null;
        BigDecimal tmpRs = null;
        String[] formulaItems = null;
        for(String prjId : topPrjIds) {
            tmp = topTreeNodeMap.get(prjId);
            //处理计算列
            if(calcCols != null && calcCols.length > 0) {
                //rgfCostMny /- rgfContMny // rgfCostMny /* Num-100
                for(String formula : calcCols) {
                    calcRsColIndex = formula.split(" /= ")[0];
                    formulaItems = formula.split(" /= ")[1].split(" ");
                    for(int i=0,len=formulaItems.length; i<len;) {
                        if(i == 0) {
                            tmpRs = formulaItems[0].contains("Num-") ? new BigDecimal(formulaItems[0].replace("Num-", "")) : tmp.getBigDecimal(formulaItems[0]);
                            calcColIndex = formulaItems[i+2];
                            symbol = formulaItems[i+1];
                            i += 3;
                        } else {
                            calcColIndex = formulaItems[i+1];
                            symbol = formulaItems[i];
                            i += 2;
                        }
                        tmpRs = colCalc(tmpRs, calcColIndex.contains("Num-") ? new BigDecimal(calcColIndex.replace("Num-", "")) : tmp.getBigDecimal(calcColIndex), symbol);
                    }
                    tmp.put(calcRsColIndex, tmpRs);
                    newRecords.add(tmp);
                }
            } else {
                newRecords.add(tmp);
            }
        }

        pageData.put("records", newRecords);
        pageData.put("current", queryParam.getPageIndex());
        pageData.put("size", queryParam.getPageSize());
        pageData.put("total", total);
        reportData.put("data", pageData);

        return CommonResponse.success(reportData);
    }

    private String getProjectStatus(String statusName) {
        switch (statusName) {
            case "在建":
                return "1";
            case "停工":
                return "2";
            case "完工":
                return "3";
            case "保修":
                return "4";
            case "其他":
                return "5";
            default:
                return "";
        }
    }

    private BigDecimal colCalc(BigDecimal numA, BigDecimal numB, String symbol) {
        switch (symbol) {
            case "/-":
                return ComputeUtil.safeSub(numA, numB);
            case "/+":
                return ComputeUtil.safeAdd(numA, numB);
            case "/*":
                return ComputeUtil.safeMultiply(numA, numB);
            case "//":
                return ComputeUtil.safeDiv(numA, numB);
            default:
                throw new BusinessException("错误的计算符号：" + symbol);
        }
    }

    private void sumCol(JSONObject tmp, JSONObject item, String[] sumCols) {
        for(String colIndex : sumCols) {
            tmp.put(colIndex, ComputeUtil.safeAdd(tmp.getBigDecimal(colIndex), item.getBigDecimal(colIndex)));
        }
    }

    private String getProjectStatusName(String status) {
        switch (status) {
            case "1":
                return "在建";
            case "2":
                return "停工";
            case "3":
                return "完工";
            case "4":
                return "保修";
            case "5":
                return "其他";
            default:
                return "无";
        }
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap, Map<String, String> filedTypeMap,String searchText) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for(Map.Entry<String, Parameter> entry: paramMap.entrySet()){
            Parameter param = entry.getValue();
            if(param.getValue() == null || StringUtils.isBlank(param.getValue() + "")) {
                continue;
            }
            if(QueryParam.EQ.equals(param.getType())) {
                boolQuery.must(QueryBuilders.termQuery(entry.getKey(), param.getValue().toString()));
            } else if(QueryParam.LIKE.equals(param.getType())) {
                boolQuery.must(QueryBuilders.matchPhrasePrefixQuery(entry.getKey(), param.getValue().toString()));
            } else if(QueryParam.IN.equals(param.getType())) {
                Object inParam = param.getValue();
                if(inParam instanceof String) {
                    boolQuery.must(QueryBuilders.termsQuery(entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                } else if(inParam instanceof JSONArray) {
                    boolQuery.must(QueryBuilders.termsQuery(entry.getKey(), JSONObject.parseArray(JSONObject.toJSONString(inParam), Long.class)));
                }
            } else if(QueryParam.BETWEEN.equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                Object v1 = dataArr[0], v2 = dataArr[1];
                if("time".equals(filedTypeMap.get(entry.getKey()))) {
                    //日期格式转为yyyy-MM-dd HH:mm:ss
                    v1 = null != v1 && StringUtils.isNotBlank(v1.toString()) ? sdf.format(DateUtil.parse(v1.toString())) : v1;
                    v2 = null != v2 && StringUtils.isNotBlank(v2.toString()) ? sdf.format(DateUtil.parse(v2.toString())) : v2;
                }
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).from(v1).to(v2).includeLower(true).includeUpper(true));
            } else if(QueryParam.GT.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).gt(param.getValue().toString()));
            } else if(QueryParam.GE.equals(param.getType())){
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).gte(param.getValue().toString()));
            } else if(QueryParam.LT.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).lt(param.getValue().toString()));
            } else if(QueryParam.LE.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).lte(param.getValue().toString()));
            }
        }
        // 搜索框
        if(!StringUtils.isEmpty(searchText)){
            BoolQueryBuilder should = QueryBuilders.boolQuery().should(QueryBuilders.multiMatchQuery(searchText, "orgName"))
                    .should(QueryBuilders.multiMatchQuery(searchText,"contractName"))
                    .should(QueryBuilders.multiMatchQuery(searchText,"supplierName"));
            boolQuery.must(should);
        }
        return boolQuery;
    }

    public IPage<JSONObject> queryPageList(String indexName, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap, boolean isHighLightSearchFields) {
        IPage<JSONObject> page = new Page<>();

        SearchRequest searchRequest = new SearchRequest(indexName);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highlightBuilder.preTags("<span style=\"color:red\">");
        highlightBuilder.postTags("</span>");
        if(CollectionUtils.isNotEmpty(heightFields)) {
            for(String field : heightFields) {
                highlightBuilder.field(field);
            }
        } else {
            highlightBuilder.field("*").requireFieldMatch(false);
        }
        sourceBuilder.highlighter(highlightBuilder);

        //查询参数
        Map<String, Parameter> paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        try {
            boolQuery = setParam(boolQuery, paramMap, filedTypeMap,queryParam.getSearchText());

            //复杂查询
            if(CollectionUtils.isNotEmpty(queryParam.getComplexParams())) {
                boolQuery.must(parseComplexParams(queryParam.getComplexParams(), filedTypeMap));
            }

            sourceBuilder.query(boolQuery);
            Map<String, String> orderMap = queryParam.getOrderMap();
            if(orderMap.isEmpty()) {
                //强制指定sort类型，解决es创建索引后，随指定了_default_mapping但未初始化导致的查询时排序报错的问题。
                sourceBuilder.sort(new FieldSortBuilder("data_sequence").unmappedType("long").order(SortOrder.ASC));
            } else {
                for(String key : orderMap.keySet()) {
                    sourceBuilder.sort(new FieldSortBuilder(key)
                            .unmappedType("number".equals(filedTypeMap.get(key)) || "pic".equals(filedTypeMap.get(key)) ? "long" : "time".equals(filedTypeMap.get(key)) ? "date" : "text").order("asc".equals(orderMap.get(key)) ? SortOrder.ASC : SortOrder.DESC));
                }
            }
            sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex()-1)*queryParam.getPageSize());
            sourceBuilder.size(queryParam.getPageSize());
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
            searchRequest.source(sourceBuilder);

            page = queryPage(paramMap, searchRequest, isHighLightSearchFields);
        } catch (Exception e) {
            try { //重试一次
                page = queryPage(paramMap, searchRequest, isHighLightSearchFields);
            } catch (Exception e1) {
                e1.printStackTrace();
                throw new BusinessException("查询全部记录索引失败，MSG：", e1);
            }
        }
        return page;
    }

    //查询es
    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest) throws IOException {
        return queryPage(paramMap, searchRequest, true);
    }

    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest, boolean isHighLightSearchFields) throws IOException {
        IPage<JSONObject> page = new Page<>();
        List<JSONObject> list = new ArrayList<>();
        SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
        if(isHighLightSearchFields) {
            for(SearchHit hit : response.getHits()){
                Map<String, Object> source = hit.getSourceAsMap();
                //处理高亮片段
                Map<String, HighlightField> highlightFields = hit.getHighlightFields();
                for(Map.Entry<String, HighlightField> highlightEntry:highlightFields.entrySet()) {
                    if(paramMap.containsKey(highlightEntry.getKey())) {
                        Parameter parameter = paramMap.get(highlightEntry.getKey());
                        if(StringUtils.isNotBlank(parameter.getValue() + "")) {
                            HighlightField nameField = highlightEntry.getValue();
                            if(nameField!=null){
                                Text[] fragments = nameField.fragments();
                                StringBuilder nameTmp = new StringBuilder();
                                for(Text text:fragments){
                                    nameTmp.append(text);
                                }
                                //将高亮片段组装到结果中去
                                source.put(highlightEntry.getKey(), nameTmp.toString());
                            }
                        }
                    }
                }
            }
        }

        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            list.add(new JSONObject(hit.getSourceAsMap()));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap, Map<String, String> filedTypeMap) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for(Map.Entry<String, Parameter> entry: paramMap.entrySet()){
            Parameter param = entry.getValue();
            if(param.getValue() == null || StringUtils.isBlank(param.getValue() + "")) {
                continue;
            }
            if(QueryParam.EQ.equals(param.getType())) {
                boolQuery.must(QueryBuilders.termQuery(entry.getKey(), param.getValue().toString()));
            } else if(QueryParam.LIKE.equals(param.getType())) {
                boolQuery.must(QueryBuilders.matchPhrasePrefixQuery(entry.getKey(), param.getValue().toString()));
//                boolQuery.must(QueryBuilders.matchQuery(entry.getKey(), param.getValue().toString()).analyzer("ik_smart"));
            } else if(QueryParam.IN.equals(param.getType())) {
                Object inParam = param.getValue();
                if(inParam instanceof String) {
                    boolQuery.must(QueryBuilders.termsQuery(entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                } else if(inParam instanceof JSONArray) {
                    boolQuery.must(QueryBuilders.termsQuery(entry.getKey(), JSONObject.parseArray(JSONObject.toJSONString(inParam), Long.class)));
                }
            } else if(QueryParam.BETWEEN.equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                Object v1 = dataArr[0], v2 = dataArr[1];
                if("time".equals(filedTypeMap.get(entry.getKey()))) {
                    logger.info(v1+","+v2);
                    //日期格式转为yyyy-MM-dd HH:mm:ss
                    v1 = (null != v1 && StringUtils.isNotBlank(v1.toString())) ? sdf.format(DateUtil.parse(v1.toString())) : v1;
                    v2 = (null != v2 && StringUtils.isNotBlank(v2.toString())) ? sdf.format(DateUtil.parse(v2.toString())) : v2;
                    boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).from(v1).to(v2).includeLower(true).includeUpper(true));
                }else{
                    boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).from(v1).to(v2).includeLower(true).includeUpper(true));
                }
//                boolQuery.must(QueryBuilders.rangeQuery(entry.getKey()).from(dataArr[0]).to(dataArr[1]).includeLower(true).includeUpper(true));
            } else if(QueryParam.GT.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).gt(param.getValue().toString()));
            } else if(QueryParam.GE.equals(param.getType())){
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).gte(param.getValue().toString()));
            } else if(QueryParam.LT.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).lt(param.getValue().toString()));
            } else if(QueryParam.LE.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).lte(param.getValue().toString()));
            }
        }
        return boolQuery;
    }

    private BoolQueryBuilder parseComplexParams(List<ComplexParam> complexParams, Map<String, String> filedTypeMap) throws Exception {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for(ComplexParam cp : complexParams) {
            if(ComplexParam.AND.equals(cp.getLogic())) {
                if(!cp.getParams().isEmpty()) {
                    boolQuery.must(setParam(QueryBuilders.boolQuery(), cp.getParams(), filedTypeMap));
                }
                if(CollectionUtils.isNotEmpty(cp.getComplexParams())) {
                    boolQuery.must(parseComplexParams(cp.getComplexParams(), filedTypeMap));
                }
            } else {
                if(!cp.getParams().isEmpty()) {
                    boolQuery.should(setParam(QueryBuilders.boolQuery(), cp.getParams(), filedTypeMap));
                }
                if(CollectionUtils.isNotEmpty(cp.getComplexParams())) {
                    boolQuery.should(parseComplexParams(cp.getComplexParams(), filedTypeMap));
                }
            }
        }

        return boolQuery;
    }

    private String configQueryParam(JSONObject tableEntity, QueryParam queryParam, HttpServletRequest req) {
        //拼接查询排序条件
        if(StringUtils.isNotBlank(tableEntity.getString("orderItemJson"))) {
            List<JSONObject> orderGroups = JSONArray.parseArray(tableEntity.getString("orderItemJson"), JSONObject.class);
            JSONObject order = null;
            for(JSONObject o : orderGroups) {
                if(null != o.get("isActive") && o.get("isActive").toString().equals("true")) {
                    order = o;
                    break;
                }
            }
            if(null == order && CollectionUtils.isNotEmpty(orderGroups)) {
                order = orderGroups.get(0);
            }
            if(null != order && !queryParam.getOrderMap().containsKey(order.get("field").toString())) {
                queryParam.getOrderMap().put(order.get("field").toString(), order.get("sort").toString());
            }
        }
        Parameter parameter = queryParam.getParams().get("_treeSelectId");
        String leftTreeId = null;
        if(parameter != null) {
            leftTreeId = (String) parameter.getValue();
        }
        String url  = tableEntity.getString("paramUrl");
        try {
            if(StringUtils.isNotBlank(url)) {
                if(StringUtils.isNotBlank(leftTreeId)) {
                    url += url.indexOf("?") == -1 ? "?":"&";
                    url = url+"leftTreeId="+leftTreeId;
                }
                if(url.indexOf("http") < 0) {
                    url = BaseHost + url;
                }
                Map<String, String> header = new HashMap<>();
                header.put("authority", req.getHeader("authority"));
                header.put("content-type", "application/json;charset=UTF-8");
                logger.info("请求地址-{}，header-{}", url, JSONObject.toJSONString(header));
                String respStr = HttpTookit.get(url, new HashMap<>(), header);
                CommonResponse<JSONObject> params = JSONObject.parseObject(respStr, CommonResponse.class);
                if(!params.isSuccess()) {
                    logger.error("请求服务-【{}】获取报表参数失败，{}", url, params.getMsg());
                    return "数据查询失败，" + params.getMsg();
                }
                QueryParam q = JSONObject.parseObject(JSONObject.toJSONString(params.getData()), QueryParam.class);
                queryParam.getParams().putAll(q.getParams());
                queryParam.getComplexParams().addAll(q.getComplexParams());
            }
        } catch (Exception e) {
            logger.error("请求服务-【{}】获取报表参数失败，", url, e);
            return "数据查询失败，获取查询参数失败！";
        }
        return null;
    }

}
