/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.bean.ReportEntity;
import com.ejianc.business.procost.service.IReportService;
import com.ejianc.business.procost.vo.ReportVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reportFileUpdate/"})
public class ReportFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReportService service;
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        ReportEntity contract = (ReportEntity)((Object)this.service.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        this.service.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getBillDataJson"})
    public CommonResponse<ReportVO> getBillDataJson(@RequestParam Long id) {
        ReportEntity contract = (ReportEntity)((Object)this.service.selectById(id));
        ReportVO vo = (ReportVO)BeanMapper.map((Object)((Object)contract), ReportVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,##0.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getReportDetailList())) {
            vo.getReportDetailList().forEach(item -> {
                item.setYsHappenMnyAllStr(null != item.getYsHappenMnyAll() ? mnyFmt.format(item.getYsHappenMnyAll()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCbHappenMnyAllStr(null != item.getCbHappenMnyAll() ? mnyFmt.format(item.getCbHappenMnyAll()) : mnyFmt.format(BigDecimal.ZERO));
                item.setYsHappenMnyStr(null != item.getYsHappenMny() ? mnyFmt.format(item.getYsHappenMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCbHappenMnyStr(null != item.getCbHappenMny() ? priceFmt.format(item.getCbHappenMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setHappenMnyStr(null != item.getHappenMny() ? priceFmt.format(item.getHappenMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrmbdifMnyStr(null != item.getSrmbdifMny() ? priceFmt.format(item.getSrmbdifMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrmbRateStr(null != item.getSrmbRate() ? priceFmt.format(item.getSrmbRate()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrsjdifMnyStr(null != item.getSrsjdifMny() ? priceFmt.format(item.getSrsjdifMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrsjRateStr(null != item.getSrsjRate() ? priceFmt.format(item.getSrsjRate()) : priceFmt.format(BigDecimal.ZERO));
                item.setMbsjdifMnyStr(null != item.getMbsjdifMny() ? priceFmt.format(item.getMbsjdifMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setMbsjRateStr(null != item.getMbsjRate() ? priceFmt.format(item.getMbsjRate()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        return CommonResponse.success((Object)vo);
    }
}

