/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller.desktop;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.home.util.PageUtil;
import com.ejianc.business.contractbase.home.vo.ProjectPoolSetTreeVO;
import com.ejianc.business.contractbase.utils.ITreeNodeB;
import com.ejianc.business.contractbase.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/treeReport/"})
public class TreeReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String QUERY_TABLE_DETAIL_URL = "ejc-report-web/tbl/queryDetailByCode";
    private final String QUERY_REPORT_DATA_URL = "ejc-report-web/data/report/readByCode/";
    private static final Integer QUERY_TIMEOUT = 60;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired(required=false)
    private RestHighLevelClient client;
    private final String[] proj_targetcost_sum_cols = new String[]{"targetCostTotalMny", "contTotalMny", "zhichuzonge\uff08zhijie+jianjie\uff09", "rgfCostMny", "rgfContMny", "clfCostMny", "sbfCostMny", "sbfContMny", "zyfbCostMny", "zyfbContMny", "qtzcCostMny", "qtzcContMny", "jjfCostMny", "jjfContMny", "jjfContMnyF", "sjCostMny", "sjContMny", "sjContMnyF"};
    private final String[] proj_cost_sum_cols = new String[]{"outPutTaxMny", "bugetTaxMny", "quoteTaxMny", "targetCostTaxMny", "finishTaxMny", "costTaxMny", "mubiao-shijijiechao", "mubiao-shijijiechaobili", "targetCostTaxCpuMny", "costTmpTaxMny", "wancheng-shijijiechao", "finishTempTaxMny"};
    private final String[] proj_cost_calc_cols = new String[]{"mubiao-shijijiechaobili /= mubiao-shijijiechao // targetCostTaxCpuMny"};
    private final String[] proj_targetcost_calc_cols = new String[]{"scale /= contTotalMny // targetCostTotalMny /* Num-100", "zongjiechaobili /= targetCostTotalMny /- contTotalMny /+ jjfContMnyF /+ sjContMnyF // targetCostTotalMny", "rgfScale /= rgfCostMny /- rgfContMny // rgfCostMny /* Num-100", "clfScale /= clfCostMny /- clfContMny // clfCostMny /* Num-100", "sbfScale /= sbfCostMny /- sbfContMny // sbfCostMny /* Num-100", "zyfbScale /= zyfbCostMny /- zyfbContMny // zyfbCostMny /* Num-100", "qtzcScale /= qtzcCostMny /- qtzcContMny // qtzcCostMny /* Num-100", "jjfScale /= jjfCostMny /- jjfContMny // jjfCostMny /* Num-100", "sjScale /= sjCostMny /- sjContMny // sjCostMny /* Num-100"};

    @PostMapping(value={"pagePrjTreeReport/{tableCode}"})
    public CommonResponse<JSONObject> pagePrjTreeReport(HttpServletRequest req, @PathVariable String tableCode, @RequestBody QueryParam queryParam) throws Exception {
        JSONObject resp = new JSONObject();
        Integer total = 0;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("authority", req.getHeader("authority"));
        header.put("content-type", "application/json;charset=UTF-8");
        HashMap<String, String> tblParam = new HashMap<String, String>();
        tblParam.put("tableCode", tableCode);
        String respStr = HttpTookit.get((String)(this.BaseHost + "ejc-report-web/tbl/queryDetailByCode"), tblParam, header);
        this.logger.info("\u6839\u636e\u62a5\u8868\u7f16\u7801-\u3010{}\u3011\u67e5\u8be2\u62a5\u8868\u7ed3\u679c\uff1a{}", (Object)tableCode, (Object)respStr);
        CommonResponse tblResp = (CommonResponse)JSONObject.parseObject((String)respStr, CommonResponse.class);
        if (!tblResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u62a5\u8868\u4fe1\u606f\u5931\u8d25: {}", (Object)respStr);
            return CommonResponse.error((String)"\u67e5\u8be2\u62a5\u8868\u4fe1\u606f\u5931\u8d25");
        }
        JSONObject tableEntity = (JSONObject)tblResp.getData();
        String[] sumCols = null;
        String[] calcCols = null;
        if (tableEntity.getString("code").equals("proj_targetcost")) {
            sumCols = this.proj_targetcost_sum_cols;
            calcCols = this.proj_targetcost_calc_cols;
        } else {
            sumCols = this.proj_cost_sum_cols;
            calcCols = this.proj_cost_calc_cols;
        }
        String msg = this.configQueryParam(tableEntity, queryParam, req);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u62a5\u8868\u53c2\u6570\u7ec4\u88c5\u5931\u8d25: {}", (Object)msg);
            return CommonResponse.error((String)msg);
        }
        QueryParam projectParam = new QueryParam();
        if (queryParam.getParams().containsKey("orgId")) {
            projectParam.getParams().put("projectDepartmentId", queryParam.getParams().get("orgId"));
        }
        if (queryParam.getParams().containsKey("parentOrgId")) {
            projectParam.getParams().put("orgId", queryParam.getParams().get("parentOrgId"));
        }
        if (queryParam.getParams().containsKey("statusName")) {
            List status = Arrays.stream(((Parameter)queryParam.getParams().get("statusName")).getValue().toString().split(",")).filter(item -> !"\u65e0".equals(item)).map(item -> this.getProjectStatus((String)item)).collect(Collectors.toList());
            projectParam.getParams().put("projectStatus", new Parameter("in", status));
        }
        if (queryParam.getParams().containsKey("projectDate")) {
            projectParam.getParams().put("projectDate", new Parameter("between", queryParam.getParams().get("projectDate")));
        }
        projectParam.getOrderMap().put("id", "asc");
        String projectRespStr = HttpTookit.postByJson((String)(this.BaseHost + "ejc-share-web/api/projectPool/getProjectPoolList"), (String)JSONObject.toJSONString((Object)projectParam), header, (Integer)10000, (Integer)10000);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5217\u8868\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectParam), (Object)projectRespStr);
        CommonResponse projectResp = (CommonResponse)JSONObject.parseObject((String)projectRespStr, CommonResponse.class);
        if (!projectResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25: {}", (Object)projectRespStr);
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List treeVos = BeanMapper.mapList((Iterable)JSONArray.parseArray((String)JSONObject.toJSONString((Object)projectResp.getData()), ProjectPoolSetTreeVO.class), ProjectPoolSetTreeVO.class);
        List treeList = TreeNodeBUtil.buildTree((List)treeVos);
        total = treeList.size();
        treeList = PageUtil.listToPage((List)treeList, (int)queryParam.getPageIndex(), (int)queryParam.getPageSize());
        HashMap<String, JSONObject> topTreeNodeMap = new HashMap<String, JSONObject>();
        ArrayList<String> topPrjIds = new ArrayList<String>();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        HashMap<String, String> pidMap = new HashMap<String, String>();
        JSONObject node = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ProjectPoolSetTreeVO treeNode : treeList) {
            node = new JSONObject();
            node.put("id", (Object)treeNode.getId());
            node.put("name", (Object)treeNode.getName());
            node.put("projectDate", (Object)sdf.format(treeNode.getProjectDate()));
            node.put("statusName", (Object)this.getProjectStatusName(treeNode.getProjectStatus()));
            topTreeNodeMap.put(node.getString("id"), node);
            projectIds.add(treeNode.getId());
            topPrjIds.add(treeNode.getId().toString());
            if (!CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) continue;
            for (ITreeNodeB child : treeNode.getChildren()) {
                projectIds.add(child.getNodeID());
                pidMap.put(child.getNodeID().toString(), treeNode.getId().toString());
            }
        }
        queryParam.getParams().put("id", new Parameter("in", projectIds));
        QueryParam reportListParam = (QueryParam)Utils.deepCopy((Object)queryParam);
        reportListParam.setPageIndex(1);
        reportListParam.setPageSize(projectIds.size());
        String reportDataStr = HttpTookit.postByJson((String)(this.BaseHost + "ejc-report-web/data/report/readByCode/" + tableEntity.getString("code")), (String)JSONObject.toJSONString((Object)reportListParam), header, (Integer)10000, (Integer)10000);
        CommonResponse reportDataResp = (CommonResponse)JSONObject.parseObject((String)reportDataStr, CommonResponse.class);
        if (!reportDataResp.isSuccess()) {
            this.logger.error("\u62a5\u8868\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)reportDataStr);
            return CommonResponse.error((String)"\u67e5\u8be2\u62a5\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        JSONObject reportData = (JSONObject)reportDataResp.getData();
        JSONObject pageData = reportData.getJSONObject("data");
        List pageList = JSONObject.parseArray((String)pageData.getString("records"), JSONObject.class);
        JSONObject tmp = null;
        JSONArray children = null;
        for (JSONObject item2 : pageList) {
            tmp = (JSONObject)topTreeNodeMap.get(pidMap.get(item2.getString("id")));
            children = tmp.getJSONArray("children");
            if (null == children) {
                children = new JSONArray();
            }
            children.add((Object)item2);
            this.sumCol(tmp, item2, sumCols);
            topTreeNodeMap.put(tmp.getString("id"), tmp);
        }
        ArrayList<JSONObject> newRecords = new ArrayList<JSONObject>(topPrjIds.size());
        String calcRsColIndex = null;
        String calcColIndex = null;
        String symbol = null;
        BigDecimal tmpRs = null;
        String[] formulaItems = null;
        for (String prjId : topPrjIds) {
            tmp = (JSONObject)topTreeNodeMap.get(prjId);
            if (calcCols != null && calcCols.length > 0) {
                for (String formula : calcCols) {
                    calcRsColIndex = formula.split(" /= ")[0];
                    formulaItems = formula.split(" /= ")[1].split(" ");
                    int i = 0;
                    int len = formulaItems.length;
                    while (i < len) {
                        if (i == 0) {
                            tmpRs = formulaItems[0].contains("Num-") ? new BigDecimal(formulaItems[0].replace("Num-", "")) : tmp.getBigDecimal(formulaItems[0]);
                            calcColIndex = formulaItems[i + 2];
                            symbol = formulaItems[i + 1];
                            i += 3;
                        } else {
                            calcColIndex = formulaItems[i + 1];
                            symbol = formulaItems[i];
                            i += 2;
                        }
                        tmpRs = this.colCalc(tmpRs, calcColIndex.contains("Num-") ? new BigDecimal(calcColIndex.replace("Num-", "")) : tmp.getBigDecimal(calcColIndex), symbol);
                    }
                    tmp.put(calcRsColIndex, tmpRs);
                    newRecords.add(tmp);
                }
                continue;
            }
            newRecords.add(tmp);
        }
        pageData.put("records", newRecords);
        pageData.put("current", (Object)queryParam.getPageIndex());
        pageData.put("size", (Object)queryParam.getPageSize());
        pageData.put("total", (Object)total);
        reportData.put("data", (Object)pageData);
        return CommonResponse.success((Object)reportData);
    }

    private String getProjectStatus(String statusName) {
        switch (statusName) {
            case "\u5728\u5efa": {
                return "1";
            }
            case "\u505c\u5de5": {
                return "2";
            }
            case "\u5b8c\u5de5": {
                return "3";
            }
            case "\u4fdd\u4fee": {
                return "4";
            }
            case "\u5176\u4ed6": {
                return "5";
            }
        }
        return "";
    }

    private BigDecimal colCalc(BigDecimal numA, BigDecimal numB, String symbol) {
        switch (symbol) {
            case "/-": {
                return ComputeUtil.safeSub((BigDecimal)numA, (BigDecimal)numB);
            }
            case "/+": {
                return ComputeUtil.safeAdd((BigDecimal)numA, (BigDecimal)numB);
            }
            case "/*": {
                return ComputeUtil.safeMultiply((BigDecimal)numA, (BigDecimal)numB);
            }
            case "//": {
                return ComputeUtil.safeDiv((BigDecimal)numA, (BigDecimal)numB);
            }
        }
        throw new BusinessException("\u9519\u8bef\u7684\u8ba1\u7b97\u7b26\u53f7\uff1a" + symbol);
    }

    private void sumCol(JSONObject tmp, JSONObject item, String[] sumCols) {
        for (String colIndex : sumCols) {
            tmp.put(colIndex, (Object)ComputeUtil.safeAdd((BigDecimal)tmp.getBigDecimal(colIndex), (BigDecimal)item.getBigDecimal(colIndex)));
        }
    }

    private String getProjectStatusName(String status) {
        switch (status) {
            case "1": {
                return "\u5728\u5efa";
            }
            case "2": {
                return "\u505c\u5de5";
            }
            case "3": {
                return "\u5b8c\u5de5";
            }
            case "4": {
                return "\u4fdd\u4fee";
            }
            case "5": {
                return "\u5176\u4ed6";
            }
        }
        return "\u65e0";
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap, Map<String, String> filedTypeMap, String searchText) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map.Entry<String, Parameter> entry : paramMap.entrySet()) {
            Parameter param = entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)entry.getKey(), (Object)param.getValue().toString()));
                continue;
            }
            if ("in".equals(param.getType())) {
                Object inParam = param.getValue();
                if (inParam instanceof String) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                    continue;
                }
                if (!(inParam instanceof JSONArray)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)inParam), Long.class)));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                String v1 = dataArr[0];
                String v2 = dataArr[1];
                if ("time".equals(filedTypeMap.get(entry.getKey()))) {
                    v1 = null != v1 && StringUtils.isNotBlank((CharSequence)v1.toString()) ? sdf.format((Date)DateUtil.parse((String)v1.toString())) : v1;
                    v2 = null != v2 && StringUtils.isNotBlank((CharSequence)v2.toString()) ? sdf.format((Date)DateUtil.parse((String)v2.toString())) : v2;
                }
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).from((Object)v1).to((Object)v2).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lte((Object)param.getValue().toString()));
        }
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            BoolQueryBuilder should = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchText, (String[])new String[]{"orgName"})).should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchText, (String[])new String[]{"contractName"})).should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchText, (String[])new String[]{"supplierName"}));
            boolQuery.must((QueryBuilder)should);
        }
        return boolQuery;
    }

    public IPage<JSONObject> queryPageList(String indexName, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap, boolean isHighLightSearchFields) {
        IPage<JSONObject> page = new IPage<JSONObject>();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highlightBuilder.preTags(new String[]{"<span style=\"color:red\">"});
        highlightBuilder.postTags(new String[]{"</span>"});
        if (CollectionUtils.isNotEmpty(heightFields)) {
            for (String field : heightFields) {
                highlightBuilder.field(field);
            }
        } else {
            highlightBuilder.field("*").requireFieldMatch(Boolean.valueOf(false));
        }
        sourceBuilder.highlighter(highlightBuilder);
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        try {
            boolQuery = this.setParam(boolQuery, paramMap, filedTypeMap, queryParam.getSearchText());
            if (CollectionUtils.isNotEmpty((Collection)queryParam.getComplexParams())) {
                boolQuery.must((QueryBuilder)this.parseComplexParams(queryParam.getComplexParams(), filedTypeMap));
            }
            sourceBuilder.query((QueryBuilder)boolQuery);
            LinkedHashMap orderMap = queryParam.getOrderMap();
            if (orderMap.isEmpty()) {
                sourceBuilder.sort(new FieldSortBuilder("data_sequence").unmappedType("long").order(SortOrder.ASC));
            } else {
                for (String key : orderMap.keySet()) {
                    sourceBuilder.sort(new FieldSortBuilder(key).unmappedType("number".equals(filedTypeMap.get(key)) || "pic".equals(filedTypeMap.get(key)) ? "long" : ("time".equals(filedTypeMap.get(key)) ? "date" : "text")).order("asc".equals(orderMap.get(key)) ? SortOrder.ASC : SortOrder.DESC));
                }
            }
            sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
            sourceBuilder.size(queryParam.getPageSize());
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
            searchRequest.source(sourceBuilder);
            page = this.queryPage(paramMap, searchRequest, isHighLightSearchFields);
        }
        catch (Exception e) {
            try {
                page = this.queryPage(paramMap, searchRequest, isHighLightSearchFields);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e1);
            }
        }
        return page;
    }

    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest) throws IOException {
        return this.queryPage(paramMap, searchRequest, true);
    }

    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest, boolean isHighLightSearchFields) throws IOException {
        Page page = new Page();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        if (isHighLightSearchFields) {
            for (SearchHit hit : response.getHits()) {
                Map source = hit.getSourceAsMap();
                Map highlightFields = hit.getHighlightFields();
                for (Map.Entry highlightEntry : highlightFields.entrySet()) {
                    HighlightField nameField;
                    Parameter parameter;
                    if (!paramMap.containsKey(highlightEntry.getKey()) || !StringUtils.isNotBlank((CharSequence)((parameter = paramMap.get(highlightEntry.getKey())).getValue() + "")) || (nameField = (HighlightField)highlightEntry.getValue()) == null) continue;
                    Text[] fragments = nameField.fragments();
                    StringBuilder nameTmp = new StringBuilder();
                    for (Text text : fragments) {
                        nameTmp.append(text);
                    }
                    source.put(highlightEntry.getKey(), nameTmp.toString());
                }
            }
        }
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            list.add(new JSONObject(hit.getSourceAsMap()));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap, Map<String, String> filedTypeMap) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map.Entry<String, Parameter> entry : paramMap.entrySet()) {
            Parameter param = entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)entry.getKey(), (Object)param.getValue().toString()));
                continue;
            }
            if ("in".equals(param.getType())) {
                Object inParam = param.getValue();
                if (inParam instanceof String) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                    continue;
                }
                if (!(inParam instanceof JSONArray)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)inParam), Long.class)));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                String v1 = dataArr[0];
                String v2 = dataArr[1];
                if ("time".equals(filedTypeMap.get(entry.getKey()))) {
                    this.logger.info(v1 + "," + v2);
                    v1 = null != v1 && StringUtils.isNotBlank((CharSequence)v1.toString()) ? sdf.format((Date)DateUtil.parse((String)v1.toString())) : v1;
                    v2 = null != v2 && StringUtils.isNotBlank((CharSequence)v2.toString()) ? sdf.format((Date)DateUtil.parse((String)v2.toString())) : v2;
                    boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).from((Object)v1).to((Object)v2).includeLower(true).includeUpper(true));
                    continue;
                }
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).from((Object)v1).to((Object)v2).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lte((Object)param.getValue().toString()));
        }
        return boolQuery;
    }

    private BoolQueryBuilder parseComplexParams(List<ComplexParam> complexParams, Map<String, String> filedTypeMap) throws Exception {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (ComplexParam cp : complexParams) {
            if ("and".equals(cp.getLogic())) {
                if (!cp.getParams().isEmpty()) {
                    boolQuery.must((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams(), filedTypeMap));
                }
                if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
                boolQuery.must((QueryBuilder)this.parseComplexParams(cp.getComplexParams(), filedTypeMap));
                continue;
            }
            if (!cp.getParams().isEmpty()) {
                boolQuery.should((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams(), filedTypeMap));
            }
            if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
            boolQuery.should((QueryBuilder)this.parseComplexParams(cp.getComplexParams(), filedTypeMap));
        }
        return boolQuery;
    }

    private String configQueryParam(JSONObject tableEntity, QueryParam queryParam, HttpServletRequest req) {
        if (StringUtils.isNotBlank((CharSequence)tableEntity.getString("orderItemJson"))) {
            List orderGroups = JSONArray.parseArray((String)tableEntity.getString("orderItemJson"), JSONObject.class);
            JSONObject order = null;
            for (JSONObject o : orderGroups) {
                if (null == o.get((Object)"isActive") || !o.get((Object)"isActive").toString().equals("true")) continue;
                order = o;
                break;
            }
            if (null == order && CollectionUtils.isNotEmpty((Collection)orderGroups)) {
                order = (JSONObject)orderGroups.get(0);
            }
            if (null != order && !queryParam.getOrderMap().containsKey(order.get((Object)"field").toString())) {
                queryParam.getOrderMap().put(order.get((Object)"field").toString(), order.get((Object)"sort").toString());
            }
        }
        Parameter parameter = (Parameter)queryParam.getParams().get("_treeSelectId");
        String leftTreeId = null;
        if (parameter != null) {
            leftTreeId = (String)parameter.getValue();
        }
        String url = tableEntity.getString("paramUrl");
        try {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                if (StringUtils.isNotBlank((CharSequence)leftTreeId)) {
                    url = url + (url.indexOf("?") == -1 ? "?" : "&");
                    url = url + "leftTreeId=" + leftTreeId;
                }
                if (url.indexOf("http") < 0) {
                    url = this.BaseHost + url;
                }
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("authority", req.getHeader("authority"));
                header.put("content-type", "application/json;charset=UTF-8");
                this.logger.info("\u8bf7\u6c42\u5730\u5740-{}\uff0cheader-{}", (Object)url, (Object)JSONObject.toJSONString(header));
                String respStr = HttpTookit.get((String)url, new HashMap(), header);
                CommonResponse params = (CommonResponse)JSONObject.parseObject((String)respStr, CommonResponse.class);
                if (!params.isSuccess()) {
                    this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c{}", (Object)url, (Object)params.getMsg());
                    return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c" + params.getMsg();
                }
                QueryParam q = (QueryParam)JSONObject.parseObject((String)JSONObject.toJSONString((Object)params.getData()), QueryParam.class);
                queryParam.getParams().putAll(q.getParams());
                queryParam.getComplexParams().addAll(q.getComplexParams());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c", (Object)url, (Object)e);
            return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff01";
        }
        return null;
    }
}

