package com.ejianc.business.procost.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.SubjectEntity;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.ISubjectService;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.procost.vo.SubjectMaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/setting/")
public class CostSettingApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ISettingService settingService;

	@Autowired
	private ISubjectService subjectService;

	@RequestMapping(value = "checkSettingFlag", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Boolean> checkSettingFlag(@RequestParam Long projectId) {
		List<SettingEntity> details = null;
		try {
			LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
//			lambda.eq(SettingEntity::getProjectId,projectId);
//			lambda.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
			details  = settingService.list(lambda);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			return CommonResponse.error("获取信息失败");
		}
		if(CollectionUtils.isNotEmpty(details)){
			return CommonResponse.success("该项目已成本设置",true);
		}else{
			return CommonResponse.success("该项目未成本设置",false);
		}
	}

	/**
	 * @Description querySubjects 根据项目查询科目信息
	 * @param projectId
	 */
	@RequestMapping(value = "/querySubjectsByProj", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<SubjectMaterialVO>> querySubjectsByProj(@RequestParam Long projectId) {
		List<SubjectMaterialVO> listRes = new ArrayList<>();
		try {
			LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
			lambda.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
//			lambda.eq(SettingEntity::getProjectId,projectId);
//			lambda.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
			List<SettingEntity> details = settingService.list(lambda);

			if(CollectionUtils.isNotEmpty(details)){
				SettingEntity settingEntity = details.get(0);
				LambdaQueryWrapper<SubjectEntity> lambda2 = Wrappers.<SubjectEntity>lambdaQuery();
				lambda2.eq(SubjectEntity::getTenantId,InvocationInfoProxy.getTenantid());
				lambda2.eq(SubjectEntity::getSettingId,settingEntity.getId());
				lambda2.eq(SubjectEntity::getStatus,"0");
				List<SubjectEntity> list = subjectService.list(lambda2);
				if(CollectionUtils.isNotEmpty(list)){
					listRes = BeanMapper.mapList(list, SubjectMaterialVO.class);
					listRes.forEach(e->{
						e.setMaterialCost(settingEntity.getMaterialCost());
						e.setTaxFlag(settingEntity.getTaxFlag());
					});
				}
			}
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			return CommonResponse.error("获取信息失败!!");
		}
		return CommonResponse.success("查询详情数据成功！",listRes);
	}

	/**
	 * 查询成本其间设置
	 *
	 * @return
	 */
	@GetMapping(value = "getSettingInfo")
	CommonResponse<SettingVO> getSettingInfo(@RequestParam Long orgId) {
		List<SettingEntity> list = settingService.list(new QueryWrapper<SettingEntity>().eq("org_id", orgId));
		if (CollectionUtils.isNotEmpty(list)){
			return CommonResponse.success("查询详情数据成功！",BeanMapper.map(list.get(0),SettingVO.class));
		}
		return CommonResponse.success("查询详情数据成功！");
	}
}
