/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller.api;

import com.ejianc.business.procost.bean.ShareDetailEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.vo.ShareVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/procostShare/"})
public class CostShareApi {
    @Autowired
    private IShareService service;
    @Autowired
    private IShareDetailService detailService;
    private final String DETAIL_PC = "ejc-share-frontend/#/costShare/card?id=";
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @GetMapping(value={"/api/procostShare/getByBillId"})
    public CommonResponse<ShareVO> getByBillId(@RequestParam Long billId) {
        ShareVO vo = null;
        ShareDetailEntity detail = this.detailService.getBySourceId(billId);
        if (null != detail) {
            ShareEntity entity = (ShareEntity)((Object)this.service.selectById(detail.getShareId()));
            BigDecimal sumCostMny = entity.getSumCostMny() == null ? BigDecimal.ZERO : entity.getSumCostMny();
            BigDecimal costMny = entity.getCostMny() == null ? BigDecimal.ZERO : entity.getCostMny();
            vo = (ShareVO)BeanMapper.map((Object)((Object)entity), ShareVO.class);
            vo.setSumCostMnys(sumCostMny.add(costMny));
            vo.setPcDetailUrl(this.BaseHost + "ejc-share-frontend/#/costShare/card?id=" + entity.getId().toString());
        }
        return CommonResponse.success(vo);
    }
}

