/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/procost/"})
public class CostDetailApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService costDetailService;

    @RequestMapping(value={"saveCostDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostDetailVO> saveCostDetail(@RequestBody List<CostDetailVO> list) {
        try {
            if (CollectionUtils.isNotEmpty(list)) {
                List listres = BeanMapper.mapList(list, CostDetailEntity.class);
                this.costDetailService.deleteCostDetail(((CostDetailEntity)((Object)listres.get(0))).getSourceId());
                this.costDetailService.saveBatch(listres);
            }
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u63d2\u5165\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u63d2\u5165\u6210\u529f");
    }

    @RequestMapping(value={"deleteCostDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostDetailVO> deleteCostDetail(@RequestParam Long id) {
        try {
            this.costDetailService.deleteCostDetail(id);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"updateCostDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostDetailVO> updateCostDetail(@RequestParam Long sourceId, Integer effectiveStatus) {
        try {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(CostDetailEntity::getSourceId, (Object)sourceId);
            updateWrapper.set(CostDetailEntity::getEffectiveStatus, (Object)effectiveStatus);
            this.costDetailService.update((Wrapper)updateWrapper);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u66f4\u65b0\u751f\u6548\u72b6\u6001\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u751f\u6548\u72b6\u6001\u6210\u529f");
    }

    @RequestMapping(value={"queryCostMnyByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryCostMnyByProjectId(@RequestParam Long projectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(CostDetailEntity::getProjectId, (Object)projectId);
        lambda.eq(CostDetailEntity::getProportionFlag, (Object)1);
        List list = this.costDetailService.list((Wrapper)lambda);
        BigDecimal costTaxMny = BigDecimal.ZERO;
        BigDecimal costMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            costTaxMny = list.stream().filter(item -> null != item.getHappenTaxMny()).map(CostDetailEntity::getHappenTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            costMny = list.stream().filter(item -> null != item.getHappenMny()).map(CostDetailEntity::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("costTaxMny", (Object)costTaxMny);
        jsonObject.put("costMny", (Object)costMny);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)jsonObject);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
    }

    @RequestMapping(value={"queryMnyBySubjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CostDetailVO>> queryMnyBySubjectId(@RequestParam Long projectId, @RequestParam List<Long> subjectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"SUM(happen_mny) AS happenMny,SUM(happen_tax_mny) AS happenTaxMny,subject_id AS subjectId "});
        queryWrapper.eq((Object)"projectId", (Object)projectId);
        if (CollectionUtils.isNotEmpty(subjectIds)) {
            queryWrapper.in((Object)"subjectId", subjectIds);
        }
        queryWrapper.groupBy((Object[])new String[]{"subjectId"});
        List list = this.costDetailService.list((Wrapper)queryWrapper);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, CostDetailVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", resList);
    }
}

