/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costDetail"})
public class CostDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService service;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostDetailVO> saveOrUpdate(@RequestBody CostDetailVO saveorUpdateVO) {
        CostDetailEntity entity = (CostDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CostDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CostDetailVO vo = (CostDetailVO)BeanMapper.map((Object)((Object)entity), CostDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostDetailVO> queryDetail(Long id) {
        CostDetailEntity entity = (CostDetailEntity)((Object)this.service.selectById(id));
        CostDetailVO vo = (CostDetailVO)BeanMapper.map((Object)((Object)entity), CostDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CostDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter parameter = (Parameter)param.getParams().get("subjectId");
        HashMap<Long, SubjectOrgVO> subjectMap = new HashMap<Long, SubjectOrgVO>();
        if (null != parameter) {
            String subjectId = String.valueOf(parameter.getValue());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("innerCode", new Parameter("like", (Object)subjectId));
            CommonResponse commonResponse = this.shareSubjectOrgApi.querySubjectOrg(queryParam);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                ArrayList<Long> longList = new ArrayList<Long>();
                for (SubjectOrgVO subjectOrgVO : (List)commonResponse.getData()) {
                    longList.add(subjectOrgVO.getId());
                    subjectMap.put(subjectOrgVO.getId(), subjectOrgVO);
                }
                param.getParams().put("subjectId", new Parameter("in", longList));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            Long projectId;
            CommonResponse response;
            Parameter parm = (Parameter)param.getParams().get("projectId");
            Map<Object, Object> wbsMap = new HashMap();
            if (null != parm && (response = this.shareProjectWbsApi.queryByProjectId(projectId = (Long)parm.getValue())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                wbsMap = ((List)response.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
            }
            for (CostDetailEntity detailEntity : page.getRecords()) {
                if (subjectMap.containsKey(detailEntity.getSubjectId())) {
                    SubjectOrgVO subjectOrgVO = (SubjectOrgVO)subjectMap.get(detailEntity.getSubjectId());
                    detailEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                    detailEntity.setSubjectName(subjectOrgVO.getSubjectName());
                }
                if (!wbsMap.containsKey(detailEntity.getWbsId())) continue;
                ProjectWbsVO wbsVO = (ProjectWbsVO)wbsMap.get(detailEntity.getWbsId());
                detailEntity.setWbsCode(wbsVO.getCode());
                detailEntity.setWbsName(wbsVO.getName());
            }
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTaxesByOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryTaxesByOrg(@RequestParam(value="year", required=false) String year, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryTaxesByOrg(year, orgId);
    }
}

