package com.ejianc.business.procost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procost.bean.HandshareDetailEntity;
/**
 * 成本单据
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procost_handshare")
public class HandshareEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="tax_flag")
    private String taxFlag; // 是否含税 0-是，1-否
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="period")
    private String period; // 期间
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 本期分摊成本
    @TableField(value="cost_tax_mny")
    private BigDecimal costTaxMny; // 本期分摊成本(含税)
    @TableField(value="source_id")
    private Long sourceId; // 来源主键
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="end_day")
    private String endDay; // 当前期间内的最后一天
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="cw_flag")
    private String cwFlag; // 是否财务取数 0-否，1-是
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="handshareDetailService",pidName = "handshareId")//此处有pid="xxx"，默认值pid="pid"
    private List<HandshareDetailEntity> handshareDetailList = new ArrayList<>(); // 成本单据明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getTaxFlag() {
        return taxFlag;
    }

    public void setTaxFlag(String taxFlag) {
        this.taxFlag = taxFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getEndDay() {
        return endDay;
    }

    public void setEndDay(String endDay) {
        this.endDay = endDay;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getCwFlag() {
        return cwFlag;
    }

    public void setCwFlag(String cwFlag) {
        this.cwFlag = cwFlag;
    }
    
    public List<HandshareDetailEntity> getHandshareDetailList() {
        return handshareDetailList;
    }

    public void setHandshareDetailList(List<HandshareDetailEntity> handshareDetailList) {
        this.handshareDetailList = handshareDetailList;
    }
}
