package com.ejianc.business.procost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.vo.*;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.procost.bean.ReportEntity;
import com.ejianc.business.procost.service.IReportService;

/**
 * 成本分析报告
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("report")
@Api(value = "成本分析报告", tags = {"成本分析报告"})
public class ReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "COST_REPORT";//此处需要根据实际修改

    @Autowired
    private IReportService service;

    @Autowired
    private IShareService shareService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDutyApi dutyApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReportVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ReportVO saveOrUpdateVO) {

        LambdaQueryWrapper<ReportEntity> lambda2 = Wrappers.<ReportEntity>lambdaQuery();
        lambda2.eq(ReportEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ReportEntity::getProjectId,saveOrUpdateVO.getProjectId());
        if(null!=saveOrUpdateVO.getId()){
            lambda2.ne(ReportEntity::getId,saveOrUpdateVO.getId());
        }
        lambda2.notIn(ReportEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ReportEntity> list = service.list(lambda2);
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("该项目已存在未生效单据,请先处理未生效单据！");
        }

    	ReportEntity entity = BeanMapper.map(saveOrUpdateVO, ReportEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setContractFileId(null);
    	service.saveOrUpdate(entity, false);


        LambdaQueryWrapper<ReportEntity> lambda = Wrappers.<ReportEntity>lambdaQuery();
        lambda.eq(ReportEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ReportEntity::getProjectId,saveOrUpdateVO.getProjectId());
        lambda.eq(ReportEntity::getDr,0);
        lambda.isNotNull(ReportEntity::getDutyAssessId);
        int count = service.count(lambda);
        CommonResponse<Integer> integerCommonResponse = dutyApi.queryDutyAssNumByProjectId(saveOrUpdateVO.getProjectId());
        if (integerCommonResponse.getCode() == 0){
            Integer data = integerCommonResponse.getData();
            entity.setAnalysisNum(count+"/"+data);
            service.saveOrUpdate(entity, false);
        }

        ReportVO vo = BeanMapper.map(entity, ReportVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportVO> queryDetail(@RequestParam Long id) {
    	ReportEntity entity = service.selectById(id);
    	ReportVO vo = BeanMapper.map(entity, ReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryThreeReports", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportThreeVO> queryThreeReports(Long projectId, @RequestParam(required=false) String beginPeriod,@RequestParam(required=false)  String endPeriod) {
        ReportThreeVO resVo = new ReportThreeVO();
        List<ThreeReportVO> reportVOList = shareService.getThreeReportVO2(projectId,beginPeriod,endPeriod);//beginPeriod  endPeriod  只影响实际成本
        logger.info("三算对比返回数据-----result："+JSONObject.toJSONString(reportVOList));
        if(CollectionUtils.isNotEmpty(reportVOList)){
            List<ThreeReportVO> result = reportVOList.stream().filter(ThreeReportVO -> ThreeReportVO.getParentID().equals(999L)).collect(Collectors.toList());
            logger.info("科目-----result："+JSONObject.toJSONString(result));
            if(CollectionUtils.isNotEmpty(result)){
                BigDecimal srcztjMny = result.stream().filter(item -> null != item.getYsHappenMny()).map(ThreeReportVO::getYsHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setSrcztjMny(srcztjMny);
                BigDecimal mbcbtjMny = result.stream().filter(item -> null != item.getCbHappenMny()).map(ThreeReportVO::getCbHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setMbcbtjMny(mbcbtjMny);
                BigDecimal sjcbtjMny = result.stream().filter(item -> null != item.getHappenMny()).map(ThreeReportVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setSjcbtjMny(sjcbtjMny);
                BigDecimal srsjdifMny = srcztjMny.subtract(sjcbtjMny);;//收入与实际差额
                BigDecimal srsjRate = BigDecimal.ZERO;//收入与实际比率
                if(srsjdifMny.compareTo(BigDecimal.ZERO)!=0 && srcztjMny.compareTo(BigDecimal.ZERO)!=0){
                    srsjRate = srsjdifMny.multiply(new BigDecimal(100)).divide(srcztjMny,2,BigDecimal.ROUND_HALF_DOWN);
                }
                resVo.setSrsjRate(srsjRate);

                BigDecimal mbsjdifMny = mbcbtjMny.subtract(sjcbtjMny);//目标实际差额
                BigDecimal mbsjRate = BigDecimal.ZERO;//目标实际比率
                if(mbsjdifMny.compareTo(BigDecimal.ZERO)!=0 && mbcbtjMny.compareTo(BigDecimal.ZERO)!=0){
                    mbsjRate = mbsjdifMny.multiply(new BigDecimal(100)).divide(mbcbtjMny,2,BigDecimal.ROUND_HALF_DOWN);
                }
                resVo.setMbsjRate(mbsjRate);





                result.forEach(e->{
                    e.setRowState("add");
                    if("02".equals(e.getSubjectCode())){
                        //材料费
                        resVo.setMaterialIncomeMny(e.getYsHappenMny());
                        resVo.setMaterialTargetcostMny(e.getCbHappenMny());
                        resVo.setMaterialCostMny(e.getHappenMny());
                        resVo.setMaterialSrsjMny(e.getSrsjdifMny());
                        resVo.setMaterialMbsjMny(e.getMbsjdifMny());
                    }else if("04".equals(e.getSubjectCode())){
                       //专业分包
                        resVo.setSubIncomeMny(e.getYsHappenMny());
                        resVo.setSubTargetcostMny(e.getCbHappenMny());
                        resVo.setSubCostMny(e.getHappenMny());
                        resVo.setSubSrsjMny(e.getSrsjdifMny());
                        resVo.setSubMbsjMny(e.getMbsjdifMny());
                    }else if("06".equals(e.getSubjectCode())){
                        //间接费
                        resVo.setJjfIncomeMny(e.getYsHappenMny());
                        resVo.setJjfTargetcostMny(e.getCbHappenMny());
                        resVo.setJjfCostMny(e.getHappenMny());
                        resVo.setJjfSrsjMny(e.getSrsjdifMny());
                        resVo.setJjfMbsjMny(e.getMbsjdifMny());
                    }else if("07".equals(e.getSubjectCode())){
                        //税金
                        BigDecimal sjincomeMny = e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny();
                        BigDecimal sjcostMny = e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny();
                        resVo.setSjIncomeMny(sjincomeMny);
                        resVo.setSjTargetcostMny(e.getCbHappenMny());
                        resVo.setSjCostMny(sjcostMny);
                        resVo.setSjMny(sjincomeMny.subtract(sjcostMny));
                    }

                });
                resVo.setReportDetailList(BeanMapper.mapList(result,ReportDetailVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",resVo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryNumpReports", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportNumpVO> queryNumpReports(@RequestParam Long projectId) {
        ReportNumpVO resVo = new ReportNumpVO();
        List<ThreeReportVO> reportVOList = shareService.getNumpReports(projectId,"","");
        if(CollectionUtils.isNotEmpty(reportVOList)){
            //钢筋020101
            List<ThreeReportVO> gjResult = reportVOList.stream().filter(ThreeReportVO -> ThreeReportVO.getSubjectCode().equals("020101")).collect(Collectors.toList());
            logger.info("科目钢筋-----result："+JSONObject.toJSONString(gjResult));
            if(CollectionUtils.isNotEmpty(gjResult)){
                ThreeReportVO threeReportVO = gjResult.get(0);
                resVo.setGjIncomeNum(threeReportVO.getYsNum());
                resVo.setGjTargetcostNum(threeReportVO.getCbNum());
                resVo.setGjCostNum(threeReportVO.getNum());
                resVo.setGjSrsjNum(threeReportVO.getSrsjNum());
                resVo.setGjMbsjNum(threeReportVO.getMbsjNum());
                resVo.setGjIncomeMny(threeReportVO.getYsHappenMny());
                resVo.setGjTargetcostMny(threeReportVO.getCbHappenMny());
                resVo.setGjCostMny(threeReportVO.getHappenMny());
                resVo.setGjSrsjMny(threeReportVO.getSrsjdifMny());
                resVo.setGjMbsjMny(threeReportVO.getMbsjdifMny());
            }
            //商品砼 020401
            List<ThreeReportVO> sptResult = reportVOList.stream().filter(ThreeReportVO -> ThreeReportVO.getSubjectCode().equals("020401")).collect(Collectors.toList());
            logger.info("科目商品砼-----result："+JSONObject.toJSONString(sptResult));
            if(CollectionUtils.isNotEmpty(sptResult)){
                ThreeReportVO threeReportVO = sptResult.get(0);
                resVo.setSptIncomeNum(threeReportVO.getYsNum());
                resVo.setSptTargetcostNum(threeReportVO.getCbNum());
                resVo.setSptCostNum(threeReportVO.getNum());
                resVo.setSptSrsjNum(threeReportVO.getSrsjNum());
                resVo.setSptMbsjNum(threeReportVO.getMbsjNum());
                resVo.setSptIncomeMny(threeReportVO.getYsHappenMny());
                resVo.setSptTargetcostMny(threeReportVO.getCbHappenMny());
                resVo.setSptCostMny(threeReportVO.getHappenMny());
                resVo.setSptSrsjMny(threeReportVO.getSrsjdifMny());
                resVo.setSptMbsjMny(threeReportVO.getMbsjdifMny());
            }
        }
        return CommonResponse.success("查询详情数据成功！",resVo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReportVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */

        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("orgId")){
            String orgId1 = (String) param.getParams().get("orgId").getValue();
            orgId = Long.parseLong(orgId1);
            param.getParams().remove("orgId");
        }
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ReportEntity> page = service.queryPage(param,false);
        IPage<ReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReportEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Report-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReportVO>> refReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ReportEntity> page = service.queryPage(param,false);
        IPage<ReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
